/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.sikuli.basics.Debug;
import org.sikuli.script.FindFailed;
import org.sikuli.script.Finder;
import org.sikuli.script.Image;
import org.sikuli.script.Match;
import org.sikuli.script.OCR;
import org.sikuli.script.ObserveEvent;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.SikuliXception;

public abstract class Element {
    protected static final int logLevel = 3;
    public int x = 0;
    public int y = 0;
    public int w = 0;
    public int h = 0;
    private String name = "";
    protected Object imageMissingHandler = FindFailed.getImageMissingHandler();
    private int levelWord = 3;
    private int levelLine = 2;
    protected Match lastMatch = null;
    protected Iterator<Match> lastMatches = null;
    protected long lastSearchTime = -1L;
    protected long lastFindTime = -1L;
    protected long lastSearchTimeRepeat = -1L;

    protected static void log(int level, String message, Object ... args) {
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        String caller = className.substring(className.lastIndexOf(".") + 1);
        Debug.logx(level, caller + ": " + message, args);
    }

    protected Element returnThis() {
        return this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getW() {
        return this.w;
    }

    public int getH() {
        return this.h;
    }

    protected boolean isEmpty() {
        return this.w <= 1 && this.h <= 1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void setImageMissingHandler(Object handler) {
        this.imageMissingHandler = FindFailed.setHandler(handler, ObserveEvent.Type.MISSING);
    }

    public <PSI> Match find(PSI target) throws FindFailed {
        throw new SikuliXception(String.format("Pixels: find: not implemented for", this.getClass().getCanonicalName()));
    }

    public String text() {
        return OCR.readText(this);
    }

    public String textLine() {
        return OCR.readLine(this);
    }

    public String textWord() {
        return OCR.readWord(this);
    }

    public String textChar() {
        return OCR.readChar(this);
    }

    public List<String> textLines() {
        ArrayList<String> lines = new ArrayList<String>();
        List<Match> matches = this.findLines();
        for (Match match : matches) {
            lines.add(match.getText());
        }
        return lines;
    }

    public List<String> textWords() {
        ArrayList<String> words = new ArrayList<String>();
        List<Match> matches = this.findWords();
        for (Match match : matches) {
            words.add(match.getText());
        }
        return words;
    }

    public List<Match> findLines() {
        return this.relocate(OCR.readLines(this));
    }

    public List<Match> findWords() {
        return this.relocate(OCR.readWords(this));
    }

    public Match findWord(String word) {
        Object result;
        Match match = null;
        if (!word.isEmpty() && (result = this.doFindText(word, this.levelWord, false)) != null) {
            match = this.relocate((Match)result);
        }
        return match;
    }

    public List<Match> findWords(String word) {
        Finder finder = (Finder)this.doFindText(word, this.levelWord, true);
        if (null != finder) {
            return finder.getListFor(this);
        }
        return new ArrayList<Match>();
    }

    public Match findLine(String text) {
        Object result;
        Match match = null;
        if (!text.isEmpty() && (result = this.doFindText(text, this.levelLine, false)) != null) {
            match = this.relocate((Match)result);
        }
        return match;
    }

    public List<Match> findLines(String text) {
        Finder finder = (Finder)this.doFindText(text, this.levelLine, true);
        if (null != finder) {
            return finder.getListFor(this);
        }
        return new ArrayList<Match>();
    }

    private Object doFindText(String text, int level, boolean multi) {
        Object returnValue = null;
        Finder finder = new Finder(this);
        this.lastSearchTime = new Date().getTime();
        if (level == this.levelWord) {
            if (multi) {
                if (finder.findWords(text)) {
                    returnValue = finder;
                }
            } else if (finder.findWord(text)) {
                returnValue = finder.next();
            }
        } else if (level == this.levelLine) {
            if (multi) {
                if (finder.findLines(text)) {
                    returnValue = finder;
                }
            } else if (finder.findLine(text)) {
                returnValue = finder.next();
            }
        }
        return returnValue;
    }

    public Match findText(String text) throws FindFailed {
        throw new SikuliXception(String.format("Pixels: findText: not implemented for", this.getClass().getCanonicalName()));
    }

    public Match findT(String text) throws FindFailed {
        return this.findText(text);
    }

    public Match existsText(String text) {
        throw new SikuliXception(String.format("Pixels: existsText: not implemented for", this.getClass().getCanonicalName()));
    }

    public Match existsT(String text) {
        return this.existsText(text);
    }

    public boolean hasText(String text) {
        return null != this.existsText(text);
    }

    public boolean hasT(String text) {
        return this.hasText(text);
    }

    public List<Match> findAllText(String text) {
        ArrayList matches = new ArrayList();
        throw new SikuliXception(String.format("Pixels: findAllText: not implemented for", this.getClass().getCanonicalName()));
    }

    public List<Match> findAllT(String text) {
        return this.findAllText(text);
    }

    public static <PSI> Image getImageFromTarget(PSI target) {
        if (target instanceof Pattern) {
            return ((Pattern)target).getImage();
        }
        if (target instanceof String) {
            Image img = Image.create((String)target);
            return img;
        }
        if (target instanceof Image) {
            return (Image)target;
        }
        if (target instanceof ScreenImage) {
            return new Image(((ScreenImage)target).getImage());
        }
        throw new IllegalArgumentException(String.format("SikuliX: find, wait, exists: invalid parameter: %s", target));
    }

    protected static <SFIRBS> BufferedImage getBufferedImage(SFIRBS whatEver) {
        if (whatEver instanceof String) {
            return Image.create((String)whatEver).get();
        }
        if (whatEver instanceof File) {
            return Image.create((File)whatEver).get();
        }
        if (whatEver instanceof Region) {
            return ((Region)whatEver).getImage().get();
        }
        if (whatEver instanceof Image) {
            return ((Image)whatEver).get();
        }
        if (whatEver instanceof ScreenImage) {
            return ((ScreenImage)whatEver).getImage();
        }
        if (whatEver instanceof BufferedImage) {
            return (BufferedImage)whatEver;
        }
        throw new IllegalArgumentException(String.format("Illegal OCR source: %s", whatEver != null ? whatEver.getClass() : "null"));
    }

    protected Image getImage() {
        throw new SikuliXception(String.format("Pixels: getImage: not implemented for", this.getClass().getCanonicalName()));
    }

    protected List<Match> relocate(List<Match> matches) {
        return matches;
    }

    protected Match relocate(Match match) {
        return match;
    }

    public Match getLastMatch() {
        return this.lastMatch;
    }

    public Iterator<Match> getLastMatches() {
        return this.lastMatches;
    }

    public List<Match> collectLines() {
        return this.findLines();
    }

    @Deprecated
    public List<String> collectLinesText() {
        return this.textLines();
    }

    @Deprecated
    public List<Match> collectWords() {
        return this.findWords();
    }

    @Deprecated
    public List<String> collectWordsText() {
        return this.textWords();
    }
}

