/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.script.Element;
import org.sikuli.script.Finder;
import org.sikuli.script.ImagePath;
import org.sikuli.script.Location;
import org.sikuli.script.OCR;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;

public class Image
extends Element {
    private static String logName = "Image: ";
    private static List<Image> images = Collections.synchronizedList(new ArrayList());
    private static Map<URL, Image> imageFiles = Collections.synchronizedMap(new HashMap());
    private static Map<String, URL> imageNames = Collections.synchronizedMap(new HashMap());
    private boolean bHasIOException = false;
    private String imageNameGiven = null;
    private URL fileURL = null;
    private boolean imageIsAbsolute = false;
    private BufferedImage bimg = null;
    private int bsize = 0;
    private boolean imageIsText = false;
    private boolean imageIsBundled = false;
    private boolean imageIsPattern = false;
    private Location offset = new Location(0, 0);
    private double similarity = Settings.MinSimilarity;
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final String isBImg = "__BufferedImage__";
    private static long currentMemory = 0L;
    private String hasBackup = "";
    private static boolean ideShouldReload = false;
    public boolean wasRecaptured = false;
    private int waitAfter;
    private Rectangle lastSeen = null;
    private double lastScore = 0.0;
    private int rows = 0;
    private int cols = 0;
    private int rowH = 0;
    private int colW = 0;
    private int rowHd = 0;
    private int colWd = 0;

    public static Image getDefaultInstance4py() {
        return new Image(new Screen().capture());
    }

    private Image() {
    }

    private Image(String fname, URL fURL) {
        this.init(fname, fURL);
    }

    private Image(URL fURL) {
        if (fURL != null) {
            if ("file".equals(fURL.getProtocol())) {
                this.init(fURL.getPath(), fURL);
            } else {
                this.init(Image.getNameFromURL(fURL), fURL);
            }
        } else {
            this.setName("");
        }
    }

    private void init(String fileName, URL fURL) {
        this.setName(fileName);
        if (this.getName().isEmpty() || fURL == null) {
            return;
        }
        this.fileURL = fURL;
        if (ImagePath.isImageBundled(fURL)) {
            this.imageIsBundled = true;
            this.setName(new File(this.getName()).getName());
        }
        this.load();
    }

    public static void reinit(Image img) {
        URL fURL = null;
        File imgFile = new File(img.getName());
        if (imgFile.isAbsolute()) {
            if (imgFile.exists()) {
                fURL = FileManager.makeURL(img.getName());
            }
        } else {
            fURL = imageNames.get(img.getName());
            if (fURL == null) {
                fURL = ImagePath.find(img.getName());
            }
        }
        if (fURL != null) {
            img.init(img.getName(), fURL);
        }
    }

    private Image copy() {
        Image imgTarget = new Image();
        imgTarget.setName(this.getName());
        imgTarget.setFileURL(this.fileURL);
        imgTarget.setBimg(this.bimg);
        imgTarget.setIsAbsolute(this.imageIsAbsolute);
        imgTarget.setIsText(this.imageIsText);
        imgTarget.setIsBundled(this.imageIsBundled);
        imgTarget.setLastSeen(this.getLastSeen(), this.getLastSeenScore());
        imgTarget.setHasIOException(this.hasIOException());
        if (this.isPattern()) {
            imgTarget.setSimilarity(this.similarity);
            imgTarget.setOffset(this.offset);
            imgTarget.setWaitAfter(this.waitAfter);
            imgTarget.setIsPattern(true);
        }
        return imgTarget;
    }

    public Image(BufferedImage img) {
        this(img, null);
    }

    public Image(BufferedImage img, String name) {
        this.setName(isBImg);
        if (name != null) {
            this.setName(this.getName() + name);
        }
        this.bimg = img;
        this.w = this.bimg.getWidth();
        this.h = this.bimg.getHeight();
        Image.log(3, "BufferedImage: (%d, %d)%s", this.w, this.h, name == null ? "" : " with name: " + name);
    }

    public Image(ScreenImage img) {
        this(img.getImage(), null);
    }

    public Image(ScreenImage img, String name) {
        this(img.getImage(), name);
    }

    public boolean isValid() {
        return this.fileURL != null || this.getName().contains(isBImg);
    }

    public boolean isUseable() {
        return this.isValid() || this.imageIsPattern;
    }

    public String toString() {
        return String.format((this.getName() != null ? this.getName() : "__UNKNOWN__") + ": (%dx%d)", this.w, this.h) + (this.lastSeen == null ? "" : String.format(" seen at (%d, %d) with %.2f", this.lastSeen.x, this.lastSeen.y, this.lastScore));
    }

    public String getFilename() {
        if (this.fileURL != null && "file".equals(this.fileURL.getProtocol())) {
            return new File(this.fileURL.getPath()).getAbsolutePath();
        }
        return this.getName();
    }

    public boolean hasIOException() {
        return this.bHasIOException;
    }

    public void setHasIOException(boolean state) {
        this.bHasIOException = state;
    }

    public URL getURL() {
        return this.fileURL;
    }

    public Image setFileURL(URL fileURL) {
        this.fileURL = fileURL;
        return this;
    }

    private static Image get(URL imgURL) {
        return imageFiles.get(imgURL);
    }

    private static String getNameFromURL(URL fURL) {
        if ("jar".equals(fURL.getProtocol())) {
            int n = fURL.getPath().lastIndexOf(".jar!/");
            int k = fURL.getPath().substring(0, n).lastIndexOf("/");
            if (n > -1) {
                return "JAR:" + fURL.getPath().substring(k + 1, n) + fURL.getPath().substring(n + 5);
            }
        }
        return "???:" + fURL.getPath();
    }

    public boolean isFile() {
        URL furl;
        return this.isValid() && "file".equals((furl = this.getURL()).getProtocol());
    }

    public boolean isAbsolute() {
        return this.imageIsAbsolute;
    }

    public Image setIsAbsolute(boolean val) {
        this.imageIsAbsolute = val;
        return this;
    }

    public Image setBimg(BufferedImage bimg) {
        this.bimg = bimg;
        if (bimg != null) {
            this.w = bimg.getWidth();
            this.h = bimg.getHeight();
            this.bsize = bimg.getData().getDataBuffer().getSize();
        } else {
            this.bsize = 0;
            this.w = -1;
            this.h = -1;
        }
        return this;
    }

    public static BufferedImage getSubimage(BufferedImage bimg, Rectangle rect) {
        return bimg.getSubimage(rect.x, rect.y, (int)rect.getWidth(), (int)rect.getHeight());
    }

    public static BufferedImage createSubimage(BufferedImage bimg, Rectangle rect) {
        Rectangle crop = new Rectangle(0, 0, bimg.getWidth(), bimg.getHeight()).intersection(rect);
        BufferedImage newBimg = new BufferedImage(crop.width, crop.height, bimg.getType());
        Graphics2D g2d = newBimg.createGraphics();
        g2d.drawImage((java.awt.Image)Image.getSubimage(bimg, crop), 0, 0, null);
        g2d.dispose();
        return newBimg;
    }

    public BufferedImage get() {
        if (this.bimg != null) {
            if (this.fileURL == null) {
                Image.log(4, "getImage inMemory: %s", this.getName());
            } else {
                Image.log(4, "getImage from cache: %s", this.getName());
            }
            return this.bimg;
        }
        return this.load();
    }

    public Dimension getSize() {
        return new Dimension(this.w, this.h);
    }

    private int getKB() {
        if (this.bimg == null) {
            return 0;
        }
        return this.bsize / 1024;
    }

    public BufferedImage resize(float factor) {
        return this.resize(factor, Interpolation.CUBIC);
    }

    public BufferedImage resize(float factor, Interpolation interpolation) {
        return Image.resize(this.get(), factor, interpolation);
    }

    public static BufferedImage resize(BufferedImage bimg, float factor) {
        return Image.resize(bimg, factor, Interpolation.CUBIC);
    }

    public static BufferedImage resize(BufferedImage bimg, float factor, Interpolation interpolation) {
        return Finder.Finder2.getBufferedImage(Image.cvResize(bimg, (double)factor, interpolation));
    }

    public static void resize(Mat mat, float factor) {
        Image.resize(mat, factor, Interpolation.CUBIC);
    }

    public static void resize(Mat mat, float factor, Interpolation interpolation) {
        Image.cvResize(mat, (double)factor, interpolation);
    }

    private static Mat cvResize(BufferedImage bimg, double rFactor, Interpolation interpolation) {
        Mat mat = Finder.Finder2.makeMat(bimg);
        Image.cvResize(mat, rFactor, interpolation);
        return mat;
    }

    private static void cvResize(Mat mat, double rFactor, Interpolation interpolation) {
        int newW = (int)(rFactor * (double)mat.width());
        int newH = (int)(rFactor * (double)mat.height());
        Imgproc.resize(mat, mat, new Size(newW, newH), 0.0, 0.0, interpolation.value);
    }

    public boolean isText() {
        return this.imageIsText;
    }

    public Image setIsText(boolean val) {
        this.imageIsText = val;
        return this;
    }

    public String getNameAsText() {
        return this.imageNameGiven;
    }

    private Image setIsBundled(boolean imageIsBundled) {
        this.imageIsBundled = imageIsBundled;
        return this;
    }

    public boolean isBundled() {
        return this.imageIsBundled;
    }

    public boolean isPattern() {
        return this.imageIsPattern;
    }

    public Image setIsPattern(boolean imageIsPattern) {
        this.imageIsPattern = imageIsPattern;
        return this;
    }

    public Location getOffset() {
        return this.offset;
    }

    public Image setOffset(Location offset) {
        this.offset = offset;
        return this;
    }

    public double getSimilarity() {
        return this.similarity;
    }

    public Image setSimilarity(double similarity) {
        this.similarity = similarity;
        return this;
    }

    public Image getSub(int part) {
        Rectangle r = Region.getRectangle(new Rectangle(0, 0, this.getSize().width, this.getSize().height), part);
        return this.getSub(r.x, r.y, r.width, r.height);
    }

    public Image getSub(Region reg) {
        return this.getSub(reg.x, reg.y, reg.w, reg.h);
    }

    public Image getSub(int x, int y, int w, int h) {
        BufferedImage bi = Image.createBufferedImage(w, h);
        Graphics2D g = bi.createGraphics();
        g.drawImage((java.awt.Image)this.get().getSubimage(x, y, w, h), 0, 0, null);
        g.dispose();
        return new Image(bi);
    }

    private static BufferedImage createBufferedImage(int w, int h) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] nBits = new int[]{8, 8, 8, 8};
        ComponentColorModel cm = new ComponentColorModel(cs, nBits, true, false, 3, 0);
        SampleModel sm = ((ColorModel)cm).createCompatibleSampleModel(w, h);
        DataBufferByte db = new DataBufferByte(w * h * 4);
        WritableRaster r = WritableRaster.createWritableRaster(sm, db, new Point(0, 0));
        BufferedImage bm = new BufferedImage(cm, r, false, null);
        return bm;
    }

    public static Image create(Image imgSrc) {
        return imgSrc.copy();
    }

    public static Image create(String fName) {
        Image img = Image.get(fName);
        return Image.createImageValidate(img);
    }

    public static Image create(File imageFile) {
        Image img = Image.get(imageFile.getAbsolutePath());
        return Image.createImageValidate(img);
    }

    public static Image create(Pattern p) {
        Image img = p.getImage().copy();
        img.setIsPattern(true);
        img.setSimilarity(p.getSimilar());
        img.setOffset(p.getTargetOffset());
        img.setWaitAfter(p.getTimeAfter());
        return img;
    }

    public static Image create(URL url) {
        Image img = null;
        if (url != null) {
            img = Image.get(url);
        }
        if (img == null) {
            img = new Image(url);
        }
        return Image.createImageValidate(img);
    }

    public static Image createThumbNail(String fName) {
        Image img = Image.get(fName);
        return Image.createImageValidate(img);
    }

    private static Image createImageValidate(Image img) {
        if (img == null) {
            return new Image("", null);
        }
        if (!img.isValid()) {
            if (Settings.OcrTextSearch || Settings.SwitchToText) {
                if (Image.isValidImageFilename(img.getName())) {
                    img.setIsText(false);
                } else {
                    img.setIsText(true);
                }
            } else {
                Image.log(-1, "Image not valid, but TextSearch is switched off!", new Object[0]);
            }
        }
        return img;
    }

    public static boolean isValidImageFilename(String fname) {
        String validEndings = ".png.jpg.jpeg";
        String ending = FilenameUtils.getExtension((String)fname);
        return !ending.isEmpty() && validEndings.contains(ending.toLowerCase());
    }

    public static String getValidImageFilename(String fname) {
        if (Image.isValidImageFilename(fname)) {
            return fname;
        }
        return fname + ".png";
    }

    private static synchronized long currentMemoryChange(long size, long max) {
        long maxMemory = max;
        if (max < 0L) {
            maxMemory = Settings.getImageCache() * 0x100000;
            currentMemory += size;
        }
        if (currentMemory > maxMemory) {
            while (images.size() > 0 && currentMemory > maxMemory) {
                Image first = images.remove(0);
                first.bimg = null;
                currentMemory -= (long)first.bsize;
            }
            currentMemory = maxMemory == 0L ? 0L : Math.max(0L, currentMemory);
        }
        if (size < 0L) {
            currentMemory = Math.max(0L, currentMemory);
        }
        return currentMemory;
    }

    private static long currentMemoryUp(long size) {
        return Image.currentMemoryChange(size, -1L);
    }

    private static long currentMemoryDown(long size) {
        currentMemory -= size;
        currentMemory = Math.max(0L, currentMemory);
        return Image.currentMemoryChange(-size, -1L);
    }

    private static long currentMemoryDownUp(int sizeOld, int sizeNew) {
        Image.currentMemoryDown(sizeOld);
        return Image.currentMemoryUp(sizeNew);
    }

    private static boolean isCaching() {
        return Settings.getImageCache() > 0;
    }

    public static void clearCache(int maxSize) {
        Image.currentMemoryChange(0L, maxSize);
    }

    public static void purge() {
        Image.purge(ImagePath.getBundle());
    }

    public static void purge(ImagePath.PathEntry path) {
        if (path == null) {
            return;
        }
        if (Image.isCaching()) {
            Image.purge(path.pathURL);
        }
    }

    private static synchronized void purge(URL pathURL) {
        Image img;
        ArrayList<Image> imagePurgeList = new ArrayList<Image>();
        ArrayList<String> imageNamePurgeList = new ArrayList<String>();
        Image.log(4, "purge: ImagePath: %s", pathURL.getPath());
        Iterator<Map.Entry<URL, Image>> it = imageFiles.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<URL, Image> entry = it.next();
            URL imgURL = entry.getKey();
            if (!imgURL.toString().startsWith(pathURL.toString())) continue;
            Image.log(4, "purge: URL: %s", imgURL.toString());
            img = entry.getValue();
            imagePurgeList.add(img);
            imageNamePurgeList.add(img.getName());
            it.remove();
        }
        if (!imagePurgeList.isEmpty()) {
            Iterator<Image> bit = images.iterator();
            while (bit.hasNext()) {
                img = bit.next();
                if (!imagePurgeList.contains(img)) continue;
                bit.remove();
                Image.log(4, "purge: bimg: %s", img);
                Image.currentMemoryDown(img.bsize);
            }
        }
        for (String name : imageNamePurgeList) {
            imageNames.remove(name);
        }
    }

    private static void unCache(URL imgURL) {
        Image img = imageFiles.get(imgURL);
        if (img == null) {
            return;
        }
        Image.currentMemoryDown(img.bsize);
        img.setBimg(null);
        images.remove(img);
    }

    public static void unCache(String fileName) {
        Image.unCache(FileManager.makeURL(new File(fileName).getAbsolutePath()));
    }

    public static void dump() {
        Image.dump(0);
    }

    public static void dump(int lvl) {
        if (!Image.isCaching()) {
            return;
        }
        Image.log(3, "--- start of Image dump ---", new Object[0]);
        ImagePath.dump(lvl);
        Image.log(3, "ImageFiles entries: %d", imageFiles.size());
        for (Map.Entry<URL, Image> entry : imageFiles.entrySet()) {
            Image.log(3, entry.getKey().toString(), new Object[0]);
        }
        Image.log(3, "ImageNames entries: %d", imageNames.size());
        for (Map.Entry<String, URL> name : imageNames.entrySet()) {
            Image.log(3, "%s %d KB (%s)", new File(name.getKey()).getName(), imageFiles.get(name.getValue()).getKB(), name.getValue());
        }
        if (Settings.getImageCache() == 0) {
            Image.log(3, "Cache state: switched off!", new Object[0]);
        } else {
            Image.log(3, "Cache state: Max %d MB (entries: %d  used: %d %% %d KB)", Settings.getImageCache(), images.size(), (int)(100L * currentMemory / (long)(Settings.getImageCache() * 0x100000)), (int)(currentMemory / 1024L));
        }
        Image.log(3, "--- end of Image dump ---", new Object[0]);
    }

    public static void reset() {
        Image.clearCache(0);
        imageNames.clear();
        imageFiles.clear();
    }

    public File remove() {
        URL furl = null;
        if (this.isFile()) {
            furl = this.getURL();
            Image.unCache(furl);
            return new File(furl.getPath());
        }
        return null;
    }

    public void delete() {
        File fImg = this.remove();
        if (null != fImg) {
            FileManager.deleteFileOrFolder(fImg);
        }
    }

    public boolean backup() {
        if (this.isValid()) {
            File fBack;
            File fOrg = new File(this.fileURL.getPath());
            if (FileManager.xcopy(fOrg, fBack = new File(fOrg.getParentFile(), "_BACKUP_" + fOrg.getName()))) {
                this.hasBackup = fBack.getPath();
                Image.log(3, "backup: %s created", fBack.getName());
                return true;
            }
            Image.log(-1, "backup: %s did not work", fBack.getName());
        }
        return false;
    }

    public boolean restore() {
        if (!this.hasBackup.isEmpty()) {
            File fBack = new File(this.hasBackup);
            File fOrg = new File(this.hasBackup.replace("_BACKUP_", ""));
            if (FileManager.xcopy(fBack, fOrg)) {
                Image.log(3, "restore: %s restored", fOrg.getName());
                FileManager.deleteFileOrFolder(fBack);
                this.hasBackup = "";
                return true;
            }
            Image.log(-1, "restore: %s did not work", fBack.getName());
        }
        return false;
    }

    private static Image get(String fName) {
        if (fName == null || fName.isEmpty()) {
            return null;
        }
        Image image = null;
        if (fName.startsWith("\t") && fName.endsWith("\t")) {
            fName = fName.substring(1, fName.length() - 1);
            image = new Image();
            image.setIsText(true);
        } else {
            File imageFile;
            URL imageURL = null;
            String imageFileName = Image.getValidImageFilename(fName);
            if (imageFileName.isEmpty()) {
                Image.log(-1, "not a valid image type: " + fName, new Object[0]);
                imageFileName = fName;
            }
            if ((imageFile = new File(imageFileName)).isAbsolute() && imageFile.exists()) {
                try {
                    imageURL = new URL("file", null, imageFile.getPath());
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                imageURL = imageNames.get(imageFileName);
                if (imageURL == null) {
                    imageURL = ImagePath.find(imageFileName);
                }
            }
            if (imageURL != null && Image.isCaching() && (image = imageFiles.get(imageURL)) != null && null == imageNames.get(image.getName())) {
                imageNames.put(image.getName(), imageURL);
            }
            if (image == null) {
                image = new Image(imageFileName, imageURL);
                image.setIsAbsolute(imageFile.isAbsolute());
            } else if (image.bimg != null) {
                Image.log(3, "reused: %s (%s)", image.getName(), image.fileURL);
            } else if (Settings.getImageCache() > 0) {
                image.load();
            }
        }
        image.imageNameGiven = fName;
        return image;
    }

    private BufferedImage load() {
        BufferedImage bImage = null;
        if (this.fileURL != null) {
            this.bimg = null;
            try {
                bImage = ImageIO.read(this.fileURL);
            }
            catch (Exception e) {
                Image.log(-1, "load: failed: %s", this.fileURL);
                this.bHasIOException = true;
                this.fileURL = null;
                return null;
            }
            if (this.getName() != null) {
                if (Image.isCaching()) {
                    imageFiles.put(this.fileURL, this);
                    imageNames.put(this.getName(), this.fileURL);
                }
                this.w = bImage.getWidth();
                this.h = bImage.getHeight();
                this.bsize = bImage.getData().getDataBuffer().getSize();
                Image.log(3, "loaded: %s (%s)", this.getName(), this.fileURL);
                if (Image.isCaching()) {
                    int maxMemory = Settings.getImageCache() * 0x100000;
                    Image.currentMemoryUp(this.bsize);
                    this.bimg = bImage;
                    images.add(this);
                    Image.log(3, "cached: %s (%d KB) (# %d KB %d -- %d %% of %d MB)", this.getName(), this.getKB(), images.size(), (int)(currentMemory / 1024L), (int)(100L * currentMemory / (long)maxMemory), maxMemory / 0x100000);
                }
            } else {
                Image.log(-1, "invalid! not loaded! %s", this.fileURL);
            }
        }
        return bImage;
    }

    private BufferedImage loadAgain() {
        BufferedImage bImage = null;
        if (this.fileURL != null) {
            this.bimg = null;
            try {
                bImage = ImageIO.read(this.fileURL);
            }
            catch (Exception e) {
                Image.log(-1, "loadAgain: failed: %s", this.fileURL);
                this.bHasIOException = true;
                if (Image.isCaching()) {
                    imageFiles.remove(this.fileURL);
                }
                return null;
            }
            if (Image.isCaching()) {
                imageFiles.put(this.fileURL, this);
                imageNames.put(this.getName(), this.fileURL);
            }
            this.w = bImage.getWidth();
            this.h = bImage.getHeight();
            this.bsize = bImage.getData().getDataBuffer().getSize();
            Image.log(3, "loaded again: %s (%s)", this.getName(), this.fileURL);
        }
        return bImage;
    }

    public static void reload(String fpImage) {
        URL uImage = imageNames.get(fpImage);
        if (imageFiles.containsKey(uImage)) {
            Image image = imageFiles.get(uImage);
            int sizeOld = image.bsize;
            if (null != image.loadAgain()) {
                Image.currentMemoryDownUp(sizeOld, image.bsize);
                image.setLastSeen(null, 0.0);
            }
        }
    }

    public static void setIDEshouldReload(Image img) {
        ideShouldReload = true;
        img.wasRecaptured = true;
        img.lastSeen = null;
    }

    public static boolean getIDEshouldReload() {
        boolean state = ideShouldReload;
        ideShouldReload = false;
        return state;
    }

    public boolean isRecaptured() {
        boolean state = this.wasRecaptured;
        this.wasRecaptured = false;
        return state;
    }

    public void save(String name) {
        this.save(name, ImagePath.getBundlePath());
    }

    public void save(String name, String path) {
        File fImg = new File(path, name);
        try {
            ImageIO.write((RenderedImage)this.get(), "png", fImg);
            Debug.log(3, "Image::save: %s", fImg);
        }
        catch (IOException e) {
            Debug.error("Image::save: %s did not work (%s)", fImg, e.getMessage());
        }
    }

    public int getWaitAfter() {
        return this.waitAfter;
    }

    public Image setWaitAfter(int waitAfter) {
        this.waitAfter = waitAfter;
        return this;
    }

    public Rectangle getLastSeen() {
        return this.lastSeen;
    }

    public double getLastSeenScore() {
        return this.lastScore;
    }

    public Image setLastSeen(Rectangle lastSeen, double sim) {
        this.lastSeen = lastSeen;
        this.lastScore = sim;
        return this;
    }

    public Image setRows(int n) {
        return this.setRaster(n, 0);
    }

    public Image setCols(int n) {
        return this.setRaster(0, n);
    }

    public int getRows() {
        return this.rows;
    }

    public int getRowH() {
        return this.rowH;
    }

    public int getCols() {
        return this.cols;
    }

    public int getColW() {
        return this.colW;
    }

    public Image setRaster(int r, int c) {
        this.rows = r;
        this.cols = c;
        if (r > 0) {
            this.rowH = this.getSize().height / r;
            this.rowHd = this.getSize().height - r * this.rowH;
        }
        if (c > 0) {
            this.colW = this.getSize().width / c;
            this.colWd = this.getSize().width - c * this.colW;
        }
        return this.getCell(0, 0);
    }

    public Image getRow(int r) {
        if (this.rows == 0) {
            return this;
        }
        if (r < 0) {
            r = this.rows + r;
        }
        r = Math.max(0, r);
        r = Math.min(r, this.rows - 1);
        return this.getSub(0, r * this.rowH, this.getSize().width, this.rowH);
    }

    public Image getCol(int c) {
        if (this.cols == 0) {
            return this;
        }
        if (c < 0) {
            c = this.cols + c;
        }
        c = Math.max(0, c);
        c = Math.min(c, this.cols - 1);
        return this.getSub(c * this.colW, 0, this.colW, this.getSize().height);
    }

    public Image getCell(int r, int c) {
        if (this.rows == 0) {
            return this.getCol(c);
        }
        if (this.cols == 0) {
            return this.getRow(r);
        }
        if (this.rows == 0 && this.cols == 0) {
            return this;
        }
        if (r < 0) {
            r = this.rows - r;
        }
        if (c < 0) {
            c = this.cols - c;
        }
        r = Math.max(0, r);
        r = Math.min(r, this.rows - 1);
        c = Math.max(0, c);
        c = Math.min(c, this.cols - 1);
        return this.getSub(c * this.colW, r * this.rowH, this.colW, this.rowH);
    }

    public static String text(String imgFile) {
        return OCR.readText(imgFile);
    }

    public static String textLine(String imgFile) {
        return OCR.readLine(imgFile);
    }

    public static String textWord(String imgFile) {
        return OCR.readWord(imgFile);
    }

    public static String textChar(String imgFile) {
        return OCR.readChar(imgFile);
    }

    public static enum Interpolation {
        NEAREST(0),
        LINEAR(1),
        CUBIC(2),
        AREA(3),
        LANCZOS4(4),
        LINEAR_EXACT(5),
        MAX(7);

        private int value;

        private Interpolation(int value) {
            this.value = value;
        }
    }
}

