/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.runnerSupport;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.python.core.BytecodeLoader;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.script.ImagePath;
import org.sikuli.script.SikulixForJython;
import org.sikuli.script.runnerSupport.IRunnerSupport;
import org.sikuli.script.support.RunTime;

public class JythonSupport
implements IRunnerSupport {
    private static final String me = "Jython: ";
    private static int lvl = 3;
    private static JythonSupport instance = null;
    private static PythonInterpreter interpreter = null;
    private static RunTime runTime;
    static Class cPyMethod;
    static Class cPyException;
    static Class cPyInstance;
    static Class cPyFunction;
    private static String[] SCRIPT_HEADER;
    List<String> sysPath = new ArrayList<String>();
    int nPathAdded = 0;
    int nPathSaved = -1;
    private List<File> importedScripts = new ArrayList<File>();
    String name = "";
    private long lastRun = 0L;
    List<String> sysArgv = new ArrayList<String>();
    private int errorLine;
    private int errorColumn;
    private String errorCause;
    private String errorText;
    private int errorType;
    private String errorTrace;
    private static final int PY_SYNTAX = 0;
    private static final int PY_RUNTIME = 1;
    private static final int PY_JAVA = 2;
    private static final int SX_RUNTIME = 3;
    private static final int SX_ABORT = 4;
    private static final int PY_UNKNOWN = -1;
    private static String NL;
    static Class cPyString;

    public void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    private void logp(String message, Object ... args) {
        Debug.logx(-3, message, args);
    }

    private void logp(int level, String message, Object ... args) {
        if (level <= Debug.getDebugLevel()) {
            this.logp(message, args);
        }
    }

    private JythonSupport() {
    }

    public static JythonSupport get() {
        if (null == instance) {
            instance = new JythonSupport();
            JythonSupport.init();
        }
        return instance;
    }

    public static boolean isSupported() {
        try {
            Class.forName("org.python.util.PythonInterpreter");
            return true;
        }
        catch (ClassNotFoundException ex) {
            Debug.log(-1, "no Jython on classpath --- consult the docs for a solution, if needed", new Object[0]);
            return false;
        }
    }

    private static void init() {
        try {
            Class.forName("org.python.util.PythonInterpreter");
        }
        catch (Exception ex) {
            Debug.log("Jython: not found on classpath", new Object[0]);
            return;
        }
        runTime = RunTime.get();
        runTime.exportLib();
        try {
            interpreter = new PythonInterpreter();
            cPyException = Class.forName("org.python.core.PyException");
            cPyFunction = Class.forName("org.python.core.PyFunction");
            cPyMethod = Class.forName("org.python.core.PyMethod");
            cPyInstance = Class.forName("org.python.core.PyInstance");
            cPyString = Class.forName("org.python.core.PyString");
        }
        catch (Exception ex) {
            instance.log(-1, "reflection problem: %s", ex.getMessage());
            interpreter = null;
        }
        JythonSupport.runTime.isJythonReady = true;
    }

    public PythonInterpreter interpreterGet() {
        return interpreter;
    }

    public void interpreterCleanup() {
        if (null != interpreter) {
            interpreter.cleanup();
        }
    }

    public void interpreterClose() {
        if (null != interpreter) {
            interpreter.close();
        }
    }

    public boolean interpreterRedirect(PrintStream stdout, PrintStream stderr) {
        if (interpreter == null) {
            return false;
        }
        try {
            interpreter.setOut((OutputStream)stdout);
        }
        catch (Exception e) {
            this.log(-1, "Jython: redirect STDOUT: %s", e.getMessage());
            return false;
        }
        try {
            interpreter.setErr((OutputStream)stderr);
        }
        catch (Exception e) {
            this.log(-1, "Jython: redirect STDERR: %s", e.getMessage());
            return false;
        }
        return true;
    }

    public Object interpreterEval(String expression) {
        if (interpreter == null) {
            return "";
        }
        return interpreter.eval(expression);
    }

    public boolean interpreterExecString(String script) {
        interpreter.exec(script);
        return true;
    }

    public void interpreterExecCode(File compiledScript) {
        String scriptFile = compiledScript.getAbsolutePath();
        byte[] data = new byte[]{};
        try {
            data = FileUtils.readFileToByteArray((File)compiledScript);
        }
        catch (IOException e) {
            this.log(-1, "exec compiled script: %s", e.getMessage());
        }
        PyCode pyCode = BytecodeLoader.makeCode((String)FilenameUtils.getBaseName((String)scriptFile), (byte[])data, (String)scriptFile);
        interpreter.exec((PyObject)pyCode);
    }

    public void interpreterExecFile(String script) {
        interpreter.execfile(script);
    }

    public void executeScriptHeader(List<String> codeBefore) {
        for (String line : SCRIPT_HEADER) {
            this.log(lvl + 1, "executeScriptHeader: %s", line);
            this.interpreterExecString(line);
        }
        if (codeBefore != null) {
            for (String line : codeBefore) {
                this.interpreterExecString(line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSysPath() {
        List<String> list = this.sysPath;
        synchronized (list) {
            if (null == interpreter) {
                return;
            }
            this.sysPath.clear();
            try {
                PySystemState pyState = interpreter.getSystemState();
                PyList pyPath = pyState.path;
                int pathLen = pyPath.__len__();
                for (int i = 0; i < pathLen; ++i) {
                    String entry = (String)pyPath.get(i);
                    this.log(lvl + 1, "sys.path[%2d] = %s", i, entry);
                    this.sysPath.add(entry);
                }
            }
            catch (Exception ex) {
                this.sysPath.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSysPath() {
        List<String> list = this.sysPath;
        synchronized (list) {
            if (null == interpreter || null == this.sysPath) {
                return;
            }
            try {
                String entry;
                int i;
                PySystemState pyState = interpreter.getSystemState();
                PyList pyPath = pyState.path;
                int pathLen = pyPath.__len__();
                for (i = 0; i < pathLen && i < this.sysPath.size(); ++i) {
                    entry = this.sysPath.get(i);
                    this.log(lvl + 1, "sys.path.set[%2d] = %s", i, entry);
                    pyPath.set(i, (Object)entry);
                }
                if (pathLen < this.sysPath.size()) {
                    for (i = pathLen; i < this.sysPath.size(); ++i) {
                        entry = this.sysPath.get(i);
                        this.log(lvl + 1, "sys.path.add[%2d] = %s", i, entry);
                        pyPath.add((Object)entry);
                    }
                }
                if (pathLen > this.sysPath.size()) {
                    for (i = this.sysPath.size(); i < pathLen; ++i) {
                        entry = (String)pyPath.get(i);
                        this.log(lvl + 1, "sys.path.rem[%2d] = %s", i, entry);
                        pyPath.remove(i);
                    }
                }
            }
            catch (Exception ex) {
                this.sysPath.clear();
            }
        }
    }

    public void addSysPath(File fFolder) {
        this.addSysPath(fFolder.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSysPath(String fpFolder) {
        List<String> list = this.sysPath;
        synchronized (list) {
            if (!this.hasSysPath(fpFolder)) {
                this.sysPath.add(0, fpFolder);
                this.setSysPath();
                ++this.nPathAdded;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendSysPath(String fpFolder) {
        List<String> list = this.sysPath;
        synchronized (list) {
            if (!this.hasSysPath(fpFolder)) {
                this.sysPath.add(fpFolder);
                this.setSysPath();
                ++this.nPathAdded;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSysPath(String fpFolder, int n) {
        List<String> list = this.sysPath;
        synchronized (list) {
            if (n < 1 || n > this.sysPath.size()) {
                this.addSysPath(fpFolder);
            } else {
                this.sysPath.add(n, fpFolder);
                this.setSysPath();
                ++this.nPathAdded;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSysPath(File fFolder) {
        List<String> list = this.sysPath;
        synchronized (list) {
            this.getSysPath();
            this.sysPath.add(this.nPathSaved > -1 ? this.nPathSaved : 0, fFolder.getAbsolutePath());
            this.setSysPath();
            this.nPathSaved = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSysPath(File fFolder) {
        List<String> list = this.sysPath;
        synchronized (list) {
            int n = this.getSysPathEntry(fFolder);
            if (-1 < n) {
                int n2;
                this.sysPath.remove(n);
                this.nPathSaved = n;
                this.setSysPath();
                if (this.nPathAdded == 0) {
                    n2 = 0;
                } else {
                    int n3 = this.nPathAdded;
                    n2 = n3;
                    this.nPathAdded = n3 - 1;
                }
                this.nPathAdded = n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSysPath(String fpFolder) {
        List<String> list = this.sysPath;
        synchronized (list) {
            this.getSysPath();
            for (String fpPath : this.sysPath) {
                if (!FileManager.pathEquals(fpPath, fpFolder)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSysPathEntry(File fFolder) {
        List<String> list = this.sysPath;
        synchronized (list) {
            this.getSysPath();
            int n = 0;
            for (String fpPath : this.sysPath) {
                if (FileManager.pathEquals(fpPath, fFolder.getAbsolutePath())) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showSysPath() {
        List<String> list = this.sysPath;
        synchronized (list) {
            if (Debug.is(lvl)) {
                this.getSysPath();
                this.log(lvl, "***** sys.path", new Object[0]);
                for (int i = 0; i < this.sysPath.size(); ++i) {
                    if (this.sysPath.get(i).startsWith("__")) continue;
                    this.logp(lvl, "%2d: %s", i, this.sysPath.get(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSitePackages() {
        List<String> list = this.sysPath;
        synchronized (list) {
            String fpBundle;
            File fLibFolder = JythonSupport.runTime.fSikulixLib;
            File fSitePackages = new File(fLibFolder, "site-packages");
            if (fSitePackages.exists()) {
                this.addSysPath(fSitePackages);
                if (this.hasSysPath(fSitePackages.getAbsolutePath())) {
                    this.log(lvl, "added as Jython::sys.path[0]:\n%s", fSitePackages);
                }
                File fSites = new File(fSitePackages, "sites.txt");
                String sSites = "";
                if (fSites.exists() && !(sSites = FileManager.readFileToString(fSites)).isEmpty()) {
                    String[] listSites;
                    this.log(lvl, "found Lib/site-packages/sites.txt", new Object[0]);
                    for (String site : listSites = sSites.split("\n")) {
                        String path = site.trim();
                        if (path.startsWith("#") || path.isEmpty()) continue;
                        this.addSysPath(path);
                        this.log(lvl, "added as Jython::sys.path[0] from Lib/site-packages/sites.txt:\n%s", path);
                    }
                }
            }
            if ((fpBundle = ImagePath.getBundlePath()) != null) {
                this.addSysPath(fpBundle);
            }
        }
    }

    public void reloadImported() {
        if (this.lastRun > 0L) {
            for (File fMod : this.importedScripts) {
                this.name = this.getPyName(fMod);
                if (new File(fMod, this.name + ".py").lastModified() <= this.lastRun) continue;
                this.log(lvl, "reload: %s", fMod);
                this.interpreterExecString("reload(" + this.name + ")");
            }
        }
        this.lastRun = new Date().getTime();
    }

    private String getPyName(File fMod) {
        String ending = ".sikuli";
        String name = fMod.getName();
        if (name.endsWith(ending)) {
            name = name.substring(0, name.length() - ending.length());
        }
        return name;
    }

    public String findModule(String modName, Object packPath, Object sysPath) {
        if (modName.endsWith(".*")) {
            this.log(lvl + 1, "findModule: %s", modName);
            return null;
        }
        if (packPath != null) {
            this.log(lvl + 1, "findModule: in pack: %s (%s)", modName, packPath);
            return null;
        }
        int nDot = modName.lastIndexOf(".");
        String modNameFull = modName;
        if (nDot > -1) {
            modName = modName.substring(nDot + 1);
        }
        File fModule = null;
        if (ImagePath.getBundlePath() != null) {
            File fParentBundle = new File(ImagePath.getBundlePath()).getParentFile();
            fModule = this.existsModule(modName, fParentBundle);
        }
        if (fModule == null && (fModule = this.existsSysPathModule(modName)) == null) {
            return null;
        }
        this.log(lvl + 1, "findModule: final: %s [%s]", fModule.getName(), fModule.getParent());
        if (fModule.getName().endsWith(".sikuli")) {
            this.importedScripts.add(fModule);
            return fModule.getAbsolutePath();
        }
        return null;
    }

    public String loadModulePrepare(String modName, String modPath) {
        this.log(lvl + 1, "loadModulePrepare: %s in %s", modName, modPath);
        int nDot = modName.lastIndexOf(".");
        if (nDot > -1) {
            modName = modName.substring(nDot + 1);
        }
        this.addSysPath(modPath);
        if (modPath.endsWith(".sikuli")) {
            ImagePath.add(modPath);
        }
        return modName;
    }

    private File existsModule(String mName, File fFolder) {
        if (mName.endsWith(".sikuli") || mName.endsWith(".py")) {
            return null;
        }
        File fSikuli = new File(fFolder, mName + ".sikuli");
        if (fSikuli.exists()) {
            return fSikuli;
        }
        File fPython = new File(fFolder, mName + ".py");
        if (fPython.exists()) {
            return fPython;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File existsSysPathModule(String modname) {
        List<String> list = this.sysPath;
        synchronized (list) {
            String fpPath;
            this.getSysPath();
            File fModule = null;
            Iterator<String> iterator = this.sysPath.iterator();
            while (iterator.hasNext() && null == (fModule = this.existsModule(modname, new File(fpPath = iterator.next())))) {
            }
            return fModule;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File existsSysPathJar(String fpJar) {
        List<String> list = this.sysPath;
        synchronized (list) {
            String fpPath;
            this.getSysPath();
            File fJar = null;
            Iterator<String> iterator = this.sysPath.iterator();
            while (iterator.hasNext() && !(fJar = new File(fpPath = iterator.next(), fpJar)).exists()) {
                fJar = null;
            }
            return fJar;
        }
    }

    public void interpreterFillSysArgv(File pyFile, String[] argv) {
        ArrayList<String> jyargv = new ArrayList<String>();
        jyargv.add(pyFile.getAbsolutePath());
        if (argv != null) {
            jyargv.addAll(Arrays.asList(argv));
        }
        this.setSysArgv(jyargv);
    }

    public List<String> getSysArgv() {
        this.sysArgv = new ArrayList<String>();
        if (null == interpreter) {
            this.sysArgv = null;
            return null;
        }
        try {
            PyList pyArgv = JythonSupport.interpreter.getSystemState().argv;
            Integer argvLen = pyArgv.__len__();
            for (int i = 0; i < argvLen; ++i) {
                String entry = (String)pyArgv.get(i);
                this.log(lvl + 1, "sys.path[%2d] = %s", i, entry);
                this.sysArgv.add(entry);
            }
        }
        catch (Exception ex) {
            this.sysArgv = null;
        }
        return this.sysArgv;
    }

    public void setSysArgv(List<String> args) {
        if (null == interpreter) {
            return;
        }
        try {
            PyList pyArgv = JythonSupport.interpreter.getSystemState().argv;
            pyArgv.clear();
            for (String arg : args) {
                pyArgv.add((Object)arg);
            }
        }
        catch (Exception ex) {
            this.sysArgv = null;
        }
    }

    public boolean prepareRobot() {
        if (runTime.isRunningFromJar()) {
            File fLibRobot = new File(JythonSupport.runTime.fSikulixLib, "robot");
            if (!fLibRobot.exists()) {
                this.log(-1, "prepareRobot: not available: %s", fLibRobot);
                return false;
            }
            if (!this.hasSysPath(JythonSupport.runTime.fSikulixLib.getAbsolutePath())) {
                this.insertSysPath(JythonSupport.runTime.fSikulixLib);
            }
        }
        if (!this.hasSysPath(new File(Settings.BundlePath).getParent())) {
            this.appendSysPath(new File(Settings.BundlePath).getParent());
        }
        this.interpreterExecString("import robot");
        return true;
    }

    public String getCurrentLine() {
        String trace = "";
        Object frame = null;
        Object back = null;
        try {
            Method mGetFrame = Class.forName("org.python.core.Py").getMethod("getFrame", new Class[0]);
            Class<?> cPyFrame = Class.forName("org.python.core.PyFrame");
            Field fLineno = cPyFrame.getField("f_lineno");
            Field fCode = cPyFrame.getField("f_code");
            Field fBack = cPyFrame.getField("f_back");
            Class<?> cPyBaseCode = Class.forName("org.python.core.PyBaseCode");
            Field fFilename = cPyBaseCode.getField("co_filename");
            frame = mGetFrame.invoke(Class.forName("org.python.core.Py"), (Object[])null);
            back = fBack.get(frame);
            if (null == back) {
                trace = "Jython: at " + this.getCurrentLineTraceElement(fLineno, fCode, fFilename, frame);
            } else {
                trace = "Jython traceback - current first:\n" + this.getCurrentLineTraceElement(fLineno, fCode, fFilename, frame);
                while (null != back) {
                    String line = this.getCurrentLineTraceElement(fLineno, fCode, fFilename, back);
                    if (!line.startsWith("Region (")) {
                        trace = trace + "\n" + line;
                    }
                    back = fBack.get(back);
                }
            }
        }
        catch (Exception ex) {
            trace = String.format("Jython: getCurrentLine: INSPECT EXCEPTION: %s", ex);
        }
        return trace;
    }

    private String getCurrentLineTraceElement(Field fLineno, Field fCode, Field fFilename, Object frame) {
        String trace = "";
        try {
            int lineno = fLineno.getInt(frame);
            Object code = fCode.get(frame);
            Object filename = fFilename.get(code);
            String fname = FileManager.getName((String)filename);
            fname = fname.replace(".py", "");
            trace = String.format("%s (%d)", fname, lineno);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return trace;
    }

    public int findErrorSource(Throwable throwable, String filename) {
        this.log(lvl + 1, "Run Script Error: %s", throwable);
        String err = throwable.toString().replaceAll("\\r", "");
        Class<?> errorClass = throwable.getClass();
        Class<?> pySyntaxError = null;
        try {
            pySyntaxError = Class.forName("org.python.core.PySyntaxError");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.errorType = errorClass.equals(PyException.class) ? 1 : (errorClass.equals(pySyntaxError) ? 0 : 2);
        this.errorLine = -1;
        this.errorColumn = -1;
        this.errorCause = "--UnKnown--";
        this.errorText = "--UnKnown--";
        Pattern pFile = Pattern.compile("File..(.*?\\.py).*?,.*?line.*?(\\d+),.*?in(.*?)" + NL + "(.*?)" + NL);
        Matcher mFile = null;
        if (2 != this.errorType) {
            Pattern pLineS;
            Matcher mLine;
            if (1 == this.errorType) {
                Pattern pError = Pattern.compile(NL + "(.*?):.(.*)$");
                mFile = pFile.matcher(err);
                if (mFile.find()) {
                    this.log(lvl + 2, "Runtime error line: " + mFile.group(2) + "\n in function: " + mFile.group(3) + "\n statement: " + mFile.group(4), new Object[0]);
                    this.errorLine = Integer.parseInt(mFile.group(2));
                    Matcher mError = pError.matcher(err);
                    if (mError.find()) {
                        this.log(lvl + 2, "Error:" + mError.group(1), new Object[0]);
                        this.log(lvl + 2, "Error:" + mError.group(2), new Object[0]);
                        this.errorCause = mError.group(1);
                        this.errorText = mError.group(2);
                    } else {
                        Pattern pFF = Pattern.compile(": FindFailed: (.*?)" + NL);
                        Matcher mFF = pFF.matcher(err);
                        if (mFF.find()) {
                            this.errorCause = "FindFailed";
                            this.errorText = mFF.group(1);
                        } else {
                            this.errorType = -1;
                        }
                    }
                }
            } else if (this.errorType == 0 && (mLine = (pLineS = Pattern.compile(", (\\d+), (\\d+),")).matcher(err)).find()) {
                this.log(lvl + 2, "SyntaxError error line: " + mLine.group(1), new Object[0]);
                Pattern pText = Pattern.compile("\\((.*?)\\(");
                Matcher mText = pText.matcher(err);
                mText.find();
                this.errorText = mText.group(1) == null ? this.errorText : mText.group(1);
                this.log(lvl + 2, "SyntaxError: " + this.errorText, new Object[0]);
                this.errorLine = Integer.parseInt(mLine.group(1));
                this.errorColumn = Integer.parseInt(mLine.group(2));
                this.errorCause = "SyntaxError";
            }
        }
        String msg = String.format("script [ %s ]", new File(filename).getName().replace(".py", ""));
        if (this.errorLine != -1) {
            msg = msg + " stopped with error in line " + this.errorLine;
            if (this.errorColumn != -1) {
                msg = msg + " at column " + this.errorColumn;
            }
        } else {
            msg = msg + " stopped with error at line --unknown--";
        }
        if (this.errorType == 1 || this.errorType == 0) {
            if (this.errorText.startsWith(this.errorCause)) {
                if (this.errorText.startsWith("java.lang.RuntimeException: SikuliX: ")) {
                    this.errorText = this.errorText.replace("java.lang.RuntimeException: SikuliX: ", "sikulix.RuntimeException: ");
                    this.errorType = 3;
                } else if (this.errorText.startsWith("java.lang.ThreadDeath")) {
                    this.errorType = 4;
                }
            }
            if (this.errorType != 4) {
                Debug.error(msg, new Object[0]);
                Debug.error(this.errorCause + " ( " + this.errorText + " )", new Object[0]);
            }
            if (this.errorType == 1) {
                mFile = pFile.matcher(err);
                this.errorTrace = this.findErrorSourceWalkTrace(mFile, filename);
                if (this.errorTrace.length() > 0) {
                    Debug.error("--- Traceback --- error source first\nline: module ( function ) statement \n" + this.errorTrace + "[error] --- Traceback --- end --------------", new Object[0]);
                }
            }
        } else {
            Debug.error(msg, new Object[0]);
            Debug.error("Error caused by: %s", err);
        }
        return this.errorLine;
    }

    private String findErrorSourceWalkTrace(Matcher m, String filename) {
        Pattern pModule = JythonSupport.runTime.runningWindows ? Pattern.compile(".*\\\\(.*?)\\.py") : Pattern.compile(".*/(.*?)\\.py");
        String modIgnore = "SikuliImporter,Region,";
        StringBuilder trace = new StringBuilder();
        while (m.find()) {
            String mod;
            if (m.group(1).equals(filename)) {
                mod = "main";
            } else {
                Matcher mModule = pModule.matcher(m.group(1));
                mModule.find();
                mod = mModule.group(1);
                if (modIgnore.contains(mod + ",")) continue;
            }
            String telem = m.group(2) + ": " + mod + " ( " + m.group(3) + " ) " + m.group(4) + NL;
            trace.insert(0, telem);
        }
        return trace.toString();
    }

    private void findErrorSourceFromJavaStackTrace(Throwable thr, String filename) {
        this.log(-1, "findErrorSourceFromJavaStackTrace: seems to be an error in the Java API supporting code", new Object[0]);
        for (Throwable t = thr; t != null; t = t.getCause()) {
            StackTraceElement[] s = t.getStackTrace();
            this.log(lvl + 2, "stack trace:", new Object[0]);
            for (int i = s.length - 1; i >= 0; --i) {
                StackTraceElement si = s[i];
                this.log(lvl + 2, si.getLineNumber() + " " + si.getFileName(), new Object[0]);
                if (si.getLineNumber() < 0 || !filename.equals(si.getFileName())) continue;
                this.errorLine = si.getLineNumber();
            }
            this.log(lvl + 2, "cause: " + t, new Object[0]);
        }
    }

    public int runJar(String fpJarOrFolder) {
        return this.runJar(fpJarOrFolder, "");
    }

    public int runJar(String fpJarOrFolder, String imagePath) {
        SikulixForJython.get();
        String fpJar = this.load(fpJarOrFolder, true);
        ImagePath.addJar(fpJar, imagePath);
        String scriptName = new File(fpJar).getName().replace("_sikuli.jar", "");
        if (this.interpreterExecString("try: reload(" + scriptName + ")\nexcept: import " + scriptName)) {
            return 0;
        }
        return -1;
    }

    public String load(String fpJarOrFolder) {
        return this.load(fpJarOrFolder, false);
    }

    public String load(String fpJar, boolean scriptOnly) {
        File fJar;
        this.log(lvl, "load: %s", fpJar);
        if (!fpJar.endsWith(".jar")) {
            fpJar = fpJar + ".jar";
        }
        if (!(fJar = new File(FileManager.normalizeAbsolute(fpJar))).exists()) {
            String fpBundle = ImagePath.getBundlePath();
            fJar = null;
            if (null != fpBundle && !(fJar = new File(fpBundle, fpJar)).exists() && !(fJar = new File(new File(fpBundle).getParentFile(), fpJar)).exists()) {
                fJar = null;
            }
            if (fJar == null && !(fJar = new File(JythonSupport.runTime.fSikulixExtensions, fpJar)).exists() && !(fJar = new File(JythonSupport.runTime.fSikulixLib, fpJar)).exists()) {
                fJar = null;
            }
        }
        if (fJar == null) {
            this.log(-1, "load: not found: %s", fJar);
            return fpJar;
        }
        if (!this.hasSysPath(fJar.getPath())) {
            this.insertSysPath(fJar);
        }
        return fJar.getAbsolutePath();
    }

    public boolean checkCallback(Object[] args) {
        SXPyInstance inst = new SXPyInstance(args[0]);
        String mName = (String)args[1];
        Object method = inst.__getattr__(mName);
        if (method == null || !method.getClass().getName().contains("PyMethod")) {
            this.log(-100, "checkCallback: Object: %s, Method not found: %s", inst, mName);
            return false;
        }
        return true;
    }

    public boolean runLoggerCallback(Object[] args) {
        SXPyInstance inst = new SXPyInstance(args[0]);
        String mName = (String)args[1];
        String msg = (String)args[2];
        Object method = inst.__getattr__(mName);
        if (method == null || !method.getClass().getName().contains("PyMethod")) {
            this.log(-100, "runLoggerCallback: Object: %s, Method not found: %s", inst, mName);
            return false;
        }
        try {
            PyString pmsg = new PyString(msg);
            inst.invoke(mName, pmsg.get());
        }
        catch (Exception ex) {
            this.log(-100, "runLoggerCallback: invoke: %s", ex.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean runObserveCallback(Object[] args) {
        SXPyFunction func = new SXPyFunction(args[0]);
        boolean success = true;
        try {
            func.__call__(new SXPy().java2py(args[1]));
        }
        catch (Exception ex) {
            if (!func.toString().contains("<lambda>")) {
                this.log(-1, "runObserveCallback: jython invoke: %s", ex.getMessage());
                return false;
            }
            success = false;
        }
        if (success) {
            return true;
        }
        try {
            func.__call__();
        }
        catch (Exception ex) {
            this.log(-1, "runObserveCallback: jython invoke <lambda>: %s", ex.getMessage());
            return false;
        }
        return true;
    }

    public boolean runCallback(Object[] args) {
        SXPyInstance inst = (SXPyInstance)args[0];
        String mName = (String)args[1];
        Object method = inst.__getattr__(mName);
        if (method == null || !method.getClass().getName().contains("PyMethod")) {
            this.log(-1, "runCallback: Object: %s, Method not found: %s", inst, mName);
            return false;
        }
        try {
            PyString pmsg = new PyString("not yet supported");
            inst.invoke(mName, pmsg.get());
        }
        catch (Exception ex) {
            this.log(-1, "runCallback: invoke: %s", ex.getMessage());
            return false;
        }
        return true;
    }

    static {
        cPyMethod = null;
        cPyException = null;
        cPyInstance = null;
        cPyFunction = null;
        SCRIPT_HEADER = new String[]{"# -*- coding: utf-8 -*- ", "import org.sikuli.script.SikulixForJython", "from sikuli import *", "use() #resetROI()"};
        NL = "\n";
        cPyString = null;
    }

    class SXPyInstance {
        Object inst = null;
        Method mGetAttr = null;
        Method mInvoke = null;

        public SXPyInstance(Object i) {
            this.inst = i;
            cPyInstance.cast(this.inst);
            try {
                this.mGetAttr = cPyInstance.getMethod("__getattr__", String.class);
                this.mInvoke = cPyInstance.getMethod("invoke", String.class, Class.forName("org.python.core.PyObject"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Object get() {
            return this.inst;
        }

        Object __getattr__(String mName) {
            if (this.mGetAttr == null) {
                return null;
            }
            Object method = null;
            try {
                method = this.mGetAttr.invoke(this.inst, mName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return method;
        }

        public void invoke(String mName, Object arg) {
            if (this.mInvoke != null) {
                try {
                    this.mInvoke.invoke(this.inst, mName, arg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class PyString {
        String aString = "";
        Object pyString = null;

        public PyString(String s) {
            this.aString = s;
            try {
                this.pyString = cPyString.getConstructor(String.class).newInstance(this.aString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Object get() {
            return this.pyString;
        }
    }

    class SXPyFunction {
        public String __name__;
        Object func = null;
        Method mCall = null;
        Method mCall1 = null;

        public SXPyFunction(Object f) {
            this.func = f;
            try {
                cPyFunction.cast(this.func);
                this.mCall = cPyFunction.getMethod("__call__", new Class[0]);
                this.mCall1 = cPyFunction.getMethod("__call__", Class.forName("org.python.core.PyObject"));
            }
            catch (Exception ex) {
                this.func = null;
            }
            if (this.func == null) {
                try {
                    this.func = f;
                    cPyMethod.cast(this.func);
                    this.mCall = cPyMethod.getMethod("__call__", new Class[0]);
                    this.mCall1 = cPyMethod.getMethod("__call__", Class.forName("org.python.core.PyObject"));
                }
                catch (Exception ex) {
                    this.func = null;
                }
            }
        }

        void __call__(Object arg) {
            if (this.mCall1 != null) {
                try {
                    this.mCall1.invoke(this.func, arg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        void __call__() {
            if (this.mCall != null) {
                try {
                    this.mCall.invoke(this.func, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class SXPy {
        Method mJava2py = null;

        public SXPy() {
            try {
                this.mJava2py = Class.forName("org.python.core.Py").getMethod("java2py", Object.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        Object java2py(Object arg) {
            if (this.mJava2py == null) {
                return null;
            }
            Object pyObject = null;
            try {
                pyObject = this.mJava2py.invoke(null, arg);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return pyObject;
        }
    }

    class SXPyException {
        Object inst = null;
        Field fType = null;
        Field fValue = null;
        Field fTrBack = null;

        public SXPyException(Object i) {
            this.inst = i;
            cPyException.cast(this.inst);
            try {
                this.fType = cPyException.getField("type");
                this.fValue = cPyException.getField("value");
                this.fTrBack = cPyException.getField("traceback");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int isTypeExit() {
            try {
                if (this.fType.get(this.inst).toString().contains("SystemExit")) {
                    return Integer.parseInt(this.fValue.get(this.inst).toString());
                }
            }
            catch (Exception ex) {
                return -999;
            }
            return -1;
        }
    }
}

