/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sikuli.basics.Debug;
import org.sikuli.script.ObserveEvent;
import org.sikuli.script.ObserverCallBack;
import org.sikuli.script.Region;

public class Observing {
    private static final String me = "Observing: ";
    private static final int lvl = 3;
    private static final Map<String, Region> observers = Collections.synchronizedMap(new HashMap());
    private static final Map<String, ObserveEvent> events = Collections.synchronizedMap(new HashMap());
    private static final List<Region> runningObservers = Collections.synchronizedList(new ArrayList());
    private static long lastName = 0L;
    private static boolean shouldStopOnFirstEvent = false;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    private Observing() {
    }

    public static void setStopOnFirstEvent() {
        shouldStopOnFirstEvent = true;
    }

    public static boolean getStopOnFirstEvent() {
        boolean val = shouldStopOnFirstEvent;
        shouldStopOnFirstEvent = false;
        return val;
    }

    public static void addRunningObserver(Region r) {
        if (shouldStopOnFirstEvent) {
            shouldStopOnFirstEvent = false;
            r.getObserver().setStopOnFirstEvent();
        }
        runningObservers.add(r);
        Observing.log(3, "add observer: now running %d observer(s)", runningObservers.size());
    }

    public static void removeRunningObserver(Region r) {
        runningObservers.remove(r);
        Observing.log(3, "remove observer: now running %d observer(s)", runningObservers.size());
    }

    public static synchronized String add(Region reg, ObserverCallBack obs, ObserveEvent.Type type, Object target) {
        long now;
        for (now = new Date().getTime(); now <= lastName; ++now) {
        }
        lastName = now;
        String name = "" + now;
        observers.put(name, reg);
        reg.getObserver().addObserver(target, obs, name, type);
        return name;
    }

    public void setInactive(String name) {
        Observing.setActive(name, false);
    }

    public void setActive(String name) {
        Observing.setActive(name, true);
    }

    public static void setActive(String name, boolean state) {
        if (observers.containsKey(name)) {
            observers.get(name).getObserver().setActive(name, state);
        }
    }

    public static void remove(String name) {
        if (observers.containsKey(name)) {
            observers.get(name).stopObserver();
            observers.remove(name);
            events.remove(name);
        }
    }

    public static void remove(Region reg) {
        for (String name : reg.getObserver().getNames()) {
            Observing.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUp() {
        Map<String, Region> map = observers;
        synchronized (map) {
            String[] names = new String[observers.size()];
            if (observers.size() > 0) {
                int i = 0;
                for (String name : observers.keySet()) {
                    Region reg = observers.get(name);
                    if (reg.isObserving()) {
                        reg.stopObserver();
                    }
                    events.remove(name);
                    names[i++] = name;
                }
            }
            runningObservers.clear();
            if (names.length > 0) {
                for (String name : names) {
                    observers.remove(name);
                }
                Observing.log(3, "Observing: removed all observers", new Object[0]);
            }
        }
    }

    public static boolean hasEvents() {
        return events.size() > 0;
    }

    public static boolean hasEvents(Region reg) {
        for (String name : reg.getObserver().getNames()) {
            if (!events.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEvent(String name) {
        return events.containsKey(name);
    }

    public static void addEvent(ObserveEvent evt) {
        events.put(evt.getName(), evt);
    }

    public static ObserveEvent[] getEvents(Region reg) {
        ArrayList<ObserveEvent> evts = new ArrayList<ObserveEvent>();
        for (String name : reg.getObserver().getNames()) {
            ObserveEvent evt = events.get(name);
            if (evt != null) {
                evts.add(evt);
            }
            events.remove(name);
        }
        return evts.toArray(new ObserveEvent[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObserveEvent[] getEvents() {
        ArrayList<ObserveEvent> evts = new ArrayList<ObserveEvent>();
        Map<String, ObserveEvent> map = events;
        synchronized (map) {
            for (String name : events.keySet()) {
                ObserveEvent evt = events.get(name);
                if (evt != null) continue;
                evts.add(evt);
            }
        }
        return evts.toArray(new ObserveEvent[0]);
    }

    public static ObserveEvent getEvent(String name) {
        return events.remove(name);
    }

    public static void clearEvents() {
        events.clear();
    }
}

