/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.util.ArrayList;
import org.sikuli.basics.Debug;
import org.sikuli.script.Image;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Region;

public class Offset {
    public int x = 0;
    public int y = 0;

    public static Offset getDefaultInstance4py() {
        return new Offset(0, 0);
    }

    public static Offset make4py(ArrayList args) {
        Debug.log(3, "make: args: %s", args);
        Offset off = Offset.getDefaultInstance4py();
        if (null != args) {
            int argn = 1;
            for (Object arg : args) {
                Debug.log(3, "%d: %s (%s)", argn++, arg.getClass().getSimpleName(), arg);
            }
            if (args.size() == 2) {
                int num = 2;
                for (Object arg : args) {
                    if (!(arg instanceof Integer) && !(arg instanceof Double)) continue;
                    --num;
                }
                if (num == 0) {
                    off = new Offset((Integer)args.get(0), (Integer)args.get(1));
                }
            } else if (args.size() == 1) {
                off = new Offset(args.get(0));
            }
        }
        return off;
    }

    public Offset setX(int x) {
        this.x = x;
        return this;
    }

    public Offset setX(double x) {
        this.x = (int)x;
        return this;
    }

    public int getX() {
        return this.x;
    }

    public Offset setY(int y) {
        this.y = y;
        return this;
    }

    public Offset setY(double y) {
        this.y = (int)y;
        return this;
    }

    public int getY() {
        return this.y;
    }

    public Offset set(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Offset set(double x, double y) {
        this.set((int)x, (int)y);
        return this;
    }

    public Offset() {
    }

    public Offset(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public <RMILO> Offset(RMILO whatEver) {
        if (whatEver instanceof Region || whatEver instanceof Match) {
            Region what = (Region)whatEver;
            this.x = what.w;
            this.y = what.h;
        } else if (whatEver instanceof Image) {
            Image what = (Image)whatEver;
            if (null != what.get()) {
                this.x = what.get().getWidth();
                this.y = what.get().getHeight();
            }
        } else if (whatEver instanceof Location) {
            Location what = (Location)whatEver;
            this.x = what.x;
            this.y = what.y;
        } else if (whatEver instanceof Offset) {
            Offset what = (Offset)whatEver;
            this.x = what.x;
            this.y = what.y;
        }
    }

    public <RMILO> Offset modify(RMILO whatever) {
        Offset offset = new Offset(whatever);
        offset.x = this.x + offset.x;
        offset.y = this.y + offset.y;
        return offset;
    }
}

