/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.sikuli.basics.Debug;
import org.sikuli.script.support.Commons;
import org.sikuli.script.support.RunTime;

public class Options {
    int lvl = 3;
    static Options sxOptions = null;
    static RunTime runtime = null;
    private String fnSXOptions = "SikulixOptions.txt";
    private String propOptionsFile = "OptionsFile";
    private Properties options = null;
    static boolean testing = false;

    private void log(int level, String message, Object ... args) {
        Debug.logx(level, "Options: " + message, args);
    }

    private void logp(String message, Object ... args) {
        this.log(-3, message, args);
    }

    private Options() {
    }

    public Options(String fpOptions) {
        this.loadOptions(fpOptions);
    }

    public static String getOptionsFileDefault() {
        String defaultContent = "# key = value";
        return defaultContent;
    }

    public String getOptionsFile() {
        return this.getOption(this.propOptionsFile);
    }

    public static Options init(RunTime pRunTime) {
        runtime = pRunTime;
        return Options.init();
    }

    private static Options init() {
        if (sxOptions == null) {
            sxOptions = new Options();
            sxOptions.loadOptions();
        }
        return sxOptions;
    }

    void loadOptions() {
        this.loadOptions(this.fnSXOptions);
        if (this.hasOptions()) {
            testing = this.isOption("testing", false);
            if (testing) {
                Debug.setDebugLevel(3);
            }
            for (Object oKey : this.options.keySet()) {
                String sKey = (String)oKey;
                String[] parts = sKey.split("\\.");
                if (parts.length == 1) continue;
                String sClass = parts[0];
                String sAttr = parts[1];
                if (!sClass.contains("Settings")) continue;
                try {
                    Class<?> cClass = Class.forName("org.sikuli.basics.Settings");
                    Field cField = cClass.getField(sAttr);
                    Class<?> ccField = cField.getType();
                    if (ccField.getName() == "boolean") {
                        cField.setBoolean(null, this.isOption(sKey));
                        continue;
                    }
                    if (ccField.getName() == "int") {
                        cField.setInt(null, this.getOptionInteger(sKey));
                        continue;
                    }
                    if (ccField.getName() == "float") {
                        cField.setFloat(null, this.getOptionFloat(sKey));
                        continue;
                    }
                    if (ccField.getName() == "double") {
                        cField.setDouble(null, this.getOptionDouble(sKey));
                        continue;
                    }
                    if (ccField.getName() != "String") continue;
                    cField.set(null, this.getOption(sKey));
                }
                catch (Exception ex) {
                    this.log(-1, "loadOptions: not possible: %s = %s", sKey, this.options.getProperty(sKey));
                }
            }
        }
    }

    void loadOptions(String fpOptions) {
        File fOptions = new File(fpOptions);
        if (fOptions.isAbsolute()) {
            if (!fOptions.exists()) {
                fOptions = null;
                this.log(-1, "loadOptions: not exists: %s", fOptions);
            }
        } else {
            File aFile;
            File[] fileArray = new File[]{Commons.getAppDataStore(), Commons.getWorkDir(), Commons.getUserHome()};
            int n = fileArray.length;
            for (int i = 0; i < n && !(fOptions = new File(aFile = fileArray[i], fpOptions)).exists(); ++i) {
                fOptions = null;
            }
        }
        this.options = new Properties();
        if (fOptions != null) {
            try {
                FileInputStream is = new FileInputStream(fOptions);
                this.options.load(is);
                ((InputStream)is).close();
                this.log(this.lvl, "loadOptions: Options file: %s", fOptions);
                this.setOption(this.propOptionsFile, fOptions.getAbsolutePath());
            }
            catch (Exception ex) {
                this.log(-1, "loadOptions: %s: %s", fOptions, ex.getMessage());
                this.options = null;
            }
        } else {
            this.setOption(this.propOptionsFile, new File(Options.runtime.fSikulixStore, fpOptions).getAbsolutePath());
        }
    }

    public boolean saveOptions() {
        String fpOptions = this.getOption(this.propOptionsFile, null);
        if (null == fpOptions) {
            this.log(-1, "saveOptions: no prop %s", this.propOptionsFile);
            return false;
        }
        return this.saveOpts(fpOptions);
    }

    public boolean saveOpts(String fpOptions) {
        File fOptions = new File(fpOptions);
        if (!fOptions.isAbsolute()) {
            fOptions = new File(Commons.getWorkDir(), fpOptions);
        }
        try {
            this.setOption(this.propOptionsFile, fOptions.getAbsolutePath());
            FileOutputStream os = new FileOutputStream(fOptions);
            this.options.store(os, "");
            ((OutputStream)os).close();
        }
        catch (Exception ex) {
            this.log(-1, "saveOptions: %s (error %s)", fOptions, ex.getMessage());
            return false;
        }
        this.log(this.lvl, "saveOptions: saved: %s", fpOptions);
        return true;
    }

    public String getOption(String pName, String sDefault) {
        if (this.options == null) {
            return sDefault;
        }
        String pVal = this.options.getProperty(pName, sDefault);
        if (pVal.isEmpty()) {
            this.options.setProperty(pName, sDefault);
            return sDefault;
        }
        return pVal;
    }

    public String getOption(String pName) {
        return this.getOption(pName, "");
    }

    public void setOption(String pName, String sValue) {
        Options.init();
        this.options.setProperty(pName, sValue);
    }

    public int getOptionInteger(String pName, Integer nDefault) {
        if (this.options == null) {
            return nDefault;
        }
        String pVal = this.options.getProperty(pName, nDefault.toString());
        int nVal = nDefault;
        try {
            nVal = Integer.decode(pVal);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nVal;
    }

    public int getOptionInteger(String pName) {
        return this.getOptionInteger(pName, 0);
    }

    public void setOptionInteger(String pName, int nValue) {
        Options.init();
        this.options.setProperty(pName, "" + nValue);
    }

    public float getOptionFloat(String pName, float nDefault) {
        if (this.options == null) {
            return nDefault;
        }
        String pVal = this.options.getProperty(pName, "0");
        float nVal = nDefault;
        try {
            nVal = Float.parseFloat(pVal);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nVal;
    }

    public float getOptionFloat(String pName) {
        return this.getOptionFloat(pName, 0.0f);
    }

    public void setOptionFloat(String pName, float nValue) {
        Options.init();
        this.options.setProperty(pName, "" + nValue);
    }

    public double getOptionDouble(String pName, double nDefault) {
        if (this.options == null) {
            return nDefault;
        }
        String pVal = this.options.getProperty(pName, "0");
        double nVal = nDefault;
        try {
            nVal = Double.parseDouble(pVal);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nVal;
    }

    public double getOptionDouble(String pName) {
        return this.getOptionDouble(pName, 0.0);
    }

    public void setOptionDouble(String pName, double nValue) {
        Options.init();
        this.options.setProperty(pName, "" + nValue);
    }

    public boolean isOption(String pName, boolean bDefault) {
        if (this.options == null) {
            return bDefault;
        }
        String pVal = this.options.getProperty(pName, bDefault ? "true" : "false").toLowerCase();
        if (pVal.isEmpty()) {
            return bDefault;
        }
        return pVal.contains("yes") || pVal.contains("true") || pVal.contains("on");
    }

    public boolean isOption(String pName) {
        return this.isOption(pName, false);
    }

    public void setOptionBool(String pName, boolean bValue) {
        Options.init();
        this.options.setProperty(pName, this.isOption(pName, bValue) ? "true" : "false");
    }

    public boolean hasOptions() {
        return this.options != null && this.options.size() > 0;
    }

    public Map<String, String> getOptions() {
        HashMap<String, String> mapOptions = new HashMap<String, String>();
        if (this.options != null) {
            Enumeration<?> optionNames = this.options.propertyNames();
            while (optionNames.hasMoreElements()) {
                String optionName = (String)optionNames.nextElement();
                mapOptions.put(optionName, this.getOption(optionName));
            }
        }
        return mapOptions;
    }

    public void dumpOptions() {
        if (this.hasOptions()) {
            Map<String, String> mapOptions = this.getOptions();
            this.logp("*** options dump", new Object[0]);
            for (String sOpt : mapOptions.keySet()) {
                this.logp("%s = %s", sOpt, mapOptions.get(sOpt));
            }
            this.logp("*** options dump end", new Object[0]);
        }
    }
}

