/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import org.sikuli.basics.Debug;
import org.sikuli.script.Location;
import org.sikuli.script.Mouse;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.Sikulix;
import org.sikuli.util.SikulixFileChooser;

public class SX {
    private static Log log = new Log();

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private static void pause(double time) {
        try {
            Thread.sleep((int)(time * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String input(Object ... args) {
        if (!SX.isHeadless()) {
            return (String)SX.doPop(PopType.POPINPUT, args);
        }
        Log.error("running headless: input", new Object[0]);
        return null;
    }

    public static String popSelect(Object ... args) {
        if (!SX.isHeadless()) {
            return (String)SX.doPop(PopType.POPSELECT, args);
        }
        Log.error("running headless: select", new Object[0]);
        return null;
    }

    public static String popFile(Object ... args) {
        if (!SX.isHeadless()) {
            return (String)SX.doPop(PopType.POPFILE, args);
        }
        Log.error("running headless: file", new Object[0]);
        return null;
    }

    public static Boolean popup(Object ... args) {
        if (!SX.isHeadless()) {
            return (Boolean)SX.doPop(PopType.POPUP, args);
        }
        Log.error("running headless: popup", new Object[0]);
        return false;
    }

    public static Boolean popAsk(Object ... args) {
        if (!SX.isHeadless()) {
            return (Boolean)SX.doPop(PopType.POPASK, args);
        }
        Log.error("running headless: popAsk", new Object[0]);
        return false;
    }

    public static Integer popGeneric(Object ... args) {
        if (!SX.isHeadless()) {
            return (Integer)SX.doPop(PopType.POPGENERIC, args);
        }
        Log.error("running headless: popGeneric", new Object[0]);
        return -1;
    }

    public static Boolean popError(Object ... args) {
        if (!SX.isHeadless()) {
            return (Boolean)SX.doPop(PopType.POPERROR, args);
        }
        Log.error("running headless: popError", new Object[0]);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object doPop(PopType popType, Object ... args) {
        class RunInput
        implements Runnable {
            PopType popType = PopType.POPUP;
            JFrame frame = null;
            String title = "";
            String message = "";
            String preset = "";
            Boolean hidden = false;
            Integer timeout = 0;
            Object options = null;
            Map<String, Object> parameters = new HashMap<String, Object>();
            Object returnValue;

            public RunInput(PopType popType, Object ... args) {
                this.popType = popType;
                this.parameters = SX.getPopParameters(args);
                this.title = (String)this.parameters.get("title");
                this.message = (String)this.parameters.get("message");
                this.preset = (String)this.parameters.get("preset");
                this.hidden = (Boolean)this.parameters.get("hidden");
                this.timeout = (Integer)this.parameters.get("timeout");
                this.frame = SX.getFrame(this.parameters.get("location"));
                this.options = this.parameters.get("options");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.returnValue = null;
                if (PopType.POPUP.equals((Object)this.popType)) {
                    JOptionPane.showMessageDialog(this.frame, this.message, this.title, -1);
                    this.returnValue = Boolean.TRUE;
                } else if (PopType.POPASK.equals((Object)this.popType)) {
                    int ret = JOptionPane.showConfirmDialog(this.frame, this.message, this.title, 0);
                    this.returnValue = Boolean.TRUE;
                    if (ret == -1) {
                        this.returnValue = null;
                    } else if (ret == 1) {
                        this.returnValue = Boolean.FALSE;
                    }
                } else if (PopType.POPERROR.equals((Object)this.popType)) {
                    JOptionPane.showMessageDialog(this.frame, this.message, this.title, 0);
                    this.returnValue = Boolean.TRUE;
                } else if (PopType.POPINPUT.equals((Object)this.popType)) {
                    if (!this.hidden.booleanValue()) {
                        if ("".equals(this.title)) {
                            this.title = "Sikuli input request";
                        }
                        this.returnValue = JOptionPane.showInputDialog(this.frame, this.message, this.title, -1, null, null, this.preset);
                    } else {
                        JTextArea messageText = new JTextArea(this.message);
                        messageText.setColumns(20);
                        messageText.setLineWrap(true);
                        messageText.setWrapStyleWord(true);
                        messageText.setEditable(false);
                        messageText.setBackground(new JLabel().getBackground());
                        final JPasswordField passwordField = new JPasswordField(this.preset);
                        this.frame.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowOpened(WindowEvent e) {
                                frame.removeWindowListener(this);
                                new Thread(() -> {
                                    SX.pause(0.3);
                                    EventQueue.invokeLater(() -> passwordField.requestFocusInWindow());
                                }).start();
                            }
                        });
                        JPanel panel = new JPanel();
                        panel.setLayout(new BoxLayout(panel, 1));
                        panel.add(passwordField);
                        panel.add(Box.createVerticalStrut(10));
                        panel.add(messageText);
                        int retval = JOptionPane.showConfirmDialog(this.frame, panel, this.title, 2);
                        this.returnValue = "";
                        if (0 == retval) {
                            char[] pwchar = passwordField.getPassword();
                            for (int i = 0; i < pwchar.length; ++i) {
                                this.returnValue = (String)this.returnValue + pwchar[i];
                                pwchar[i] = '\u0000';
                            }
                        }
                    }
                } else if (PopType.POPSELECT.equals((Object)this.popType)) {
                    Object[] realOptions = new Object[]{};
                    ArrayList<String> optionList = new ArrayList<String>();
                    if (this.options != null) {
                        if (this.options instanceof Object[]) {
                            realOptions = (Object[])this.options;
                        } else if (this.options instanceof String) {
                            String optionString = (String)this.options;
                            while (!optionString.isEmpty()) {
                                int slen;
                                try {
                                    slen = Integer.parseInt(optionString.substring(0, 4));
                                }
                                catch (NumberFormatException e) {
                                    slen = 0;
                                }
                                if (slen == 0 || slen < 1000) {
                                    realOptions = new Object[]{};
                                    break;
                                }
                                optionList.add(optionString.substring(4, 4 + (slen -= 1000)));
                                optionString = optionString.substring(slen + 4);
                            }
                            if (optionList.size() > 0) {
                                realOptions = optionList.toArray();
                            }
                        }
                    }
                    this.returnValue = realOptions.length == 0 ? "" : JOptionPane.showInputDialog(this.frame, this.message, this.title, -1, null, realOptions, this.preset);
                } else if (PopType.POPFILE.equals((Object)this.popType)) {
                    File fileChoosen = new SikulixFileChooser(this.frame).open(this.title);
                    this.returnValue = fileChoosen == null ? "" : fileChoosen.getAbsolutePath();
                } else if (PopType.POPGENERIC.equals((Object)this.popType)) {
                    this.returnValue = 0;
                    if (this.options instanceof String[]) {
                        Object[] realOptions = (String[])this.options;
                        int response = JOptionPane.showOptionDialog(this.frame, this.message, this.title, -1, 3, null, realOptions, this.preset);
                        this.returnValue = response;
                    }
                }
                RunInput runInput = this;
                synchronized (runInput) {
                    this.dispose();
                    this.notify();
                }
            }

            public int getTimeout() {
                if (Integer.MAX_VALUE == this.timeout) {
                    return this.timeout;
                }
                return this.timeout * 1000;
            }

            public void dispose() {
                this.frame.dispose();
            }

            public Object getReturnValue() {
                return this.returnValue;
            }
        }
        RunInput popRun = new RunInput(popType, args);
        ScheduledExecutorService timeoutScheduler = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> timeoutJob = timeoutScheduler.schedule(() -> popRun.dispose(), (long)popRun.getTimeout(), TimeUnit.MILLISECONDS);
        if (EventQueue.isDispatchThread()) {
            popRun.run();
        } else {
            RunInput runInput = popRun;
            synchronized (runInput) {
                EventQueue.invokeLater(popRun);
                try {
                    popRun.wait();
                }
                catch (InterruptedException e) {
                    Debug.error("Interrupted while waiting for popup close: %s", e.getMessage());
                }
            }
        }
        Object returnValue = popRun.getReturnValue();
        if (timeoutJob.isDone()) {
            returnValue = null;
        } else {
            timeoutJob.cancel(false);
        }
        timeoutScheduler.shutdown();
        return returnValue;
    }

    private static Map<String, Object> getPopParameters(Object ... args) {
        String parameterNames = "message,title,preset,hidden,timeout,location,options";
        String parameterClass = "s,s,s,b,i,e,o";
        Object[] parameterDefault = new Object[]{"not set", "SikuliX", "", false, Integer.MAX_VALUE, null, new Object[0]};
        return Parameters.get(parameterNames, parameterClass, parameterDefault, args);
    }

    private static JFrame getFrame(Object point) {
        Location currentPopLocation = Sikulix.getCurrentPopLocation();
        int x = currentPopLocation.x;
        int y = currentPopLocation.y;
        if (null != point) {
            if (point instanceof Point) {
                x = ((Point)point).x;
                y = ((Point)point).y;
            } else if (point instanceof Region) {
                x = ((Region)point).getCenter().x;
                y = ((Region)point).getCenter().y;
            } else if (point instanceof Location) {
                x = ((Location)point).x;
                y = ((Location)point).y;
            }
        }
        JFrame anchor = new JFrame();
        anchor.setAlwaysOnTop(true);
        anchor.setUndecorated(true);
        anchor.setSize(1, 1);
        anchor.setLocation(x, y);
        anchor.setVisible(true);
        return anchor;
    }

    public static Region on() {
        return Screen.getPrimaryScreen();
    }

    public static boolean isNotNull(Object obj) {
        return null != obj;
    }

    public static boolean isNull(Object obj) {
        return null == obj;
    }

    public void reset() {
        Debug.log(3, "SX.reset()", new Object[0]);
        Screen.resetMonitorsQuiet();
        Mouse.reset();
    }

    private static class Parameters {
        private Map<String, String> parameterTypes = new HashMap<String, String>();
        private String[] parameterNames = null;
        private Object[] parameterDefaults = new Object[0];

        public Parameters(String theNames, String theClasses, Object[] theDefaults) {
            String[] names = theNames.split(",");
            String[] classes = theClasses.split(",");
            if (names.length == classes.length) {
                for (int n = 0; n < names.length; ++n) {
                    String clazz = classes[n];
                    if (clazz.length() == 1) {
                        if ("s".equals(clazz = clazz.toLowerCase())) {
                            clazz = "String";
                        } else if ("i".equals(clazz)) {
                            clazz = "Integer";
                        } else if ("d".equals(clazz)) {
                            clazz = "Double";
                        } else if ("b".equals(clazz)) {
                            clazz = "Boolean";
                        } else if ("e".equals(clazz)) {
                            clazz = "Region";
                        } else if ("o".equals(clazz)) {
                            clazz = "Object";
                        }
                    }
                    if (!"String".equals(clazz) && !"Integer".equals(clazz) && !"Double".equals(clazz) && !"Boolean".equals(clazz) && !"Region".equals(clazz) && !"Object".equals(clazz)) continue;
                    this.parameterTypes.put(names[n], clazz);
                }
                this.parameterNames = names;
                this.parameterDefaults = theDefaults;
            } else {
                log;
                Log.error("Parameters: different length: names: %s classes: %s", theNames, theClasses);
            }
        }

        public static Map<String, Object> get(Object ... args) {
            String theNames = (String)args[0];
            String theClasses = (String)args[1];
            Object[] theDefaults = (Object[])args[2];
            Object[] theArgs = (Object[])args[3];
            Parameters theParameters = new Parameters(theNames, theClasses, theDefaults);
            return theParameters.getParameters(theArgs);
        }

        private Object getParameter(Object possibleValue, String parameterName) {
            String clazz = this.parameterTypes.get(parameterName);
            Object value = null;
            if ("String".equals(clazz)) {
                if (possibleValue instanceof String) {
                    value = possibleValue;
                }
            } else if ("Integer".equals(clazz)) {
                if (possibleValue instanceof Integer) {
                    value = possibleValue;
                }
            } else if ("Double".equals(clazz)) {
                if (possibleValue instanceof Double) {
                    value = possibleValue;
                }
            } else if ("Boolean".equals(clazz)) {
                if (possibleValue instanceof Boolean) {
                    value = possibleValue;
                }
            } else if ("Region".equals(clazz)) {
                if (possibleValue instanceof Region) {
                    value = possibleValue;
                }
            } else if ("Object".equals(clazz)) {
                value = possibleValue;
            }
            return value;
        }

        private int findNextParameter(Object possibleValue, int parmIndex) {
            ++parmIndex;
            Object value = null;
            while (parmIndex < this.parameterNames.length) {
                if (null == possibleValue) {
                    return parmIndex;
                }
                value = this.getParameter(possibleValue, this.parameterNames[parmIndex]);
                if (value == null) {
                    ++parmIndex;
                    continue;
                }
                return parmIndex;
            }
            return -1;
        }

        public Map<String, Object> getParameters(Object[] args) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (SX.isNotNull(this.parameterNames)) {
                Object arg;
                int n = 0;
                for (String parameterName : this.parameterNames) {
                    params.put(parameterName, this.parameterDefaults[n]);
                    ++n;
                }
                int argParm = -1;
                Object[] objectArray = args;
                int n2 = objectArray.length;
                for (int i = 0; i < n2 && (argParm = this.findNextParameter(arg = objectArray[i], argParm)) >= 0; ++i) {
                    params.put(this.parameterNames[argParm], arg);
                }
            }
            return params;
        }
    }

    private static enum PopType {
        POPUP,
        POPASK,
        POPERROR,
        POPINPUT,
        POPSELECT,
        POPFILE,
        POPGENERIC;

    }

    public static class Log {
        public static void error(String msg, Object ... args) {
            Debug.error("SX: " + msg, args);
        }
    }
}

