/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Date;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.Location;
import org.sikuli.script.Mouse;
import org.sikuli.script.Region;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.SikuliXception;
import org.sikuli.script.support.Commons;
import org.sikuli.script.support.IRobot;
import org.sikuli.script.support.IScreen;
import org.sikuli.script.support.RobotDesktop;
import org.sikuli.script.support.RunTime;
import org.sikuli.script.support.ScreenUnion;
import org.sikuli.util.EventObserver;
import org.sikuli.util.OverlayCapturePrompt;

public class Screen
extends Region
implements IScreen {
    protected static final String logName = "Screen: ";
    private static IRobot globalRobot = null;
    protected static Screen[] screens = null;
    protected static int primaryScreen = -1;
    private static int waitForScreenshot = 300;
    protected int curID = -1;
    protected int oldID = 0;
    protected int monitor = -1;
    protected boolean waitPrompt;
    protected OverlayCapturePrompt prompt;
    private static final String promptMsg = "Select a region on the screen";
    public static boolean ignorePrimaryAtCapture = false;
    public ScreenImage lastScreenImage = null;
    private static boolean isActiveCapturePrompt = false;
    private static EventObserver captureObserver = null;
    private long lastCaptureTime = -1L;
    static int nMonitors = 0;
    static Rectangle[] monitorBounds = null;
    static int mainMonitor = -1;
    static GraphicsEnvironment genv = null;
    static GraphicsDevice[] gdevs;
    private static Boolean initScreensFirstTime;

    public static Screen getDefaultInstance4py() {
        return new Screen();
    }

    public static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private static boolean initMonitors() {
        if (!Screen.isHeadless()) {
            Screen.log(3, "Accessing: GraphicsEnvironment.getLocalGraphicsEnvironment()", new Object[0]);
            genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Screen.log(3, "Accessing: GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()", new Object[0]);
            gdevs = genv.getScreenDevices();
            nMonitors = gdevs.length;
            mainMonitor = -1;
            if (nMonitors == 0) {
                throw new SikuliXception(String.format("SikuliX: Init: GraphicsEnvironment has no ScreenDevices", new Object[0]));
            }
            monitorBounds = new Rectangle[nMonitors];
            for (int i = 0; i < nMonitors; ++i) {
                Rectangle currentBounds = gdevs[i].getDefaultConfiguration().getBounds();
                if (currentBounds.contains(new Point(0, 0))) {
                    if (mainMonitor < 0) {
                        mainMonitor = i;
                        Screen.log(3, "ScreenDevice %d has (0,0) --- will be primary Screen(0)", i);
                    } else {
                        Screen.log(3, "ScreenDevice %d too contains (0,0)!", i);
                    }
                }
                Screen.log(3, "Monitor %d: (%d, %d) %d x %d", i, currentBounds.x, currentBounds.y, currentBounds.width, currentBounds.height);
                Screen.monitorBounds[i] = currentBounds;
            }
            if (mainMonitor < 0) {
                Screen.log(3, "No ScreenDevice has (0,0) --- using 0 as primary: %s", monitorBounds[0]);
                mainMonitor = 0;
            }
            return true;
        }
        throw new SikuliXception(String.format("SikuliX: Init: running in headless environment", new Object[0]));
    }

    public static Rectangle getMonitor(int n) {
        if (primaryScreen < 0) {
            Screen.initScreens(false);
        }
        n = n < 0 || n >= nMonitors ? mainMonitor : n;
        return monitorBounds[n];
    }

    public static Rectangle hasPoint(Point aPoint) {
        if (primaryScreen < 0) {
            Screen.initScreens(false);
        }
        for (Rectangle rMon : monitorBounds) {
            if (!rMon.contains(aPoint)) continue;
            return rMon;
        }
        return null;
    }

    protected static void initScreens(boolean reset) {
        if (screens != null && !reset) {
            return;
        }
        if (null == initScreensFirstTime) {
            initScreensFirstTime = true;
        } else if (initScreensFirstTime.booleanValue()) {
            initScreensFirstTime = false;
            return;
        }
        Screen.log(3, "initScreens: starting", new Object[0]);
        if (Screen.initMonitors()) {
            primaryScreen = 0;
            Screen.getGlobalRobot();
            screens = new Screen[nMonitors];
            Screen.screens[0] = new Screen(0, mainMonitor);
            screens[0].initScreen();
            int nMonitor = 0;
            for (int i = 1; i < screens.length; ++i) {
                if (nMonitor == mainMonitor) {
                    ++nMonitor;
                }
                Screen.screens[i] = new Screen(i, nMonitor);
                screens[i].initScreen();
                ++nMonitor;
            }
            Mouse.init();
            Screen.log(3, "initScreens: monitor mouse check", new Object[0]);
            Location lnow = Mouse.at();
            float mmd = Settings.MoveMouseDelay;
            Settings.MoveMouseDelay = 0.0f;
            Location lc = null;
            Location lcn = null;
            for (Screen s : screens) {
                lc = s.getCenter();
                Mouse.move(lc);
                if (Mouse.isNotUseable()) break;
                lcn = Mouse.at();
                if (!lc.equals(lcn)) {
                    Screen.log(3, "*** multimonitor click check: %s center: (%d, %d) --- NOT OK:  (%d, %d)", s.toStringShort(), lc.x, lc.y, lcn.x, lcn.y);
                    continue;
                }
                Screen.log(3, "*** checking: %s center: (%d, %d) --- OK", s.toStringShort(), lc.x, lc.y);
            }
            if (!Mouse.isNotUseable()) {
                Mouse.move(lnow);
            }
            Settings.MoveMouseDelay = mmd;
        }
        if (Mouse.isNotUseable()) {
            RunTime runTime = RunTime.get();
            if (runTime.runType.equals((Object)RunTime.Type.API) && Commons.runningMac()) {
                throw new SikuliXception("Mouse.init: Mouse not useable (blocked) - Screenshots might not work either!");
            }
        }
        Screen.log(3, "initScreens: ending", new Object[0]);
    }

    public Screen() {
        if (primaryScreen < 0) {
            Screen.initScreens(false);
        }
        this.curID = primaryScreen;
        this.initScreen();
    }

    public Screen(int id) {
        if (primaryScreen < 0) {
            Screen.initScreens(false);
        }
        if (id < 0 || id >= nMonitors) {
            Debug.error("Screen(%d) not in valid range 0 to %d - using primary %d", id, nMonitors - 1, primaryScreen);
            this.curID = primaryScreen;
        } else {
            this.curID = id;
        }
        this.monitor = Screen.screens[this.curID].monitor;
        this.initScreen();
    }

    public static Screen make4py(ArrayList args) {
        Screen theScreen = new Screen();
        if (args.size() == 1 && args.get(0) instanceof Integer) {
            theScreen = new Screen((Integer)args.get(0));
        }
        return theScreen;
    }

    private void initScreen() {
        Rectangle bounds = this.getBounds();
        this.x = (int)bounds.getX();
        this.y = (int)bounds.getY();
        this.w = (int)bounds.getWidth();
        this.h = (int)bounds.getHeight();
    }

    private Screen(int id, int monitor) {
        this.curID = id;
        this.monitor = monitor;
    }

    public static Screen as(int id) {
        if (primaryScreen < 0) {
            Screen.initScreens(false);
        }
        if (id < 0 || id >= nMonitors) {
            Debug.error("Screen(%d) not in valid range 0 to %d - using primary %d", id, nMonitors - 1, primaryScreen);
            return screens[0];
        }
        return screens[id];
    }

    protected static IRobot getGlobalRobot() {
        if (globalRobot == null) {
            try {
                globalRobot = new RobotDesktop();
            }
            catch (AWTException e) {
                throw new RuntimeException(String.format("SikuliX: Screen: getGlobalRobot: %s", e.getMessage()));
            }
        }
        return globalRobot;
    }

    public static ScreenUnion all() {
        return new ScreenUnion();
    }

    public Screen(boolean isScreenUnion) {
        super(isScreenUnion);
    }

    public void setAsScreenUnion() {
        this.oldID = this.curID;
        this.curID = -1;
    }

    public void setAsScreen() {
        this.curID = this.oldID;
    }

    @Override
    public Screen getScreen() {
        return this;
    }

    @Override
    protected Region setScreen(IScreen s) {
        return new Region(this.getBounds());
    }

    public static void showMonitors() {
        if (primaryScreen < 0) {
            Screen.initScreens(false);
        }
        Debug.logp("*** monitor configuration [ %s Screen(s)] ***", Screen.getNumberScreens());
        Debug.logp("*** Primary is Screen %d", primaryScreen);
        for (int i = 0; i < nMonitors; ++i) {
            Debug.logp("Screen %d: %s", i, Screen.getScreen(i).toStringShort());
        }
        Debug.logp("*** end monitor configuration ***", new Object[0]);
    }

    public static void resetMonitors() {
        Debug.error("*** BE AWARE: experimental - might not work ***", new Object[0]);
        Debug.error("Re-evaluation of the monitor setup has been requested", new Object[0]);
        Debug.error("... Current Region/Screen objects might not be valid any longer", new Object[0]);
        Debug.error("... Use existing Region/Screen objects only if you know what you are doing!", new Object[0]);
        Screen.initScreens(true);
        Debug.logp("*** new monitor configuration [ %s Screen(s)] ***", Screen.getNumberScreens());
        Debug.logp("*** Primary is Screen %d", primaryScreen);
        for (int i = 0; i < nMonitors; ++i) {
            Debug.logp("Screen %d: %s", i, Screen.getScreen(i).toStringShort());
        }
        Debug.error("*** end new monitor configuration ***", new Object[0]);
    }

    public static void resetMonitorsQuiet() {
        Screen.initScreens(true);
    }

    private static int getValidMonitor(int id) {
        if (id < 0 || id >= nMonitors) {
            Debug.error("Screen: invalid screen id %d - using primary screen", id);
            return mainMonitor;
        }
        return Screen.screens[id].monitor;
    }

    public static int getNumberScreens() {
        if (primaryScreen < 0) {
            Screen.initScreens(false);
        }
        return nMonitors;
    }

    public static int getPrimaryId() {
        if (primaryScreen < 0) {
            Screen.initScreens(false);
        }
        return primaryScreen;
    }

    public static Screen getPrimaryScreen() {
        if (primaryScreen < 0) {
            Screen.initScreens(false);
        }
        return screens[primaryScreen];
    }

    public static Screen getScreen(int id) {
        if (primaryScreen < 0) {
            Screen.initScreens(false);
        }
        if (id < 0 || id >= nMonitors) {
            Debug.error("Screen: invalid screen id %d - using primary screen", id);
            id = primaryScreen;
        }
        return screens[id];
    }

    @Override
    public Rectangle getBounds() {
        if (Screen.isHeadless()) {
            return new Rectangle();
        }
        return new Rectangle(Screen.getMonitor(Screen.getValidMonitor(this.curID)));
    }

    public static Rectangle getBounds(int id) {
        if (Screen.isHeadless()) {
            return new Rectangle();
        }
        return new Rectangle(Screen.getMonitor(Screen.getValidMonitor(id)));
    }

    public static IRobot getRobot(int id) {
        return Screen.getScreen(id).getRobot();
    }

    @Override
    public int getID() {
        return this.curID;
    }

    @Override
    public String getIDString() {
        return "" + this.getID();
    }

    @Override
    public int getIdFromPoint(int x, int y) {
        return this.curID;
    }

    @Override
    public IRobot getRobot() {
        return Screen.getGlobalRobot();
    }

    protected static IRobot getRobot(Region reg) {
        if (reg == null || null == reg.getScreen()) {
            Screen.getPrimaryScreen();
            return Screen.getGlobalRobot();
        }
        return reg.getScreen().getRobot();
    }

    @Override
    public Region newRegion(Location loc, int width, int height) {
        return Region.create(loc.copyTo(this), width, height);
    }

    @Override
    public Region newRegion(Region reg) {
        return this.copyTo(this);
    }

    @Override
    public Region newRegion(int x, int y, int w, int h) {
        return this.newRegion(new Location(x, y), w, h);
    }

    @Override
    public Location newLocation(Location loc) {
        return new Location(loc).copyTo(this);
    }

    @Override
    public ScreenImage getLastScreenImageFromScreen() {
        return this.lastScreenImage;
    }

    public ScreenImage cmdCapture(Object ... args) {
        ScreenImage shot = null;
        if (args.length == 0) {
            shot = this.userCapture("capture an image");
        } else {
            Object arg0 = args[0];
            if (args.length == 1) {
                shot = arg0 instanceof String ? (((String)arg0).isEmpty() ? this.capture() : this.userCapture((String)arg0)) : (arg0 instanceof Region ? this.capture((Region)arg0) : (arg0 instanceof Rectangle ? this.capture((Rectangle)arg0) : this.capture()));
            } else if (args.length > 1 && args.length < 4) {
                Object arg1 = args[1];
                String path = "";
                String name = "";
                if ((arg0 instanceof Region || arg0 instanceof String || arg0 instanceof Rectangle) && arg1 instanceof String) {
                    if (args.length == 3) {
                        Object arg2 = args[2];
                        if (arg2 instanceof String) {
                            name = (String)arg2;
                            path = (String)arg1;
                        }
                    } else {
                        name = (String)arg1;
                    }
                    if (!name.isEmpty()) {
                        shot = arg0 instanceof Region ? this.capture((Region)arg0) : (arg0 instanceof Rectangle ? this.capture((Rectangle)arg0) : this.userCapture((String)arg0));
                        if (shot != null) {
                            if (!path.isEmpty()) {
                                shot.getFile(path, name);
                            } else {
                                shot.saveInBundle(name);
                            }
                        }
                        return shot;
                    }
                }
                Debug.error("Screen: capture: Invalid parameters", new Object[0]);
            } else if (args.length == 4) {
                Integer argInt = null;
                for (Object arg : args) {
                    argInt = null;
                    try {
                        argInt = (Integer)arg;
                    }
                    catch (Exception ex) {
                        break;
                    }
                }
                if (argInt != null) {
                    shot = this.capture((Integer)args[0], (Integer)args[1], (Integer)args[2], (Integer)args[3]);
                }
            } else {
                Debug.error("Screen: capture: Invalid parameters", new Object[0]);
            }
        }
        if (shot != null) {
            shot.getFile();
        }
        return shot;
    }

    @Override
    public ScreenImage capture() {
        return this.capture(this.getRect());
    }

    @Override
    public ScreenImage capture(int x, int y, int w, int h) {
        Rectangle rect = this.newRegion(new Location(x, y), w, h).getRect();
        return this.capture(rect);
    }

    @Override
    public ScreenImage capture(Rectangle rect) {
        this.lastCaptureTime = new Date().getTime();
        ScreenImage simg = globalRobot.captureScreen(rect);
        if (Settings.FindProfiling) {
            Debug.logp("[FindProfiling] Screen.capture [%d x %d]: %d msec", rect.width, rect.height, new Date().getTime() - this.lastCaptureTime);
        }
        this.lastScreenImage = simg;
        if (Debug.getDebugLevel() > 3) {
            simg.saveLastScreenImage(RunTime.get().fSikulixStore);
        }
        return simg;
    }

    @Override
    public ScreenImage capture(Region reg) {
        return this.capture(reg.getRect());
    }

    public static void doPrompt(String message, EventObserver obs) {
        captureObserver = obs;
        Screen.getPrimaryScreen().userCapture(message);
    }

    public static void closePrompt() {
        for (int is = 0; is < Screen.getNumberScreens(); ++is) {
            if (!Screen.getScreen(is).hasPrompt()) continue;
            Screen.getScreen((int)is).prompt.close();
        }
    }

    public static void closePrompt(Screen scr) {
        for (int is = 0; is < Screen.getNumberScreens(); ++is) {
            if (Screen.getScreen(is).getID() == scr.getID() || !Screen.getScreen(is).hasPrompt()) continue;
            Screen.getScreen((int)is).prompt.close();
            Screen.getScreen((int)is).prompt = null;
        }
    }

    private static synchronized boolean setActiveCapturePrompt() {
        if (isActiveCapturePrompt) {
            return false;
        }
        Debug.log(3, "TRACE: Screen: setActiveCapturePrompt", new Object[0]);
        isActiveCapturePrompt = true;
        return true;
    }

    private static synchronized void resetActiveCapturePrompt() {
        Debug.log(3, "TRACE: Screen: resetActiveCapturePrompt", new Object[0]);
        isActiveCapturePrompt = false;
        captureObserver = null;
    }

    public static void resetPrompt(OverlayCapturePrompt ocp) {
        int scrID = ocp.getScrID();
        if (scrID > -1) {
            Screen.getScreen((int)scrID).prompt = null;
        }
        Screen.resetActiveCapturePrompt();
    }

    public boolean hasPrompt() {
        return this.prompt != null;
    }

    public ScreenImage userCapture() {
        return this.userCapture("");
    }

    @Override
    public ScreenImage userCapture(final String message) {
        if (!Screen.setActiveCapturePrompt()) {
            return null;
        }
        Debug.log(3, "TRACE: Screen: userCapture", new Object[0]);
        this.waitPrompt = true;
        Thread th = new Thread(){

            @Override
            public void run() {
                String msg = message.isEmpty() ? Screen.promptMsg : message;
                for (int is = 0; is < Screen.getNumberScreens(); ++is) {
                    if (ignorePrimaryAtCapture && is == 0) continue;
                    Screen.getScreen((int)is).prompt = new OverlayCapturePrompt(Screen.getScreen(is));
                    Screen.getScreen((int)is).prompt.addObserver(captureObserver);
                    Screen.getScreen((int)is).prompt.prompt(msg);
                }
            }
        };
        th.start();
        if (captureObserver != null) {
            return null;
        }
        boolean isComplete = false;
        ScreenImage simg = null;
        int count = 0;
        while (!isComplete) {
            this.wait(0.1f);
            if (count++ > waitForScreenshot) break;
            for (int is = 0; is < Screen.getNumberScreens(); ++is) {
                OverlayCapturePrompt ocp = Screen.getScreen((int)is).prompt;
                if (ocp == null || !ocp.isComplete()) continue;
                Screen.closePrompt(Screen.getScreen(is));
                simg = ocp.getSelection();
                if (simg != null) {
                    Screen.getScreen((int)is).lastScreenImage = simg;
                }
                ocp.close();
                Screen.getScreen((int)is).prompt = null;
                isComplete = true;
            }
        }
        Screen.resetActiveCapturePrompt();
        return simg;
    }

    public Region selectRegion() {
        return this.selectRegion(promptMsg);
    }

    public Region selectRegion(String message) {
        Debug.log(3, "TRACE: Screen: selectRegion", new Object[0]);
        ScreenImage sim = this.userCapture(message);
        if (sim == null) {
            return null;
        }
        Rectangle r = sim.getROI();
        return Region.create((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    @Override
    public Region setOther(Region element) {
        return element.setOtherScreen(this);
    }

    @Override
    public Location setOther(Location element) {
        return element.setOtherScreen(this);
    }

    @Override
    public Location newLocation(int x, int y) {
        return new Location(x, y).setOtherScreen(this);
    }

    static {
        initScreensFirstTime = null;
    }
}

