/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Desktop;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sourceforge.tess4j.ITesseract;
import net.sourceforge.tess4j.Tesseract1;
import net.sourceforge.tess4j.TesseractException;
import net.sourceforge.tess4j.Word;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.Element;
import org.sikuli.script.Finder;
import org.sikuli.script.Image;
import org.sikuli.script.Match;
import org.sikuli.script.OCR;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.SikuliXception;
import org.sikuli.script.support.Commons;
import org.sikuli.script.support.RunTime;

public class TextRecognizer {
    private static boolean isValid = false;
    private static int lvl = 3;
    private static final String versionTess4J = "4.5.4";
    private static final String versionTesseract = "4.1.x";
    private OCR.Options options;

    private TextRecognizer() {
    }

    @Deprecated
    public static TextRecognizer start() {
        return TextRecognizer.get(OCR.globalOptions());
    }

    protected static TextRecognizer get(OCR.Options options) {
        if (!isValid) {
            if (Commons.runningMac()) {
                String libPath = "/usr/local/lib";
                File libTess = new File(libPath, "libtesseract.dylib");
                if (libTess.exists()) {
                    Commons.jnaPathAdd(libPath);
                } else {
                    throw new SikuliXception(String.format("OCR: validate: libtesseract.dylib not in /usr/local/lib", new Object[0]));
                }
            }
            RunTime.loadLibrary(RunTime.libOpenCV);
            isValid = true;
        }
        TextRecognizer.initDefaultDataPath();
        Debug.log(lvl, "OCR: start: Tess4J %s using Tesseract %s", new Object[]{versionTess4J, versionTesseract});
        if (options == null) {
            options = OCR.globalOptions();
        }
        options.validate();
        TextRecognizer textRecognizer = new TextRecognizer();
        textRecognizer.options = options;
        return textRecognizer;
    }

    private ITesseract getTesseractAPI() {
        try {
            Tesseract1 tesseract = new Tesseract1();
            tesseract.setOcrEngineMode(this.options.oem());
            tesseract.setPageSegMode(this.options.psm());
            tesseract.setLanguage(this.options.language());
            tesseract.setDatapath(this.options.dataPath());
            for (Map.Entry<String, String> entry : this.options.variables().entrySet()) {
                tesseract.setTessVariable(entry.getKey(), entry.getValue());
            }
            if (!this.options.configs().isEmpty()) {
                tesseract.setConfigs(new ArrayList<String>(this.options.configs()));
            }
            return tesseract;
        }
        catch (UnsatisfiedLinkError e) {
            String helpURL = RunTime.get().runningWindows ? "https://github.com/RaiMan/SikuliX1/wiki/Windows:-Problems-with-libraries-OpenCV-or-Tesseract" : "https://github.com/RaiMan/SikuliX1/wiki/macOS-Linux:-Support-libraries-for-Tess4J-Tesseract-4-OCR";
            Debug.error("see: " + helpURL, new Object[0]);
            if (RunTime.isIDE()) {
                Debug.error("Save your work, correct the problem and restart the IDE!", new Object[0]);
                try {
                    Desktop.getDesktop().browse(new URI(helpURL));
                }
                catch (IOException iOException) {
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            throw new SikuliXception(String.format("OCR: start: Tesseract library problems: %s", e.getMessage()));
        }
    }

    @Deprecated
    public static void reset() {
        OCR.globalOptions().reset();
    }

    @Deprecated
    public static void status() {
        Debug.logp("Global settings " + OCR.globalOptions().toString(), new Object[0]);
    }

    @Deprecated
    public TextRecognizer setOEM(OCR.OEM oem) {
        return this.setOEM(oem.ordinal());
    }

    @Deprecated
    public TextRecognizer setOEM(int oem) {
        this.options.oem(oem);
        return this;
    }

    @Deprecated
    public TextRecognizer setPSM(OCR.PSM psm) {
        return this.setPSM(psm.ordinal());
    }

    @Deprecated
    public TextRecognizer setPSM(int psm) {
        this.options.psm(psm);
        return this;
    }

    @Deprecated
    public TextRecognizer setDataPath(String dataPath) {
        this.options.dataPath(dataPath);
        return this;
    }

    @Deprecated
    public TextRecognizer setLanguage(String language) {
        this.options.language(language);
        return this;
    }

    @Deprecated
    public TextRecognizer setVariable(String key, String value) {
        this.options.variable(key, value);
        return this;
    }

    @Deprecated
    public TextRecognizer setConfigs(String ... configs) {
        this.setConfigs(Arrays.asList(configs));
        return this;
    }

    @Deprecated
    public TextRecognizer setConfigs(List<String> configs) {
        this.options.configs(configs);
        return this;
    }

    @Deprecated
    public TextRecognizer setFontSize(int size) {
        this.options.fontSize(size);
        return this;
    }

    @Deprecated
    public TextRecognizer setTextHeight(int height) {
        this.options.textHeight(height);
        return this;
    }

    private BufferedImage optimize(BufferedImage bimg) {
        Mat mimg = Finder.Finder2.makeMat(bimg);
        Imgproc.cvtColor((Mat)mimg, (Mat)mimg, (int)6);
        mimg = this.unsharpMask(mimg, 3.0);
        float rFactor = this.options.factor();
        if (rFactor > 0.0f && rFactor != 1.0f) {
            Image.resize(mimg, rFactor, this.options.resizeInterpolation());
        }
        mimg = this.unsharpMask(mimg, 5.0);
        if (this.options.isLightFont()) {
            Core.bitwise_not((Mat)mimg, (Mat)mimg);
        }
        BufferedImage optImg = Finder.Finder2.getBufferedImage(mimg);
        return optImg;
    }

    private Mat unsharpMask(Mat img, double sigma) {
        Mat blurred = new Mat();
        Imgproc.GaussianBlur((Mat)img, (Mat)blurred, (Size)new Size(), (double)sigma, (double)sigma);
        Core.addWeighted((Mat)img, (double)1.5, (Mat)blurred, (double)-0.5, (double)0.0, (Mat)img);
        return img;
    }

    protected <SFIRBS> String readText(SFIRBS from) {
        return this.doRead(from);
    }

    protected <SFIRBS> List<Match> readLines(SFIRBS from) {
        BufferedImage bimg = Element.getBufferedImage(from);
        return this.readTextItems(bimg, 2);
    }

    protected <SFIRBS> List<Match> readWords(SFIRBS from) {
        BufferedImage bimg = Element.getBufferedImage(from);
        return this.readTextItems(bimg, 3);
    }

    private static void initDefaultDataPath() {
        if (OCR.Options.defaultDataPath == null) {
            File fTessDataPath = new File(RunTime.get().fSikulixAppPath, "SikulixTesseract/tessdata");
            boolean shouldExport = RunTime.get().shouldExport();
            boolean fExists = fTessDataPath.exists();
            if ((!fExists || shouldExport) && 0 == RunTime.get().extractResourcesToFolder("/tessdataSX", fTessDataPath, null).size()) {
                throw new SikuliXception(String.format("OCR: start: export tessdata did not work: %s", fTessDataPath));
            }
            String defaultDataPath = Settings.OcrDataPath != null ? new File(Settings.OcrDataPath, "tessdata").getAbsolutePath() : fTessDataPath.getAbsolutePath();
            OCR.Options.defaultDataPath = defaultDataPath;
        }
    }

    protected <SFIRBS> String doRead(SFIRBS from) {
        String text = "";
        BufferedImage bimg = Element.getBufferedImage(from);
        try {
            text = this.getTesseractAPI().doOCR(this.optimize(bimg)).trim().replace("\n\n", "\n");
        }
        catch (TesseractException e) {
            Debug.error("OCR: read: Tess4J: doOCR: %s", e.getMessage());
            return "";
        }
        return text;
    }

    protected <SFIRBS> List<Match> readTextItems(SFIRBS from, int level) {
        ArrayList<Match> lines = new ArrayList<Match>();
        BufferedImage bimg = Element.getBufferedImage(from);
        BufferedImage bimgResized = this.optimize(bimg);
        List textItems = this.getTesseractAPI().getWords(bimgResized, level);
        double wFactor = (double)bimg.getWidth() / (double)bimgResized.getWidth();
        double hFactor = (double)bimg.getHeight() / (double)bimgResized.getHeight();
        for (Word textItem : textItems) {
            Rectangle boundingBox = textItem.getBoundingBox();
            Rectangle realBox = new Rectangle((int)((double)boundingBox.x * wFactor) - 1, (int)((double)boundingBox.y * hFactor) - 1, 1 + (int)((double)boundingBox.width * wFactor) + 2, 1 + (int)((double)boundingBox.height * hFactor) + 2);
            lines.add(new Match(realBox, textItem.getConfidence(), textItem.getText().trim()));
        }
        return lines;
    }

    @Deprecated
    public int getActualDPI() {
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    @Deprecated
    public String doOCR(ScreenImage simg) {
        return OCR.readText(simg);
    }

    @Deprecated
    public String doOCR(BufferedImage bimg) {
        return OCR.readText(bimg);
    }

    @Deprecated
    public String recognize(ScreenImage simg) {
        BufferedImage bimg = simg.getImage();
        return OCR.readText(bimg);
    }

    @Deprecated
    public String recognize(BufferedImage bimg) {
        return OCR.readText(bimg);
    }
}

