/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.runners;

import java.io.File;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.sikuli.script.ImagePath;
import org.sikuli.script.runners.AbstractScriptRunner;
import org.sikuli.script.support.IScriptRunner;

public abstract class AbstractLocalFileScriptRunner
extends AbstractScriptRunner {
    private static final Deque<String> PREVIOUS_BUNDLE_PATHS = new ConcurrentLinkedDeque<String>();

    @Override
    protected void adjustBundlePath(String script, IScriptRunner.Options options) {
        File file = new File(script);
        if (file.exists()) {
            String currentBundlePath = ImagePath.getBundlePath();
            if (currentBundlePath != null) {
                PREVIOUS_BUNDLE_PATHS.push(currentBundlePath);
            }
            ImagePath.setBundleFolder(file.getParentFile());
        }
    }

    @Override
    protected void resetBundlePath(String script, IScriptRunner.Options options) {
        if (new File(script).exists() && !PREVIOUS_BUNDLE_PATHS.isEmpty()) {
            ImagePath.setBundlePath(PREVIOUS_BUNDLE_PATHS.pop());
        }
    }

    @Override
    public boolean canHandle(String identifier) {
        if (identifier != null) {
            int protoSepIndex = identifier.indexOf("://");
            if (protoSepIndex > 0 && protoSepIndex <= 5) {
                return false;
            }
            return super.canHandle(identifier);
        }
        return false;
    }
}

