/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.runners;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.sikuli.basics.Debug;
import org.sikuli.script.runnerSupport.JRubySupport;
import org.sikuli.script.runners.AbstractLocalFileScriptRunner;
import org.sikuli.script.support.IScriptRunner;

public class JRubyRunner
extends AbstractLocalFileScriptRunner {
    public static final String NAME = "JRuby";
    public static final String TYPE = "text/ruby";
    public static final String[] EXTENSIONS = new String[]{"rb"};
    static JRubySupport jrubySupport = null;
    private int lvl = 3;
    private static boolean redirected = false;

    @Override
    public boolean isAbortSupported() {
        return true;
    }

    @Override
    public boolean isSupported() {
        return jrubySupport.isSupported();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getExtensions() {
        return (String[])EXTENSIONS.clone();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void doClose() {
        jrubySupport.interpreterTerminate();
        redirected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInit(String[] args) {
        Class<JRubyRunner> clazz = JRubyRunner.class;
        synchronized (JRubyRunner.class) {
            if (null == jrubySupport) {
                jrubySupport = JRubySupport.get();
                jrubySupport.executeScriptHeader(codeBefore, new String[0]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private String injectAbortWatcher(String script) {
        return "Thread.new(){\n  runner = org.sikuli.script.support.Runner.getRunner(\"JRuby\")\n  while runner.isRunning()\n    sleep(0.1)\n    if runner.isAborted()\n      exit!\n    end\n  end\n}\n" + script;
    }

    private int injectAbortWatcherLineCount() {
        return this.injectAbortWatcher("").split("\n").length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doRunScript(String scriptFile, String[] scriptArgs, IScriptRunner.Options options) {
        Integer exitCode = 0;
        Object exitValue = null;
        Class<JRubyRunner> clazz = JRubyRunner.class;
        synchronized (JRubyRunner.class) {
            block8: {
                String script;
                File rubyFile = new File(new File(scriptFile).getAbsolutePath());
                jrubySupport.fillSysArgv(rubyFile, scriptArgs);
                jrubySupport.executeScriptHeader(codeBefore, rubyFile.getParentFile().getAbsolutePath(), rubyFile.getParentFile().getParentFile().getAbsolutePath());
                try {
                    script = FileUtils.readFileToString((File)rubyFile, (String)"UTF-8");
                }
                catch (IOException ex) {
                    this.log(-1, "reading script: %s", ex.getMessage());
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return 256;
                }
                script = this.injectAbortWatcher(script);
                try {
                    exitValue = jrubySupport.interpreterRunScriptletString(script);
                }
                catch (Throwable scriptException) {
                    if (this.isAborted()) break block8;
                    Pattern p = Pattern.compile("SystemExit: ([0-9]+)");
                    Matcher matcher = p.matcher(scriptException.toString());
                    if (matcher.find()) {
                        exitCode = Integer.parseInt(matcher.group(1));
                        Debug.info("Exit code: " + exitCode, new Object[0]);
                    }
                    int errorExit = jrubySupport.findErrorSource(scriptException, rubyFile.getAbsolutePath(), this.injectAbortWatcherLineCount());
                    options.setErrorLine(errorExit);
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return exitCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRunLines(String lines, IScriptRunner.Options options) {
        Class<JRubyRunner> clazz = JRubyRunner.class;
        synchronized (JRubyRunner.class) {
            try {
                lines = this.injectAbortWatcher(lines);
                jrubySupport.interpreterRunScriptletString(lines);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doEvalScript(String script, IScriptRunner.Options options) {
        Class<JRubyRunner> clazz = JRubyRunner.class;
        synchronized (JRubyRunner.class) {
            script = this.injectAbortWatcher(script);
            jrubySupport.executeScriptHeader(codeBefore, new String[0]);
            jrubySupport.interpreterRunScriptletString(script);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doRedirect(PrintStream stdout, PrintStream stderr) {
        Class<JRubyRunner> clazz = JRubyRunner.class;
        synchronized (JRubyRunner.class) {
            if (!redirected) {
                redirected = true;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return jrubySupport.interpreterRedirect(stdout, stderr);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    @Override
    protected void doAbort() {
    }
}

