/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.runners;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.script.runners.AbstractLocalFileScriptRunner;
import org.sikuli.script.runners.ProcessRunner;
import org.sikuli.script.support.ExtensionManager;
import org.sikuli.script.support.IScriptRunner;

public class PythonRunner
extends AbstractLocalFileScriptRunner {
    public static final String NAME = "Python";
    public static final String TYPE = "text/python";
    public static final String[] EXTENSIONS = new String[]{"py"};

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isSupported() {
        return false;
    }

    @Override
    protected boolean doRedirect(PrintStream stdout, PrintStream stderr) {
        return false;
    }

    @Override
    protected int doRunScript(String scriptfile, String[] scriptArgs, IScriptRunner.Options options) {
        if (!this.isSupported()) {
            return -1;
        }
        if (Debug.isGlobalTrace()) {
            Debug.setDebugLevel(3);
        }
        String scriptContent = FileManager.readFileToString(new File(scriptfile));
        Debug.log(3, "Python: running script: %s\n%s\n********** end", new Object[]{scriptfile, scriptContent});
        ArrayList<String> runArgs = new ArrayList<String>();
        runArgs.add(ExtensionManager.getPython());
        runArgs.add(scriptfile);
        runArgs.addAll(Arrays.asList(scriptArgs));
        String runOut = ProcessRunner.run(runArgs);
        boolean runExitValue = false;
        if (!runOut.startsWith("0\n")) {
            Debug.error("%s", runOut);
        } else {
            Debug.logp("%s", runOut.substring(2));
        }
        return 0;
    }
}

