/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.runners;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import org.sikuli.basics.Debug;
import org.sikuli.script.ImagePath;
import org.sikuli.script.runners.AbstractScriptRunner;
import org.sikuli.script.support.Commons;
import org.sikuli.script.support.RunTime;
import org.sikuli.script.support.Runner;

public class ServerRunner
extends AbstractScriptRunner {
    public static final String NAME = "Server";
    public static final String TYPE = "text/server";
    public static final String[] EXTENSIONS = new String[0];
    private static ServerSocket server = null;
    private static PrintWriter out = null;
    private static Scanner in = null;
    private static boolean isHandling = false;
    private static boolean shouldStop = false;
    private static int logLevel = 0;
    static File isRunning = null;
    static FileOutputStream isRunningFile = null;
    static ScriptEngine jsRunner = null;
    static File scriptFolder = null;
    static String scriptFolderNet = null;
    static File imageFolder = null;
    static String imageFolderNet = null;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private static void dolog(int lvl, String message, Object ... args) {
        if (Debug.isBeQuiet()) {
            return;
        }
        if (lvl < 0 || lvl >= logLevel) {
            System.out.println((lvl < 0 ? "[error] " : "[info] ") + String.format("RunServer: " + message, args));
        }
    }

    private static void dolog(String message, Object ... args) {
        ServerRunner.dolog(0, message, args);
    }

    public static boolean run() {
        String userArgs = "";
        for (String userArg : RunTime.getUserArgs()) {
            userArgs = userArgs + userArg + " ";
        }
        if (!userArgs.isEmpty()) {
            userArgs = "\nWith User parameters: " + userArgs;
        }
        int port = ServerRunner.getPort(null);
        try {
            try {
                if (port > 0) {
                    ServerRunner.dolog(3, "Starting: trying port: %d %s", port, userArgs);
                    server = new ServerSocket(port);
                }
            }
            catch (Exception ex) {
                ServerRunner.dolog(-1, "Starting: " + ex.getMessage(), new Object[0]);
            }
            if (server == null) {
                ServerRunner.dolog(-1, "could not be started", new Object[0]);
                return false;
            }
            String theIP = InetAddress.getLocalHost().getHostAddress();
            String theServer = String.format("%s %d", theIP, port);
            isRunning = new File(RunTime.get().fSikulixStore, "RunServer.txt");
            try {
                isRunning.createNewFile();
                isRunningFile = new FileOutputStream(isRunning);
                if (null == isRunningFile.getChannel().tryLock()) {
                    ServerRunner.dolog(-1, "Terminating on FatalError: already running", new Object[0]);
                    return false;
                }
                isRunningFile.write(theServer.getBytes());
            }
            catch (Exception ex) {
                ServerRunner.dolog(-1, "Terminating on FatalError: cannot access to lock for/n" + isRunning, new Object[0]);
                return false;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ServerRunner.dolog(3, "final cleanup", new Object[0]);
                    if (isRunning != null) {
                        try {
                            isRunningFile.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        isRunning.delete();
                    }
                }
            });
            do {
                ServerRunner.dolog("now waiting on port: %d at %s", port, theIP);
                Socket socket = server.accept();
                out = new PrintWriter(socket.getOutputStream());
                in = new Scanner(socket.getInputStream());
                HandleClient client = new HandleClient(socket);
                isHandling = true;
                while (true) {
                    if (socket.isClosed()) break;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                shouldStop = client.getShouldStop();
            } while (!shouldStop);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!isHandling) {
            ServerRunner.dolog(-1, "start handling not possible: " + port, new Object[0]);
            return false;
        }
        ServerRunner.dolog("now stopped on port: " + port, new Object[0]);
        return true;
    }

    private static int getPort(String p) {
        int port;
        int pDefault = 50001;
        if (p != null) {
            try {
                port = Integer.parseInt(p);
            }
            catch (NumberFormatException ex) {
                ServerRunner.dolog(-1, "given port not useable: %s --- using default", p);
                return pDefault;
            }
        } else {
            return pDefault;
        }
        if (port < 1024) {
            port += pDefault;
        }
        return port;
    }

    private static class HandleClient
    implements Runnable {
        private volatile boolean keepRunning;
        private boolean shouldKeep = false;
        Thread thread;
        Socket socket;
        Boolean shouldStop = false;
        boolean isHTTP = false;
        String request;
        String rCommand;
        String rRessource;
        String rVersion = "HTTP/1.1";
        String rQuery;
        String[] rArgs;
        String rMessage = "";
        String rStatus;
        String rStatusOK = "200 OK";
        String rStatusBadRequest = "400 Bad Request";
        String rStatusNotFound = "404 Not Found";
        String rStatusServerError = "500 Internal Server Error";
        String rStatusServiceNotAvail = "503 Service Unavailable";
        Object evalReturnObject;
        String runTypeJS = "JavaScript";
        String runTypePY = "jython";
        String runTypeRB = "jruby";
        String runType = this.runTypeJS;

        public HandleClient(Socket sock) {
            this.init(sock);
        }

        private void init(Socket sock) {
            this.socket = sock;
            if (in == null || out == null) {
                ServerRunner.dolog(-1, "communication not established", new Object[0]);
                System.exit(1);
            }
            this.thread = new Thread((Runnable)this, "HandleClient");
            this.keepRunning = true;
            this.thread.start();
        }

        public boolean getShouldStop() {
            return this.shouldStop;
        }

        @Override
        public void run() {
            Debug.on(3);
            ServerRunner.dolog("now handling client: " + this.socket, new Object[0]);
            while (this.keepRunning) {
                try {
                    String inLine = in.nextLine();
                    if (inLine == null) continue;
                    if (!this.isHTTP) {
                        ServerRunner.dolog("processing: <%s>", new Object[]{inLine});
                    }
                    boolean success = true;
                    if (inLine.startsWith("GET /") && inLine.contains("HTTP/")) {
                        this.isHTTP = true;
                        this.request = inLine;
                        continue;
                    }
                    if (this.isHTTP && !inLine.isEmpty()) continue;
                    if (!this.isHTTP) {
                        this.request = "GET /" + inLine + " HTTP/1.1";
                    }
                    if (success = this.checkRequest(this.request)) {
                        if (this.rCommand.contains("STOP")) {
                            this.rMessage = "stopping server";
                            this.shouldStop = true;
                            this.shouldKeep = false;
                        } else if (this.rCommand.contains("EXIT")) {
                            this.rMessage = "stopping client";
                            this.shouldKeep = false;
                        } else if (this.rCommand.startsWith("START")) {
                            this.runType = this.runTypeJS;
                            if (this.rCommand.length() > 5) {
                                if ("P".equals(this.rCommand.substring(5, 6))) {
                                    this.runType = this.runTypePY;
                                } else if ("R".equals(this.rCommand.substring(5, 6))) {
                                    this.runType = this.runTypeRB;
                                }
                            }
                            success = this.startRunner(this.runType, null, null);
                            this.rMessage = "startRunner for: " + this.runType;
                            if (!success) {
                                this.rMessage = "startRunner: not possible for: " + this.runType;
                                this.rStatus = this.rStatusServiceNotAvail;
                            }
                        } else if (this.rCommand.startsWith("SCRIPTS")) {
                            if (this.rRessource.isEmpty()) {
                                this.rMessage = "no scriptFolder given ";
                                this.rStatus = this.rStatusBadRequest;
                                success = false;
                            } else {
                                scriptFolder = this.getFolder(this.rRessource);
                                if (scriptFolder.getPath().startsWith("__NET/")) {
                                    scriptFolderNet = "http://" + scriptFolder.getPath().substring(6);
                                    this.rMessage = "scriptFolder now: " + scriptFolderNet;
                                } else {
                                    scriptFolderNet = null;
                                    this.rMessage = "scriptFolder now: " + scriptFolder.getAbsolutePath();
                                    if (!scriptFolder.exists()) {
                                        this.rMessage = "scriptFolder not found: " + scriptFolder.getAbsolutePath();
                                        this.rStatus = this.rStatusNotFound;
                                        success = false;
                                    }
                                }
                            }
                        } else if (this.rCommand.startsWith("IMAGES")) {
                            if (this.rRessource.isEmpty()) {
                                this.rMessage = "no imageFolder given ";
                                this.rStatus = this.rStatusBadRequest;
                                success = false;
                            } else {
                                String asImagePath;
                                imageFolder = this.getFolder(this.rRessource);
                                if (imageFolder.getPath().startsWith("__NET/")) {
                                    imageFolderNet = "http://" + imageFolder.getPath().substring(6);
                                    this.rMessage = "imageFolder now: " + imageFolderNet;
                                    asImagePath = imageFolderNet;
                                } else {
                                    String fpGiven = imageFolder.getAbsolutePath();
                                    if (!imageFolder.exists() && !(imageFolder = new File(imageFolder.getAbsolutePath() + ".sikuli")).exists()) {
                                        this.rMessage = "imageFolder not found: " + fpGiven;
                                        this.rStatus = this.rStatusNotFound;
                                        success = false;
                                    }
                                    asImagePath = imageFolder.getAbsolutePath();
                                }
                                this.rMessage = "imageFolder now: " + asImagePath;
                                ImagePath.add(asImagePath);
                            }
                        } else if (this.rCommand.startsWith("RUN")) {
                            String script = this.rRessource;
                            File fScript = null;
                            File fScriptScript = null;
                            if (scriptFolderNet != null) {
                                this.rMessage = "runScript from net not yet supported";
                                this.rStatus = this.rStatusServiceNotAvail;
                                success = false;
                            }
                            if (success) {
                                String scriptScript;
                                Debug.log("Using script folder: " + scriptFolder, new Object[0]);
                                fScript = new File(scriptFolder, script);
                                if (!fScript.exists()) {
                                    script = script.endsWith(".sikuli") ? script.replace(".sikuli", "") : script + ".sikuli";
                                    fScript = new File(scriptFolder, script);
                                }
                                if (!(success = (fScriptScript = new File(fScript, (scriptScript = script.replace(".sikuli", "")) + ".js")).exists())) {
                                    fScriptScript = new File(fScript, scriptScript + ".py");
                                    boolean bl = success = fScript.exists() && fScriptScript.exists();
                                    if (!success) {
                                        ServerRunner.dolog("Script folder path: " + fScript.getAbsolutePath(), new Object[0]);
                                        ServerRunner.dolog("Script file path: " + fScriptScript.getAbsolutePath(), new Object[0]);
                                        this.rMessage = "runScript: script not found, not valid or not supported " + fScriptScript.toString();
                                    }
                                    this.runType = this.runTypePY;
                                }
                            }
                            if (success) {
                                ImagePath.setBundlePath(fScript.getAbsolutePath());
                                ArrayList<String> args = new ArrayList<String>();
                                if (this.rQuery != null && this.rQuery.length() > 0) {
                                    String[] params;
                                    for (String param : params = this.rQuery.split("[;&]")) {
                                        String[] pair = param.split("[=]");
                                        if (pair == null || pair.length != 2) continue;
                                        String arg = String.format("--%1$s=%2$s", pair[0], pair[1]);
                                        ServerRunner.dolog("Parameter: %s", new Object[]{arg});
                                        args.add(arg);
                                    }
                                }
                                success = this.startRunner(this.runType, fScript, fScriptScript, args.toArray(new String[0]));
                            }
                        } else if (this.rCommand.startsWith("EVAL")) {
                            if (jsRunner != null) {
                                String line = this.rQuery;
                                try {
                                    this.evalReturnObject = jsRunner.eval(line);
                                    this.rMessage = "runStatement: returned: " + (this.evalReturnObject == null ? "null" : this.evalReturnObject.toString());
                                    success = true;
                                }
                                catch (Exception ex) {
                                    this.rMessage = "runStatement: raised exception on eval: " + ex.toString();
                                    success = false;
                                }
                            } else {
                                this.rMessage = "runStatement: not possible --- no runner";
                                this.rStatus = this.rStatusServiceNotAvail;
                                success = false;
                            }
                        }
                    }
                    String retVal = "";
                    if (this.isHTTP) {
                        retVal = "HTTP/1.1 " + this.rStatus;
                        String state = (success ? "PASS " : "FAIL ") + this.rStatus.substring(0, 3) + " ";
                        retVal = retVal + "\r\n\r\n" + state + this.rMessage + "\r";
                    } else {
                        retVal = (success ? "isok:\n" : "fail:\n") + this.rMessage + "\n###+++###";
                    }
                    try {
                        out.println(retVal);
                        out.flush();
                        ServerRunner.dolog("returned:\n" + retVal.replace("###+++###", ""), new Object[0]);
                    }
                    catch (Exception ex) {
                        ServerRunner.dolog(-1, "write response: Exception:\n" + ex.getMessage(), new Object[0]);
                    }
                    this.stopRunning();
                }
                catch (Exception ex) {
                    ServerRunner.dolog(-1, "while processing: Exception:\n" + ex.getMessage(), new Object[0]);
                    this.shouldKeep = false;
                    this.stopRunning();
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                this.shouldKeep = false;
                this.stopRunning();
            }
        }

        public void stopRunning() {
            if (!this.shouldKeep) {
                in.close();
                out.close();
                try {
                    this.socket.close();
                }
                catch (IOException ex) {
                    ServerRunner.dolog(-1, "fatal: socket not closeable", new Object[0]);
                    System.exit(1);
                }
                this.keepRunning = false;
            }
        }

        private File getFolder(String path) {
            File aFolder = new File(path);
            Debug.log("Original path: " + aFolder, new Object[0]);
            if (path.toLowerCase().startsWith("/home/")) {
                path = path.substring(6);
                aFolder = new File(Commons.getUserHome(), path);
            } else if (path.toLowerCase().startsWith("/net/")) {
                path = "__NET/" + path.substring(5);
                aFolder = new File(path);
            } else if (RunTime.get().runningWindows) {
                Matcher matcher = Pattern.compile("(?ix: ^ (?: / ([a-z]) [:]? /) (.*) $)").matcher(path);
                String newPath = matcher.matches() ? matcher.replaceAll("$1:/$2") : "c:" + path;
                aFolder = new File(newPath);
            }
            Debug.log("Transformed path: " + aFolder, new Object[0]);
            return aFolder;
        }

        private boolean checkRequest(String request) {
            this.shouldKeep = false;
            this.rCommand = "NOOP";
            this.rMessage = "invalid: " + request;
            this.rStatus = this.rStatusBadRequest;
            String[] parts = request.split("\\s");
            if (parts.length != 3 || !"GET".equals(parts[0]) || !parts[1].startsWith("/")) {
                return false;
            }
            if (!this.rVersion.equals(parts[2])) {
                return false;
            }
            String cmd = parts[1].substring(1);
            if (cmd.startsWith("X")) {
                cmd = cmd.substring(1);
                this.shouldKeep = true;
            }
            parts = cmd.split("\\?");
            cmd = parts[0];
            this.rQuery = "";
            if (parts.length > 1) {
                this.rQuery = parts[1];
            }
            if (!"START,STARTP,STOP,EXIT,SCRIPTS,IMAGES,RUN,EVAL,".contains(((parts = cmd.split("/"))[0] + ",").toUpperCase())) {
                this.rMessage = "invalid command: " + request;
                return false;
            }
            this.rCommand = parts[0].toUpperCase();
            this.rMessage = "";
            this.rStatus = this.rStatusOK;
            this.rRessource = "";
            if (parts.length > 1) {
                this.rRessource = cmd.substring(this.rCommand.length());
            }
            return true;
        }

        private boolean startRunner(String runType, File fScript, File fScriptScript) {
            return this.startRunner(runType, fScript, fScriptScript, new String[0]);
        }

        private boolean startRunner(String runType, File fScript, File fScriptScript, String[] args) {
            try {
                Runner.getRunner(runType).init(null);
            }
            catch (Exception ex) {
                this.rMessage = "startRunner not possible:" + ex.getMessage();
                this.rStatus = this.rStatusServiceNotAvail;
                return false;
            }
            if (fScript == null) {
                return true;
            }
            int retval = Runner.run(fScript.toString(), args, null);
            this.rMessage = "runScript: returned: " + retval;
            if (retval < 0) {
                this.rStatus = this.rStatusServiceNotAvail;
                return false;
            }
            return true;
        }
    }
}

