/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.runners;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.sikuli.basics.FileManager;
import org.sikuli.script.runners.AbortableScriptRunnerWrapper;
import org.sikuli.script.runners.AbstractLocalFileScriptRunner;
import org.sikuli.script.support.IScriptRunner;
import org.sikuli.script.support.Runner;

public class ZipRunner
extends AbstractLocalFileScriptRunner {
    public static final String NAME = "PackedSikulix";
    public static final String TYPE = "application/zip";
    public static final String[] EXTENSIONS = new String[]{"zip"};
    private AbortableScriptRunnerWrapper wrapper = new AbortableScriptRunnerWrapper();

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getExtensions() {
        return (String[])EXTENSIONS.clone();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean canHandle(String identifier) {
        if (super.canHandle(identifier)) {
            boolean bl;
            block9: {
                ZipFile file = this.openZipFile(identifier);
                try {
                    ZipEntry innerScriptFile = this.getScriptEntry(file);
                    boolean bl2 = bl = null != innerScriptFile;
                    if (file == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (file != null) {
                            try {
                                file.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.log(-1, "Error opening file %s: %s", identifier, e.getMessage());
                        return false;
                    }
                }
                file.close();
            }
            return bl;
        }
        return false;
    }

    public boolean hasTempBundle() {
        return true;
    }

    protected ZipFile openZipFile(String identifier) throws IOException {
        return new ZipFile(identifier);
    }

    protected String getScriptEntryName(ZipFile file) {
        return FilenameUtils.getBaseName((String)file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doRunScript(String zipFile, String[] scriptArgs, IScriptRunner.Options options) {
        boolean success;
        String innerScriptFile;
        block6: {
            boolean success2;
            int n;
            IScriptRunner.EffectiveRunner runnerAndFile = this.getEffectiveRunner(zipFile);
            IScriptRunner runner = runnerAndFile.getRunner();
            innerScriptFile = runnerAndFile.getScript();
            try {
                if (null == innerScriptFile) break block6;
                this.wrapper.setRunner(runner);
                n = runner.runScript(innerScriptFile, scriptArgs, options);
                this.wrapper.clearRunner();
            }
            catch (Throwable throwable) {
                boolean success3;
                this.wrapper.clearRunner();
                if (null != innerScriptFile && !(success3 = FileManager.deleteFileOrFolder(new File(innerScriptFile).getParentFile()))) {
                    this.log(-1, "Error deleting tmp dir %s", new File(innerScriptFile).getParentFile());
                }
                throw throwable;
            }
            if (null != innerScriptFile && !(success2 = FileManager.deleteFileOrFolder(new File(innerScriptFile).getParentFile()))) {
                this.log(-1, "Error deleting tmp dir %s", new File(innerScriptFile).getParentFile());
            }
            return n;
        }
        int n = 256;
        this.wrapper.clearRunner();
        if (null != innerScriptFile && !(success = FileManager.deleteFileOrFolder(new File(innerScriptFile).getParentFile()))) {
            this.log(-1, "Error deleting tmp dir %s", new File(innerScriptFile).getParentFile());
        }
        return n;
    }

    @Override
    public IScriptRunner.EffectiveRunner getEffectiveRunner(String zipFile) {
        String innerScriptFilePath = null;
        try (ZipFile file = new ZipFile(zipFile);){
            ZipEntry innerScriptFile = this.getScriptEntry(file);
            if (null != innerScriptFile) {
                File dir = this.extract(file);
                innerScriptFilePath = dir.getAbsolutePath() + File.separator + innerScriptFile.getName();
            }
        }
        catch (IOException e) {
            this.log(-1, "Error opening file %s: %s", zipFile, e.getMessage());
        }
        if (null != innerScriptFilePath) {
            return new IScriptRunner.EffectiveRunner(Runner.getRunner(innerScriptFilePath), innerScriptFilePath, null);
        }
        return new IScriptRunner.EffectiveRunner();
    }

    private ZipEntry getScriptEntry(ZipFile file) {
        Enumeration<? extends ZipEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!FilenameUtils.getBaseName((String)entry.getName()).equals(this.getScriptEntryName(file))) continue;
            for (IScriptRunner runner : Runner.getRunners()) {
                if (!runner.canHandle(entry.getName())) continue;
                return entry;
            }
        }
        return null;
    }

    private File extract(ZipFile jar) throws IOException {
        File dir = Files.createTempDirectory("sikulix", new FileAttribute[0]).toFile();
        Enumeration<? extends ZipEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File f = new File(dir.getAbsolutePath() + File.separator + entry.getName());
            if (entry.isDirectory()) {
                f.mkdirs();
                continue;
            }
            InputStream is = jar.getInputStream(entry);
            try (FileOutputStream fo = new FileOutputStream(f);){
                while (is.available() > 0) {
                    fo.write(is.read());
                }
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return dir;
    }

    @Override
    public boolean isAbortSupported() {
        return this.wrapper.isAbortSupported();
    }

    @Override
    protected void doAbort() {
        this.wrapper.doAbort();
    }
}

