/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.support;

import com.sun.jna.platform.win32.WinDef;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.sikuli.basics.Settings;
import org.sikuli.natives.SXUser32;

public class KeyboardLayout {
    private static final int DEFAULT_KEYBOARD_LAYOUT_ID = 1033;
    private static final Map<Character, int[]> DEFAULT_KEYBOARD_LAYOUT = KeyboardLayout.buildAwtEnUs();
    private static final Map<Integer, Map<Character, int[]>> LAYOUTS = new HashMap<Integer, Map<Character, int[]>>();
    private static final int[] AUTO_DETECT_VK_CODES = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 186, 226, 191, 192, 219, 220, 221, 222, 223, 240, 243, 225, 245, 254, 188, 242, 239, 244, 241, 149, 147, 150, 148, 234, 189, 235, 236, 237, 190, 187, 233, 238};
    private static final int MAPVK_VK_TO_VSC = 0;

    private static Map<Character, int[]> mapKeyCodes(int[] modifiers, int keyboarLayoutId) {
        HashMap<Character, int[]> mappings = new HashMap<Character, int[]>();
        int spaceScanCode = SXUser32.INSTANCE.MapVirtualKeyExW(32, 0, keyboarLayoutId);
        for (int vk : AUTO_DETECT_VK_CODES) {
            byte[] keyStates = new byte[256];
            int[] nArray = modifiers;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int modifier;
                int n2 = modifier = nArray[i];
                keyStates[n2] = (byte)(keyStates[n2] | 0x80);
            }
            int n3 = vk;
            keyStates[n3] = (byte)(keyStates[n3] | 0x80);
            int scanCode = SXUser32.INSTANCE.MapVirtualKeyExW(vk, 0, keyboarLayoutId);
            char[] buff = new char[1];
            int ret = SXUser32.INSTANCE.ToUnicodeEx(vk, scanCode, keyStates, buff, 1, 0, keyboarLayoutId);
            int[] codes = Arrays.copyOf(modifiers, modifiers.length + 1);
            codes[modifiers.length] = vk;
            if (ret > 0) {
                mappings.put(Character.valueOf(buff[0]), codes);
                continue;
            }
            if (ret >= 0) continue;
            keyStates = new byte[256];
            keyStates[32] = (byte)(keyStates[32] | 0x80);
            ret = SXUser32.INSTANCE.ToUnicodeEx(32, spaceScanCode, keyStates, buff, 1, 0, keyboarLayoutId);
            if (ret <= 0) continue;
            mappings.put(Character.valueOf(buff[0]), codes);
        }
        return mappings;
    }

    private static Map<Character, int[]> buildWindowsLayout(int keyboarLayoutId) {
        HashMap<Character, int[]> layout = new HashMap<Character, int[]>();
        layout.putAll(KeyboardLayout.mapKeyCodes(new int[]{17, 18}, keyboarLayoutId));
        layout.putAll(KeyboardLayout.mapKeyCodes(new int[]{16}, keyboarLayoutId));
        layout.putAll(KeyboardLayout.mapKeyCodes(new int[0], keyboarLayoutId));
        layout.put(Character.valueOf('\ue020'), new int[]{16});
        layout.put(Character.valueOf('\ue021'), new int[]{17});
        layout.put(Character.valueOf('\ue022'), new int[]{18});
        layout.put(Character.valueOf('\ue043'), new int[]{17, 18});
        layout.put(Character.valueOf('\ue023'), new int[]{91});
        layout.put(Character.valueOf('\ue000'), new int[]{38});
        layout.put(Character.valueOf('\ue001'), new int[]{39});
        layout.put(Character.valueOf('\ue002'), new int[]{40});
        layout.put(Character.valueOf('\ue003'), new int[]{37});
        layout.put(Character.valueOf('\ue004'), new int[]{33});
        layout.put(Character.valueOf('\ue005'), new int[]{34});
        layout.put(Character.valueOf('\ue007'), new int[]{35});
        layout.put(Character.valueOf('\ue008'), new int[]{36});
        layout.put(Character.valueOf('\ue006'), new int[]{46});
        layout.put(Character.valueOf('\u001b'), new int[]{27});
        layout.put(Character.valueOf('\ue011'), new int[]{112});
        layout.put(Character.valueOf('\ue012'), new int[]{113});
        layout.put(Character.valueOf('\ue013'), new int[]{114});
        layout.put(Character.valueOf('\ue014'), new int[]{115});
        layout.put(Character.valueOf('\ue015'), new int[]{116});
        layout.put(Character.valueOf('\ue016'), new int[]{117});
        layout.put(Character.valueOf('\ue017'), new int[]{118});
        layout.put(Character.valueOf('\ue018'), new int[]{119});
        layout.put(Character.valueOf('\ue019'), new int[]{120});
        layout.put(Character.valueOf('\ue01a'), new int[]{121});
        layout.put(Character.valueOf('\ue01b'), new int[]{122});
        layout.put(Character.valueOf('\ue01c'), new int[]{123});
        layout.put(Character.valueOf('\ue01d'), new int[]{124});
        layout.put(Character.valueOf('\ue01e'), new int[]{125});
        layout.put(Character.valueOf('\ue01f'), new int[]{126});
        layout.put(Character.valueOf('\ue025'), new int[]{145});
        layout.put(Character.valueOf('\ue03b'), new int[]{144});
        layout.put(Character.valueOf('\ue027'), new int[]{20});
        layout.put(Character.valueOf('\ue009'), new int[]{45});
        layout.put(Character.valueOf('\ue026'), new int[]{19});
        layout.put(Character.valueOf('\ue024'), new int[]{44});
        layout.put(Character.valueOf('\ue030'), new int[]{96});
        layout.put(Character.valueOf('\ue031'), new int[]{97});
        layout.put(Character.valueOf('\ue032'), new int[]{98});
        layout.put(Character.valueOf('\ue033'), new int[]{99});
        layout.put(Character.valueOf('\ue034'), new int[]{100});
        layout.put(Character.valueOf('\ue035'), new int[]{101});
        layout.put(Character.valueOf('\ue036'), new int[]{102});
        layout.put(Character.valueOf('\ue037'), new int[]{103});
        layout.put(Character.valueOf('\ue038'), new int[]{104});
        layout.put(Character.valueOf('\ue039'), new int[]{105});
        layout.put(Character.valueOf('\ue03a'), new int[]{108});
        layout.put(Character.valueOf('\ue03c'), new int[]{107});
        layout.put(Character.valueOf('\ue03d'), new int[]{109});
        layout.put(Character.valueOf('\ue03e'), new int[]{106});
        layout.put(Character.valueOf('\ue03f'), new int[]{111});
        layout.put(Character.valueOf('\ue040'), new int[]{110});
        layout.put(Character.valueOf('\ue041'), new int[]{93});
        layout.put(Character.valueOf('\ue042'), new int[]{91});
        layout.put(Character.valueOf('\ue044'), new int[]{-9});
        layout.put(Character.valueOf('\r'), new int[]{13});
        layout.put(Character.valueOf('\n'), new int[]{13});
        layout.put(Character.valueOf('\b'), new int[]{8});
        layout.put(Character.valueOf('\t'), new int[]{9});
        layout.put(Character.valueOf(' '), new int[]{32});
        return layout;
    }

    private static Map<Character, int[]> buildAwtEnUs() {
        HashMap<Character, int[]> layout = new HashMap<Character, int[]>();
        layout.put(Character.valueOf('a'), new int[]{65});
        layout.put(Character.valueOf('b'), new int[]{66});
        layout.put(Character.valueOf('c'), new int[]{67});
        layout.put(Character.valueOf('d'), new int[]{68});
        layout.put(Character.valueOf('e'), new int[]{69});
        layout.put(Character.valueOf('f'), new int[]{70});
        layout.put(Character.valueOf('g'), new int[]{71});
        layout.put(Character.valueOf('h'), new int[]{72});
        layout.put(Character.valueOf('i'), new int[]{73});
        layout.put(Character.valueOf('j'), new int[]{74});
        layout.put(Character.valueOf('k'), new int[]{75});
        layout.put(Character.valueOf('l'), new int[]{76});
        layout.put(Character.valueOf('m'), new int[]{77});
        layout.put(Character.valueOf('n'), new int[]{78});
        layout.put(Character.valueOf('o'), new int[]{79});
        layout.put(Character.valueOf('p'), new int[]{80});
        layout.put(Character.valueOf('q'), new int[]{81});
        layout.put(Character.valueOf('r'), new int[]{82});
        layout.put(Character.valueOf('s'), new int[]{83});
        layout.put(Character.valueOf('t'), new int[]{84});
        layout.put(Character.valueOf('u'), new int[]{85});
        layout.put(Character.valueOf('v'), new int[]{86});
        layout.put(Character.valueOf('w'), new int[]{87});
        layout.put(Character.valueOf('x'), new int[]{88});
        layout.put(Character.valueOf('y'), new int[]{89});
        layout.put(Character.valueOf('z'), new int[]{90});
        layout.put(Character.valueOf('A'), new int[]{16, 65});
        layout.put(Character.valueOf('B'), new int[]{16, 66});
        layout.put(Character.valueOf('C'), new int[]{16, 67});
        layout.put(Character.valueOf('D'), new int[]{16, 68});
        layout.put(Character.valueOf('E'), new int[]{16, 69});
        layout.put(Character.valueOf('F'), new int[]{16, 70});
        layout.put(Character.valueOf('G'), new int[]{16, 71});
        layout.put(Character.valueOf('H'), new int[]{16, 72});
        layout.put(Character.valueOf('I'), new int[]{16, 73});
        layout.put(Character.valueOf('J'), new int[]{16, 74});
        layout.put(Character.valueOf('K'), new int[]{16, 75});
        layout.put(Character.valueOf('L'), new int[]{16, 76});
        layout.put(Character.valueOf('M'), new int[]{16, 77});
        layout.put(Character.valueOf('N'), new int[]{16, 78});
        layout.put(Character.valueOf('O'), new int[]{16, 79});
        layout.put(Character.valueOf('P'), new int[]{16, 80});
        layout.put(Character.valueOf('Q'), new int[]{16, 81});
        layout.put(Character.valueOf('R'), new int[]{16, 82});
        layout.put(Character.valueOf('S'), new int[]{16, 83});
        layout.put(Character.valueOf('T'), new int[]{16, 84});
        layout.put(Character.valueOf('U'), new int[]{16, 85});
        layout.put(Character.valueOf('V'), new int[]{16, 86});
        layout.put(Character.valueOf('W'), new int[]{16, 87});
        layout.put(Character.valueOf('X'), new int[]{16, 88});
        layout.put(Character.valueOf('Y'), new int[]{16, 89});
        layout.put(Character.valueOf('Z'), new int[]{16, 90});
        layout.put(Character.valueOf('1'), new int[]{49});
        layout.put(Character.valueOf('!'), new int[]{16, 49});
        layout.put(Character.valueOf('2'), new int[]{50});
        layout.put(Character.valueOf('@'), new int[]{16, 50});
        layout.put(Character.valueOf('3'), new int[]{51});
        layout.put(Character.valueOf('#'), new int[]{16, 51});
        layout.put(Character.valueOf('4'), new int[]{52});
        layout.put(Character.valueOf('$'), new int[]{16, 52});
        layout.put(Character.valueOf('5'), new int[]{53});
        layout.put(Character.valueOf('%'), new int[]{16, 53});
        layout.put(Character.valueOf('6'), new int[]{54});
        layout.put(Character.valueOf('^'), new int[]{16, 54});
        layout.put(Character.valueOf('7'), new int[]{55});
        layout.put(Character.valueOf('&'), new int[]{16, 55});
        layout.put(Character.valueOf('8'), new int[]{56});
        layout.put(Character.valueOf('*'), new int[]{16, 56});
        layout.put(Character.valueOf('9'), new int[]{57});
        layout.put(Character.valueOf('('), new int[]{16, 57});
        layout.put(Character.valueOf('0'), new int[]{48});
        layout.put(Character.valueOf(')'), new int[]{16, 48});
        layout.put(Character.valueOf('-'), new int[]{45});
        layout.put(Character.valueOf('_'), new int[]{16, 45});
        layout.put(Character.valueOf('='), new int[]{61});
        layout.put(Character.valueOf('+'), new int[]{16, 61});
        layout.put(Character.valueOf('['), new int[]{91});
        layout.put(Character.valueOf('{'), new int[]{16, 91});
        layout.put(Character.valueOf(']'), new int[]{93});
        layout.put(Character.valueOf('}'), new int[]{16, 93});
        layout.put(Character.valueOf(';'), new int[]{59});
        layout.put(Character.valueOf(':'), new int[]{16, 59});
        layout.put(Character.valueOf('\''), new int[]{222});
        layout.put(Character.valueOf('\"'), new int[]{16, 222});
        layout.put(Character.valueOf('\\'), new int[]{92});
        layout.put(Character.valueOf('|'), new int[]{16, 92});
        layout.put(Character.valueOf('\b'), new int[]{8});
        layout.put(Character.valueOf('\t'), new int[]{9});
        layout.put(Character.valueOf('\r'), new int[]{10});
        layout.put(Character.valueOf('\n'), new int[]{10});
        layout.put(Character.valueOf(' '), new int[]{32});
        layout.put(Character.valueOf('`'), new int[]{192});
        layout.put(Character.valueOf('~'), new int[]{16, 192});
        layout.put(Character.valueOf(','), new int[]{44});
        layout.put(Character.valueOf('<'), new int[]{16, 44});
        layout.put(Character.valueOf('.'), new int[]{46});
        layout.put(Character.valueOf('>'), new int[]{16, 46});
        layout.put(Character.valueOf('/'), new int[]{47});
        layout.put(Character.valueOf('?'), new int[]{16, 47});
        layout.put(Character.valueOf('\ue020'), new int[]{16});
        layout.put(Character.valueOf('\ue021'), new int[]{17});
        layout.put(Character.valueOf('\ue022'), new int[]{18});
        layout.put(Character.valueOf('\ue023'), new int[]{157});
        layout.put(Character.valueOf('\ue043'), new int[]{65406});
        layout.put(Character.valueOf('\ue000'), new int[]{38});
        layout.put(Character.valueOf('\ue001'), new int[]{39});
        layout.put(Character.valueOf('\ue002'), new int[]{40});
        layout.put(Character.valueOf('\ue003'), new int[]{37});
        layout.put(Character.valueOf('\ue004'), new int[]{33});
        layout.put(Character.valueOf('\ue005'), new int[]{34});
        layout.put(Character.valueOf('\ue007'), new int[]{35});
        layout.put(Character.valueOf('\ue008'), new int[]{36});
        layout.put(Character.valueOf('\ue006'), new int[]{127});
        layout.put(Character.valueOf('\u001b'), new int[]{27});
        layout.put(Character.valueOf('\ue011'), new int[]{112});
        layout.put(Character.valueOf('\ue012'), new int[]{113});
        layout.put(Character.valueOf('\ue013'), new int[]{114});
        layout.put(Character.valueOf('\ue014'), new int[]{115});
        layout.put(Character.valueOf('\ue015'), new int[]{116});
        layout.put(Character.valueOf('\ue016'), new int[]{117});
        layout.put(Character.valueOf('\ue017'), new int[]{118});
        layout.put(Character.valueOf('\ue018'), new int[]{119});
        layout.put(Character.valueOf('\ue019'), new int[]{120});
        layout.put(Character.valueOf('\ue01a'), new int[]{121});
        layout.put(Character.valueOf('\ue01b'), new int[]{122});
        layout.put(Character.valueOf('\ue01c'), new int[]{123});
        layout.put(Character.valueOf('\ue01d'), new int[]{61440});
        layout.put(Character.valueOf('\ue01e'), new int[]{61441});
        layout.put(Character.valueOf('\ue01f'), new int[]{61442});
        layout.put(Character.valueOf('\ue025'), new int[]{145});
        layout.put(Character.valueOf('\ue03b'), new int[]{144});
        layout.put(Character.valueOf('\ue027'), new int[]{20});
        layout.put(Character.valueOf('\ue009'), new int[]{155});
        layout.put(Character.valueOf('\ue026'), new int[]{19});
        layout.put(Character.valueOf('\ue024'), new int[]{154});
        layout.put(Character.valueOf('\ue030'), new int[]{96});
        layout.put(Character.valueOf('\ue031'), new int[]{97});
        layout.put(Character.valueOf('\ue032'), new int[]{98});
        layout.put(Character.valueOf('\ue033'), new int[]{99});
        layout.put(Character.valueOf('\ue034'), new int[]{100});
        layout.put(Character.valueOf('\ue035'), new int[]{101});
        layout.put(Character.valueOf('\ue036'), new int[]{102});
        layout.put(Character.valueOf('\ue037'), new int[]{103});
        layout.put(Character.valueOf('\ue038'), new int[]{104});
        layout.put(Character.valueOf('\ue039'), new int[]{105});
        layout.put(Character.valueOf('\ue03a'), new int[]{108});
        layout.put(Character.valueOf('\ue03c'), new int[]{107});
        layout.put(Character.valueOf('\ue03d'), new int[]{109});
        layout.put(Character.valueOf('\ue03e'), new int[]{106});
        layout.put(Character.valueOf('\ue03f'), new int[]{111});
        layout.put(Character.valueOf('\ue040'), new int[]{110});
        layout.put(Character.valueOf('\ue041'), new int[]{525});
        layout.put(Character.valueOf('\ue042'), new int[]{524});
        layout.put(Character.valueOf('\ue044'), new int[]{-9});
        layout.put(Character.valueOf('\r'), new int[]{10});
        layout.put(Character.valueOf('\n'), new int[]{10});
        layout.put(Character.valueOf('\b'), new int[]{8});
        layout.put(Character.valueOf('\t'), new int[]{9});
        layout.put(Character.valueOf(' '), new int[]{32});
        return layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Character, int[]> getCurrentLayout() {
        Map<Character, int[]> layout = DEFAULT_KEYBOARD_LAYOUT;
        if (Settings.AutoDetectKeyboardLayout && Settings.isWindows()) {
            int threadID;
            WinDef.HKL keyboardLayoutHKL;
            int keyboarLayoutId = 1033;
            WinDef.HWND hwnd = SXUser32.INSTANCE.GetForegroundWindow();
            if (hwnd != null && (keyboardLayoutHKL = SXUser32.INSTANCE.GetKeyboardLayout(threadID = SXUser32.INSTANCE.GetWindowThreadProcessId(hwnd, null))) != null) {
                keyboarLayoutId = keyboardLayoutHKL.getLanguageIdentifier();
            }
            Map<Integer, Map<Character, int[]>> map = LAYOUTS;
            synchronized (map) {
                layout = LAYOUTS.get(keyboarLayoutId);
                if (layout == null) {
                    layout = KeyboardLayout.buildWindowsLayout(keyboarLayoutId);
                    LAYOUTS.put(keyboarLayoutId, layout);
                }
            }
        }
        return layout;
    }

    public static int[] toJavaKeyCode(char c) {
        int[] keyCodes = KeyboardLayout.getCurrentLayout().get(Character.valueOf(c));
        if (keyCodes == null) {
            throw new IllegalArgumentException("Key: Not supported character: " + c);
        }
        return keyCodes;
    }

    class WindowsVkCodes {
        public static final int VK_SHIFT = 16;
        public static final int VK_CONTROL = 17;
        public static final int VK_MENU = 18;
        public static final int VK_ABNT_C1 = 193;
        public static final int VK_ABNT_C2 = 194;
        public static final int VK_ADD = 107;
        public static final int VK_ATTN = 246;
        public static final int VK_BACK = 8;
        public static final int VK_CANCEL = 3;
        public static final int VK_CLEAR = 12;
        public static final int VK_CRSEL = 247;
        public static final int VK_DECIMAL = 110;
        public static final int VK_DIVIDE = 111;
        public static final int VK_EREOF = 249;
        public static final int VK_ESCAPE = 27;
        public static final int VK_EXECUTE = 43;
        public static final int VK_EXSEL = 248;
        public static final int VK_ICO_CLEAR = 230;
        public static final int VK_ICO_HELP = 227;
        public static final int VK_KEY_0 = 48;
        public static final int VK_KEY_1 = 49;
        public static final int VK_KEY_2 = 50;
        public static final int VK_KEY_3 = 51;
        public static final int VK_KEY_4 = 52;
        public static final int VK_KEY_5 = 53;
        public static final int VK_KEY_6 = 54;
        public static final int VK_KEY_7 = 55;
        public static final int VK_KEY_8 = 56;
        public static final int VK_KEY_9 = 57;
        public static final int VK_KEY_A = 65;
        public static final int VK_KEY_B = 66;
        public static final int VK_KEY_C = 67;
        public static final int VK_KEY_D = 68;
        public static final int VK_KEY_E = 69;
        public static final int VK_KEY_F = 70;
        public static final int VK_KEY_G = 71;
        public static final int VK_KEY_H = 72;
        public static final int VK_KEY_I = 73;
        public static final int VK_KEY_J = 74;
        public static final int VK_KEY_K = 75;
        public static final int VK_KEY_L = 76;
        public static final int VK_KEY_M = 77;
        public static final int VK_KEY_N = 78;
        public static final int VK_KEY_O = 79;
        public static final int VK_KEY_P = 80;
        public static final int VK_KEY_Q = 81;
        public static final int VK_KEY_R = 82;
        public static final int VK_KEY_S = 83;
        public static final int VK_KEY_T = 84;
        public static final int VK_KEY_U = 85;
        public static final int VK_KEY_V = 86;
        public static final int VK_KEY_W = 87;
        public static final int VK_KEY_X = 88;
        public static final int VK_KEY_Y = 89;
        public static final int VK_KEY_Z = 90;
        public static final int VK_MULTIPLY = 106;
        public static final int VK_NONAME = 252;
        public static final int VK_NUMPAD0 = 96;
        public static final int VK_NUMPAD1 = 97;
        public static final int VK_NUMPAD2 = 98;
        public static final int VK_NUMPAD3 = 99;
        public static final int VK_NUMPAD4 = 100;
        public static final int VK_NUMPAD5 = 101;
        public static final int VK_NUMPAD6 = 102;
        public static final int VK_NUMPAD7 = 103;
        public static final int VK_NUMPAD8 = 104;
        public static final int VK_NUMPAD9 = 105;
        public static final int VK_OEM_1 = 186;
        public static final int VK_OEM_102 = 226;
        public static final int VK_OEM_2 = 191;
        public static final int VK_OEM_3 = 192;
        public static final int VK_OEM_4 = 219;
        public static final int VK_OEM_5 = 220;
        public static final int VK_OEM_6 = 221;
        public static final int VK_OEM_7 = 222;
        public static final int VK_OEM_8 = 223;
        public static final int VK_OEM_ATTN = 240;
        public static final int VK_OEM_AUTO = 243;
        public static final int VK_OEM_AX = 225;
        public static final int VK_OEM_BACKTAB = 245;
        public static final int VK_OEM_CLEAR = 254;
        public static final int VK_OEM_COMMA = 188;
        public static final int VK_OEM_COPY = 242;
        public static final int VK_OEM_CUSEL = 239;
        public static final int VK_OEM_ENLW = 244;
        public static final int VK_OEM_FINISH = 241;
        public static final int VK_OEM_FJ_LOYA = 149;
        public static final int VK_OEM_FJ_MASSHOU = 147;
        public static final int VK_OEM_FJ_ROYA = 150;
        public static final int VK_OEM_FJ_TOUROKU = 148;
        public static final int VK_OEM_JUMP = 234;
        public static final int VK_OEM_MINUS = 189;
        public static final int VK_OEM_PA1 = 235;
        public static final int VK_OEM_PA2 = 236;
        public static final int VK_OEM_PA3 = 237;
        public static final int VK_OEM_PERIOD = 190;
        public static final int VK_OEM_PLUS = 187;
        public static final int VK_OEM_RESET = 233;
        public static final int VK_OEM_WSCTRL = 238;
        public static final int VK_PA1 = 253;
        public static final int VK_PACKET = 231;
        public static final int VK_PLAY = 250;
        public static final int VK_PROCESSKEY = 229;
        public static final int VK_RETURN = 13;
        public static final int VK_SELECT = 41;
        public static final int VK_SEPARATOR = 108;
        public static final int VK_SPACE = 32;
        public static final int VK_SUBTRACT = 109;
        public static final int VK_TAB = 9;
        public static final int VK_ZOOM = 251;
        public static final int VK__none_ = 255;
        public static final int VK_ACCEPT = 30;
        public static final int VK_APPS = 93;
        public static final int VK_BROWSER_BACK = 166;
        public static final int VK_BROWSER_FAVORITES = 171;
        public static final int VK_BROWSER_FORWARD = 167;
        public static final int VK_BROWSER_HOME = 172;
        public static final int VK_BROWSER_REFRESH = 168;
        public static final int VK_BROWSER_SEARCH = 170;
        public static final int VK_BROWSER_STOP = 169;
        public static final int VK_CAPITAL = 20;
        public static final int VK_CONVERT = 28;
        public static final int VK_DELETE = 46;
        public static final int VK_DOWN = 40;
        public static final int VK_END = 35;
        public static final int VK_F1 = 112;
        public static final int VK_F10 = 121;
        public static final int VK_F11 = 122;
        public static final int VK_F12 = 123;
        public static final int VK_F13 = 124;
        public static final int VK_F14 = 125;
        public static final int VK_F15 = 126;
        public static final int VK_F16 = 127;
        public static final int VK_F17 = 128;
        public static final int VK_F18 = 129;
        public static final int VK_F19 = 130;
        public static final int VK_F2 = 113;
        public static final int VK_F20 = 131;
        public static final int VK_F21 = 132;
        public static final int VK_F22 = 133;
        public static final int VK_F23 = 134;
        public static final int VK_F24 = 135;
        public static final int VK_F3 = 114;
        public static final int VK_F4 = 115;
        public static final int VK_F5 = 116;
        public static final int VK_F6 = 117;
        public static final int VK_F7 = 118;
        public static final int VK_F8 = 119;
        public static final int VK_F9 = 120;
        public static final int VK_FINAL = 24;
        public static final int VK_HELP = 47;
        public static final int VK_HOME = 36;
        public static final int VK_ICO_00 = 228;
        public static final int VK_INSERT = 45;
        public static final int VK_JUNJA = 23;
        public static final int VK_KANA = 21;
        public static final int VK_KANJI = 25;
        public static final int VK_LAUNCH_APP1 = 182;
        public static final int VK_LAUNCH_APP2 = 183;
        public static final int VK_LAUNCH_MAIL = 180;
        public static final int VK_LAUNCH_MEDIA_SELECT = 181;
        public static final int VK_LBUTTON = 1;
        public static final int VK_LCONTROL = 162;
        public static final int VK_LEFT = 37;
        public static final int VK_LMENU = 164;
        public static final int VK_LSHIFT = 160;
        public static final int VK_LWIN = 91;
        public static final int VK_MBUTTON = 4;
        public static final int VK_MEDIA_NEXT_TRACK = 176;
        public static final int VK_MEDIA_PLAY_PAUSE = 179;
        public static final int VK_MEDIA_PREV_TRACK = 177;
        public static final int VK_MEDIA_STOP = 178;
        public static final int VK_MODECHANGE = 31;
        public static final int VK_NEXT = 34;
        public static final int VK_NONCONVERT = 29;
        public static final int VK_NUMLOCK = 144;
        public static final int VK_OEM_FJ_JISHO = 146;
        public static final int VK_PAUSE = 19;
        public static final int VK_PRINT = 42;
        public static final int VK_PRIOR = 33;
        public static final int VK_RBUTTON = 2;
        public static final int VK_RCONTROL = 163;
        public static final int VK_RIGHT = 39;
        public static final int VK_RMENU = 165;
        public static final int VK_RSHIFT = 161;
        public static final int VK_RWIN = 92;
        public static final int VK_SCROLL = 145;
        public static final int VK_SLEEP = 95;
        public static final int VK_SNAPSHOT = 44;
        public static final int VK_UP = 38;
        public static final int VK_VOLUME_DOWN = 174;
        public static final int VK_VOLUME_MUTE = 173;
        public static final int VK_VOLUME_UP = 175;
        public static final int VK_XBUTTON1 = 5;
        public static final int VK_XBUTTON2 = 6;

        WindowsVkCodes() {
        }
    }
}

