/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb.managers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.vidstige.jadb.JadbDevice;
import se.vidstige.jadb.JadbException;

public class PropertyManager {
    private final Pattern pattern = Pattern.compile("^\\[([a-zA-Z0-9_.-]*)]:.\\[([^\\[\\]]*)]");
    private final JadbDevice device;

    public PropertyManager(JadbDevice device) {
        this.device = device;
    }

    public Map<String, String> getprop() throws IOException, JadbException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.device.executeShell("getprop", new String[0]), StandardCharsets.UTF_8));){
            Map<String, String> map = this.parseProp(bufferedReader);
            return map;
        }
    }

    private Map<String, String> parseProp(BufferedReader bufferedReader) throws IOException {
        String line;
        HashMap<String, String> result = new HashMap<String, String>();
        Matcher matcher = this.pattern.matcher("");
        while ((line = bufferedReader.readLine()) != null) {
            matcher.reset(line);
            if (!matcher.find()) continue;
            if (matcher.groupCount() < 2) {
                System.err.println("Property line: " + line + " does not match pattern. Ignoring");
                continue;
            }
            String key = matcher.group(1);
            String value = matcher.group(2);
            result.put(key, value);
        }
        return result;
    }
}

