/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.silanis.esl.api.model.BaseMessage;
import com.silanis.esl.api.model.Document;
import com.silanis.esl.api.model.MessageStatus;
import com.silanis.esl.api.model.User;
import com.silanis.esl.api.util.JsonDateDeserializer;
import com.silanis.esl.api.util.JsonDateSerializer;
import com.silanis.esl.api.util.SchemaSanitizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Message
extends BaseMessage
implements Serializable {
    @JsonIgnore
    public static final String FIELD_CONTENT = "content";
    @JsonIgnore
    public static final String FIELD_CREATED = "created";
    @JsonIgnore
    public static final String FIELD_DOCUMENTS = "documents";
    @JsonIgnore
    public static final String FIELD_FROM = "from";
    @JsonIgnore
    public static final String FIELD_STATUS = "status";
    @JsonIgnore
    public static final String FIELD_TO = "to";
    protected Date _created;
    protected List<Document> _documents = new ArrayList<Document>();
    protected User _from;
    protected MessageStatus _status = MessageStatus.NEW;
    protected List<User> _to = new ArrayList<User>();

    @Override
    public Message setContent(String value) {
        super.setContent(value);
        return this;
    }

    @Override
    @JsonIgnore
    public Message safeSetContent(String value) {
        if (value != null) {
            this.setContent(value);
        }
        return this;
    }

    @JsonDeserialize(using=JsonDateDeserializer.class)
    public Message setCreated(Date value) {
        SchemaSanitizer.throwOnNull(FIELD_CREATED, value);
        this._created = value;
        this.setDirty(FIELD_CREATED);
        return this;
    }

    @JsonIgnore
    public Message safeSetCreated(Date value) {
        if (value != null) {
            this.setCreated(value);
        }
        return this;
    }

    @JsonSerialize(using=JsonDateSerializer.class)
    public Date getCreated() {
        return this._created;
    }

    public Message setDocuments(List<Document> value) {
        SchemaSanitizer.throwOnNull(FIELD_DOCUMENTS, value);
        this._documents = value;
        this.setDirty(FIELD_DOCUMENTS);
        return this;
    }

    @JsonIgnore
    public Message safeSetDocuments(List<Document> value) {
        if (value != null) {
            this.setDocuments(value);
        }
        return this;
    }

    public List<Document> getDocuments() {
        return this._documents;
    }

    public Message addDocument(Document value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this._documents.add(value);
        this.setDirty(FIELD_DOCUMENTS);
        return this;
    }

    public Message setFrom(User value) {
        SchemaSanitizer.throwOnNull(FIELD_FROM, value);
        this._from = value;
        this.setDirty(FIELD_FROM);
        return this;
    }

    @JsonIgnore
    public Message safeSetFrom(User value) {
        if (value != null) {
            this.setFrom(value);
        }
        return this;
    }

    public User getFrom() {
        return this._from;
    }

    public Message setStatus(MessageStatus value) {
        SchemaSanitizer.throwOnNull(FIELD_STATUS, (Object)value);
        this._status = value;
        this.setDirty(FIELD_STATUS);
        return this;
    }

    @JsonIgnore
    public Message safeSetStatus(MessageStatus value) {
        if (value != null) {
            this.setStatus(value);
        }
        return this;
    }

    public MessageStatus getStatus() {
        return this._status;
    }

    public Message setTo(List<User> value) {
        SchemaSanitizer.throwOnNull(FIELD_TO, value);
        this._to = value;
        this.setDirty(FIELD_TO);
        return this;
    }

    @JsonIgnore
    public Message safeSetTo(List<User> value) {
        if (value != null) {
            this.setTo(value);
        }
        return this;
    }

    public List<User> getTo() {
        return this._to;
    }

    public Message addTo(User value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this._to.add(value);
        this.setDirty(FIELD_TO);
        return this;
    }
}

