/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.api.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class JsonDateDeserializer
extends JsonDeserializer<Date> {
    private static final String ISO_8061 = "yyyy-MM-dd'T'HH:mm:ss";

    public static String asIso8061(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(ISO_8061);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date) + "Z";
    }

    public static Date extractIso8061Date(String strValue) throws ParseException {
        SimpleDateFormat dateParser = new SimpleDateFormat(ISO_8061);
        dateParser.setLenient(true);
        if (strValue.endsWith("Z")) {
            dateParser.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return dateParser.parse(strValue);
    }

    public Date deserialize(JsonParser jsonparser, DeserializationContext deserializationcontext) throws IOException, JsonProcessingException {
        String date = jsonparser.getText();
        if (date == null) {
            return null;
        }
        try {
            return JsonDateDeserializer.extractIso8061Date(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

