/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.api.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class JsonDateSerializer
extends JsonSerializer<Date> {
    private static final String ISO_8061 = "yyyy-MM-dd'T'HH:mm:ss";

    public static String asIso8061(Date date) {
        if (null == date) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(ISO_8061);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date) + "Z";
    }

    public void serialize(Date value, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonProcessingException {
        gen.writeString(JsonDateSerializer.asIso8061(value));
    }
}

