/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk;

import com.silanis.esl.api.model.PackageStatus;
import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackageAttributes;
import com.silanis.esl.sdk.DocumentPackageSettings;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.SenderInfo;
import com.silanis.esl.sdk.Signer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class DocumentPackage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Map<String, Signer> signers;
    private final Map<String, Document> documents;
    private final boolean autocomplete;
    private String description;
    private Date expiryDate;
    private String packageMessage;
    private PackageId id;
    private PackageStatus status;
    private DocumentPackageSettings settings;
    private Locale language;
    private DocumentPackageAttributes attributes;
    private SenderInfo senderInfo;

    public DocumentPackage(String name, Map<String, Signer> signers, Map<String, Document> documents, boolean autocomplete) {
        this.name = name;
        this.signers = signers;
        this.documents = documents;
        this.autocomplete = autocomplete;
    }

    public String getName() {
        return this.name;
    }

    public Signer getSigner(String email) {
        return this.signers.get(email);
    }

    public Map<String, Signer> getSigners() {
        return this.signers;
    }

    public Document getDocument(String name) {
        return this.documents.get(name);
    }

    public boolean getAutocomplete() {
        return this.autocomplete;
    }

    public Collection<Document> getDocuments() {
        return this.documents.values();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setPackageMessage(String packageMessage) {
        this.packageMessage = packageMessage;
    }

    public String getPackageMessage() {
        return this.packageMessage;
    }

    public void setId(PackageId id) {
        this.id = id;
    }

    public PackageId getId() {
        return this.id;
    }

    public void setStatus(PackageStatus status) {
        this.status = status;
    }

    public PackageStatus getStatus() {
        return this.status;
    }

    public DocumentPackageSettings getSettings() {
        return this.settings;
    }

    public void setSettings(DocumentPackageSettings settings) {
        this.settings = settings;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public void setSenderInfo(SenderInfo senderInfo) {
        this.senderInfo = senderInfo;
    }

    public SenderInfo getSenderInfo() {
        return this.senderInfo;
    }

    public DocumentPackageAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(DocumentPackageAttributes attributes) {
        this.attributes = attributes;
    }
}

