/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk;

import com.silanis.esl.api.model.Package;
import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentId;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.FieldSummary;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.SessionToken;
import com.silanis.esl.sdk.SignerId;
import com.silanis.esl.sdk.SigningStatus;
import com.silanis.esl.sdk.internal.Asserts;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.converter.DocumentConverter;
import com.silanis.esl.sdk.internal.converter.DocumentPackageConverter;
import com.silanis.esl.sdk.service.AccountService;
import com.silanis.esl.sdk.service.AuditService;
import com.silanis.esl.sdk.service.CustomFieldService;
import com.silanis.esl.sdk.service.EventNotificationService;
import com.silanis.esl.sdk.service.FieldSummaryService;
import com.silanis.esl.sdk.service.GroupService;
import com.silanis.esl.sdk.service.PackageService;
import com.silanis.esl.sdk.service.SessionService;
import java.util.List;

public class EslClient {
    private String baseURL;
    private PackageService packageService;
    private SessionService sessionService;
    private FieldSummaryService fieldSummaryService;
    private AuditService auditService;
    private EventNotificationService eventNotificationService;
    private GroupService groupService;
    private CustomFieldService customFieldService;
    private AccountService accountService;

    public EslClient(String apiKey, String baseURL) {
        Asserts.notNullOrEmpty(apiKey, "apiKey");
        Asserts.notNullOrEmpty(baseURL, "baseURL");
        this.baseURL = baseURL;
        RestClient client = new RestClient(apiKey);
        this.packageService = new PackageService(client, this.baseURL);
        this.sessionService = new SessionService(client, this.baseURL);
        this.fieldSummaryService = new FieldSummaryService(client, this.baseURL);
        this.auditService = new AuditService(client, this.baseURL);
        this.eventNotificationService = new EventNotificationService(client, this.baseURL);
        this.groupService = new GroupService(client, this.baseURL);
        this.customFieldService = new CustomFieldService(client, this.baseURL);
        this.accountService = new AccountService(client, this.baseURL);
    }

    String getBaseURL() {
        return this.baseURL;
    }

    public PackageService getPackageService() {
        return this.packageService;
    }

    public SessionService getSessionService() {
        return this.sessionService;
    }

    public FieldSummaryService getFieldSummaryService() {
        return this.fieldSummaryService;
    }

    public AuditService getAuditService() {
        return this.auditService;
    }

    public EventNotificationService getEventNotificationService() {
        return this.eventNotificationService;
    }

    public CustomFieldService getCustomFieldService() {
        return this.customFieldService;
    }

    public PackageId createPackage(DocumentPackage documentPackage) {
        Package packageToCreate = new DocumentPackageConverter(documentPackage).toAPIPackage();
        PackageId id = this.packageService.createPackage(packageToCreate);
        for (Document document : documentPackage.getDocuments()) {
            this.packageService.uploadDocument(id, document.getFileName(), document.getContent(), new DocumentConverter(document).toAPIDocument(packageToCreate));
        }
        return id;
    }

    public PackageId createAndSendPackage(DocumentPackage documentPackage) {
        PackageId result = this.createPackage(documentPackage);
        this.sendPackage(result);
        return result;
    }

    public PackageId createPackageFromTemplate(DocumentPackage documentPackage, PackageId packageId) {
        Package packageToCreate = new DocumentPackageConverter(documentPackage).toAPIPackage();
        return this.packageService.createPackageFromTemplate(packageId, packageToCreate);
    }

    public void sendPackage(PackageId id) {
        this.packageService.sendPackage(id);
    }

    public List<FieldSummary> getFieldValues(PackageId packageId) {
        return this.getFieldSummaryService().getFieldSummary(packageId);
    }

    public SessionToken createSessionToken(PackageId packageId, String signerId) throws EslException {
        return this.sessionService.createSessionToken(packageId.getId(), signerId);
    }

    public DocumentPackage getPackage(PackageId packageId) {
        Package aPackage = this.packageService.getPackage(packageId);
        return new DocumentPackageConverter(aPackage).toSDKPackage();
    }

    public byte[] downloadDocument(PackageId packageId, String documentId) {
        return this.packageService.downloadDocument(packageId, documentId);
    }

    public byte[] downloadEvidenceSummary(PackageId packageId) {
        return this.packageService.downloadEvidenceSummary(packageId);
    }

    public byte[] downloadZippedDocuments(PackageId packageId) {
        return this.packageService.downloadZippedDocuments(packageId);
    }

    public SigningStatus getSigningStatus(PackageId packageId, SignerId signerId, DocumentId documentId) {
        return this.packageService.getSigningStatus(packageId, signerId, documentId);
    }

    public void uploadDocument(String fileName, byte[] fileContent, Document document, DocumentPackage documentPackage) {
        Package apiPackage = new DocumentPackageConverter(documentPackage).toAPIPackage();
        this.packageService.uploadDocument(documentPackage.getId(), fileName, fileContent, new DocumentConverter(document).toAPIDocument(apiPackage));
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public AccountService getAccountService() {
        return this.accountService;
    }
}

