/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk;

import com.silanis.esl.sdk.Authentication;
import com.silanis.esl.sdk.AuthenticationMethod;
import com.silanis.esl.sdk.Challenge;
import com.silanis.esl.sdk.GroupId;
import java.io.Serializable;
import java.util.List;

public class Signer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String email;
    private final GroupId groupId;
    private final String firstName;
    private final String lastName;
    private final Authentication authentication;
    private int signingOrder;
    private String title;
    private String company;
    private boolean canChangeSigner;
    private String message;
    private boolean deliverSignedDocumentsByEmail;
    private String id;
    private boolean locked;

    public Signer(String email, String firstName, String lastName, Authentication authentication) {
        this.email = email;
        this.firstName = firstName;
        this.lastName = lastName;
        this.authentication = authentication;
        this.groupId = null;
    }

    public Signer(GroupId groupId) {
        this.email = null;
        this.firstName = null;
        this.lastName = null;
        this.authentication = new Authentication(AuthenticationMethod.EMAIL);
        this.groupId = groupId;
    }

    public boolean isGroupSigner() {
        return this.groupId != null;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setSigningOrder(int signingOrder) {
        this.signingOrder = signingOrder;
    }

    public int getSigningOrder() {
        return this.signingOrder;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.authentication.getMethod();
    }

    public List<Challenge> getChallengeQuestions() {
        return this.authentication.getChallenges();
    }

    public String getPhoneNumber() {
        return this.authentication.getPhoneNumber();
    }

    public String getTitle() {
        return this.title;
    }

    public String getCompany() {
        return this.company;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public void setCanChangeSigner(boolean canChangeSigner) {
        this.canChangeSigner = canChangeSigner;
    }

    public boolean canChangeSigner() {
        return this.canChangeSigner;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setDeliverSignedDocumentsByEmail(boolean deliverSignedDocumentsByEmail) {
        this.deliverSignedDocumentsByEmail = deliverSignedDocumentsByEmail;
    }

    public boolean isDeliverSignedDocumentsByEmail() {
        return this.deliverSignedDocumentsByEmail;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public GroupId getGroupId() {
        return this.groupId;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }
}

