/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.CeremonyLayoutSettings;
import com.silanis.esl.sdk.DocumentPackageSettings;
import com.silanis.esl.sdk.builder.CeremonyLayoutSettingsBuilder;
import com.silanis.esl.sdk.internal.Asserts;
import java.util.ArrayList;
import java.util.List;

public class DocumentPackageSettingsBuilder {
    private Boolean enableInPerson = null;
    private Boolean enableOptOut = null;
    private Boolean enableDecline = null;
    private Boolean hideWatermark = null;
    private Boolean hideCaptureText = null;
    private List<String> optOutReasons = new ArrayList<String>();
    private Integer maxAuthAttempts = null;
    private Boolean showDocumentToolbarDownloadButton = true;
    private Boolean showDialogOnComplete = null;
    private String linkText = null;
    private String linkTooltip = null;
    private String linkHref = null;
    private CeremonyLayoutSettings ceremonyLayoutSettings = null;

    private DocumentPackageSettingsBuilder() {
    }

    public static DocumentPackageSettingsBuilder newDocumentPackageSettings() {
        return new DocumentPackageSettingsBuilder();
    }

    public DocumentPackageSettingsBuilder withDialogOnComplete() {
        this.showDialogOnComplete = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutDialogOnComplete() {
        this.showDialogOnComplete = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withInPerson() {
        this.enableInPerson = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutInPerson() {
        this.enableInPerson = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withOptOut() {
        this.enableOptOut = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutOptOut() {
        this.enableOptOut = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withDecline() {
        this.enableDecline = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutDecline() {
        this.enableDecline = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withWatermark() {
        this.hideWatermark = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutWatermark() {
        this.hideWatermark = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutCaptureText() {
        this.hideCaptureText = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withHandOverLinkHref(String href) {
        Asserts.notNullOrEmpty(href, "href");
        this.linkHref = href;
        if (!this.linkHref.startsWith("http://") && !this.linkHref.startsWith("https://")) {
            this.linkHref = "https://" + this.linkHref;
        }
        return this;
    }

    public DocumentPackageSettingsBuilder withHandOverLinkText(String text) {
        this.linkText = text;
        return this;
    }

    public DocumentPackageSettingsBuilder withHandOverLinkTooltip(String tooltip) {
        this.linkTooltip = tooltip;
        return this;
    }

    public DocumentPackageSettingsBuilder withCeremonyLayoutSettings(CeremonyLayoutSettingsBuilder ceremonyLayoutSettingsBuilder) {
        return this.withCeremonyLayoutSettings(ceremonyLayoutSettingsBuilder.build());
    }

    public DocumentPackageSettingsBuilder withCeremonyLayoutSettings(CeremonyLayoutSettings ceremonyLayoutSettings) {
        this.ceremonyLayoutSettings = ceremonyLayoutSettings;
        return this;
    }

    public DocumentPackageSettings build() {
        DocumentPackageSettings result = new DocumentPackageSettings();
        result.setEnableInPerson(this.enableInPerson);
        result.setEnableOptOut(this.enableOptOut);
        result.setEnableDecline(this.enableDecline);
        result.setHideWatermark(this.hideWatermark);
        result.setHideCaptureText(this.hideCaptureText);
        result.getOptOutReasons().addAll(this.optOutReasons);
        result.setMaxAuthAttempts(this.maxAuthAttempts);
        result.setShowDocumentToolbarDownloadButton(this.showDocumentToolbarDownloadButton);
        result.setShowDialogOnComplete(this.showDialogOnComplete);
        result.setLinkHref(this.linkHref);
        result.setLinkText(this.linkText);
        result.setLinkTooltip(this.linkTooltip);
        result.setCeremonyLayoutSettings(this.ceremonyLayoutSettings);
        return result;
    }

    public DocumentPackageSettingsBuilder withOptOutReason(String reason) {
        this.optOutReasons.add(reason);
        return this;
    }

    public DocumentPackageSettingsBuilder withDocumentToolbarDownloadButton() {
        this.showDocumentToolbarDownloadButton = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutDocumentToolbarDownloadButton() {
        this.showDocumentToolbarDownloadButton = false;
        return this;
    }
}

