/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.Field;
import com.silanis.esl.sdk.FieldId;
import com.silanis.esl.sdk.FieldStyle;
import com.silanis.esl.sdk.FieldValidator;
import com.silanis.esl.sdk.TextAnchor;
import com.silanis.esl.sdk.builder.FieldValidatorBuilder;
import com.silanis.esl.sdk.builder.TextAnchorBuilder;

public class FieldBuilder {
    public static final int DEFAULT_WIDTH = 200;
    public static final int DEFAULT_HEIGHT = 50;
    public static final FieldStyle DEFAULT_STYLE = FieldStyle.UNBOUND_TEXT_FIELD;
    private int pageNumber;
    private double x;
    private double y;
    private double width = 200.0;
    private double height = 50.0;
    private FieldStyle style = DEFAULT_STYLE;
    private String name;
    private boolean extract;
    private FieldValidator fieldValidator;
    private String value;
    private FieldId fieldId;
    private TextAnchor textAnchor;

    public static FieldBuilder newField() {
        return new FieldBuilder();
    }

    public static FieldBuilder signatureDate() {
        return new FieldBuilder().withStyle(FieldStyle.BOUND_DATE);
    }

    public static FieldBuilder signerName() {
        return new FieldBuilder().withStyle(FieldStyle.BOUND_NAME);
    }

    public static FieldBuilder signerTitle() {
        return new FieldBuilder().withStyle(FieldStyle.BOUND_TITLE);
    }

    public static FieldBuilder signerCompany() {
        return new FieldBuilder().withStyle(FieldStyle.BOUND_COMPANY);
    }

    public static FieldBuilder textField() {
        return new FieldBuilder().withStyle(FieldStyle.UNBOUND_TEXT_FIELD);
    }

    public static FieldBuilder customField() {
        return new FieldBuilder().withStyle(FieldStyle.UNBOUND_CUSTOM_FIELD);
    }

    public static FieldBuilder checkBox() {
        return new FieldBuilder().withStyle(FieldStyle.UNBOUND_CHECK_BOX);
    }

    public static FieldBuilder label() {
        return new FieldBuilder().withStyle(FieldStyle.LABEL);
    }

    public FieldBuilder onPage(int pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public FieldBuilder atPosition(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public FieldBuilder withSize(double width, double height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public FieldBuilder withStyle(FieldStyle style) {
        this.style = style;
        return this;
    }

    public FieldBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public FieldBuilder withPositionExtracted() {
        this.extract = true;
        return this;
    }

    public FieldBuilder withPositionAnchor(TextAnchorBuilder builder) {
        return this.withPositionAnchor(builder.build());
    }

    public FieldBuilder withPositionAnchor(TextAnchor textAnchor) {
        this.textAnchor = textAnchor;
        return this;
    }

    public FieldBuilder withValidation(FieldValidator fieldValidator) {
        this.fieldValidator = fieldValidator;
        return this;
    }

    public FieldBuilder withValidation(FieldValidatorBuilder builder) {
        return this.withValidation(builder.build());
    }

    public FieldBuilder withValue(boolean value) {
        if (this.style == FieldStyle.UNBOUND_CHECK_BOX) {
            this.value = value ? "X" : "";
        }
        return this;
    }

    public FieldBuilder withValue(String value) {
        this.value = value;
        return this;
    }

    public FieldBuilder withId(FieldId fieldId) {
        this.fieldId = fieldId;
        return this;
    }

    public Field build() {
        Field field = new Field();
        field.setPage(this.pageNumber);
        field.setX(this.x);
        field.setY(this.y);
        field.setStyle(this.style);
        field.setWidth(this.width);
        field.setHeight(this.height);
        field.setName(this.name);
        field.setExtraction(this.extract);
        field.setFieldValidator(this.fieldValidator);
        field.setValue(this.value);
        if (this.fieldId != null) {
            field.setId(this.fieldId);
        }
        if (this.textAnchor != null) {
            field.setTextAnchor(this.textAnchor);
        }
        return field;
    }
}

