/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.api.model.PackageStatus;
import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentPackageAttributes;
import com.silanis.esl.sdk.DocumentPackageSettings;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.SenderInfo;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.DocumentPackageAttributesBuilder;
import com.silanis.esl.sdk.builder.DocumentPackageSettingsBuilder;
import com.silanis.esl.sdk.builder.SenderInfoBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PackageBuilder {
    private final String packageName;
    private final Map<String, Signer> signers = new HashMap<String, Signer>();
    private Map<String, Document> documents = new HashMap<String, Document>();
    private boolean autocomplete = true;
    private String description = "";
    private Date expiryDate;
    private String packageMessage = "";
    private PackageId id;
    private PackageStatus status;
    private DocumentPackageSettings settings;
    private Locale language;
    private SenderInfo senderInfo = null;
    private DocumentPackageAttributes attributes;

    public PackageBuilder(String packageName) {
        this.packageName = packageName;
    }

    public static PackageBuilder newPackageNamed(String name) {
        return new PackageBuilder(name);
    }

    public PackageBuilder withID(PackageId id) {
        this.id = id;
        return this;
    }

    public PackageBuilder withSigner(SignerBuilder builder) {
        return this.withSigner(builder.build());
    }

    public PackageBuilder withSigner(Signer signer) {
        if (signer.isGroupSigner()) {
            this.signers.put(signer.getGroupId().toString(), signer);
        } else {
            this.signers.put(signer.getEmail(), signer);
        }
        return this;
    }

    public PackageBuilder withDocument(DocumentBuilder builder) {
        return this.withDocument(builder.build());
    }

    public PackageBuilder withDocument(Document document) {
        this.addDocument(document);
        return this;
    }

    public DocumentPackage build() {
        DocumentPackage documentPackage = new DocumentPackage(this.packageName, this.signers, this.documents, this.autocomplete);
        documentPackage.setDescription(this.description);
        documentPackage.setExpiryDate(this.expiryDate);
        documentPackage.setPackageMessage(this.packageMessage);
        documentPackage.setId(this.id);
        documentPackage.setStatus(this.status);
        documentPackage.setSenderInfo(this.senderInfo);
        documentPackage.setAttributes(this.attributes);
        if (this.language != null) {
            documentPackage.setLanguage(this.language);
        }
        if (this.settings != null) {
            documentPackage.setSettings(this.settings);
        }
        return documentPackage;
    }

    private void addDocument(Document document) {
        this.documents.put(document.getName(), document);
    }

    public PackageBuilder autocomplete(boolean autocomplete) {
        this.autocomplete = autocomplete;
        return this;
    }

    public PackageBuilder withStatus(PackageStatus status) {
        this.status = status;
        return this;
    }

    public PackageBuilder describedAs(String description) {
        this.description = description;
        return this;
    }

    public PackageBuilder expiresAt(Date expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    public PackageBuilder withEmailMessage(String packageMessage) {
        this.packageMessage = packageMessage;
        return this;
    }

    public PackageBuilder withSettings(DocumentPackageSettingsBuilder builder) {
        return this.withSettings(builder.build());
    }

    public PackageBuilder withSettings(DocumentPackageSettings settings) {
        this.settings = settings;
        return this;
    }

    public PackageBuilder withLanguage(Locale language) {
        this.language = language;
        return this;
    }

    public PackageBuilder withSenderInfo(SenderInfoBuilder senderInfoBuilder) {
        return this.withSenderInfo(senderInfoBuilder.build());
    }

    public PackageBuilder withSenderInfo(SenderInfo senderInfo) {
        this.senderInfo = senderInfo;
        return this;
    }

    public PackageBuilder withAttributes(DocumentPackageAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public PackageBuilder withAttributes(DocumentPackageAttributesBuilder builder) {
        return this.withAttributes(builder.build());
    }
}

