/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.Field;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.Signature;
import com.silanis.esl.sdk.SignatureStyle;
import com.silanis.esl.sdk.TextAnchor;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.TextAnchorBuilder;
import java.util.ArrayList;
import java.util.Collection;

public final class SignatureBuilder {
    public static final double DEFAULT_WIDTH = 200.0;
    public static final double DEFAULT_HEIGHT = 50.0;
    public static final SignatureStyle DEFAULT_STYLE = SignatureStyle.FULL_NAME;
    private GroupId groupId;
    private String name;
    private String signerEmail;
    private int pageNumber;
    private double x;
    private double y;
    private double width = 200.0;
    private double height = 50.0;
    private SignatureStyle style = DEFAULT_STYLE;
    private Collection<Field> fields = new ArrayList<Field>();
    private boolean extract;
    private TextAnchor textAnchor;

    private SignatureBuilder(String email) {
        this.signerEmail = email;
        this.groupId = null;
    }

    private SignatureBuilder(GroupId groupId) {
        this.groupId = groupId;
        this.signerEmail = null;
    }

    public static SignatureBuilder signatureFor(String signerEmail) {
        return new SignatureBuilder(signerEmail);
    }

    public static SignatureBuilder signatureFor(GroupId groupId) {
        return new SignatureBuilder(groupId);
    }

    public static SignatureBuilder acceptanceFor(String signerEmail) {
        SignatureBuilder builder = SignatureBuilder.signatureFor(signerEmail).withStyle(SignatureStyle.ACCEPTANCE).atPosition(0.0, 0.0).withSize(0.0, 0.0).onPage(0);
        return builder;
    }

    public static SignatureBuilder acceptanceFor(GroupId groupId) {
        SignatureBuilder builder = SignatureBuilder.signatureFor(groupId).withStyle(SignatureStyle.ACCEPTANCE).atPosition(0.0, 0.0).withSize(0.0, 0.0).onPage(0);
        return builder;
    }

    public static SignatureBuilder initialsFor(String signerEmail) {
        return new SignatureBuilder(signerEmail).withStyle(SignatureStyle.INITIALS);
    }

    public static SignatureBuilder initialsFor(GroupId groupId) {
        return new SignatureBuilder(groupId).withStyle(SignatureStyle.INITIALS);
    }

    public static SignatureBuilder captureFor(String signerEmail) {
        return new SignatureBuilder(signerEmail).withStyle(SignatureStyle.HAND_DRAWN);
    }

    public static SignatureBuilder captureFor(GroupId groupId) {
        return new SignatureBuilder(groupId).withStyle(SignatureStyle.HAND_DRAWN);
    }

    public SignatureBuilder onPage(int pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public SignatureBuilder atPosition(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public SignatureBuilder withSize(double width, double height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public SignatureBuilder withStyle(SignatureStyle style) {
        this.style = style;
        return this;
    }

    public SignatureBuilder withField(FieldBuilder builder) {
        return this.withField(builder.build());
    }

    public SignatureBuilder withField(Field field) {
        this.fields.add(field);
        return this;
    }

    public SignatureBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public SignatureBuilder withPositionExtracted() {
        this.extract = true;
        return this;
    }

    public SignatureBuilder withPositionAnchor(TextAnchorBuilder builder) {
        return this.withPositionAnchor(builder.build());
    }

    public SignatureBuilder withPositionAnchor(TextAnchor textAnchor) {
        this.textAnchor = textAnchor;
        return this;
    }

    public Signature build() {
        Signature signature = this.signerEmail != null ? new Signature(this.signerEmail, this.pageNumber, this.x, this.y) : new Signature(this.groupId, this.pageNumber, this.x, this.y);
        signature.setName(this.name);
        signature.setStyle(this.style);
        signature.setWidth(this.width);
        signature.setHeight(this.height);
        signature.addFields(this.fields);
        signature.setExtraction(this.extract);
        signature.setTextAnchor(this.textAnchor);
        return signature;
    }
}

