/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.Authentication;
import com.silanis.esl.sdk.AuthenticationMethod;
import com.silanis.esl.sdk.Challenge;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.internal.Asserts;
import java.util.ArrayList;
import java.util.List;

public final class SignerBuilder {
    public static final int DEFAULT_SIGNING_ORDER = 0;
    private final String email;
    private final GroupId groupId;
    private String firstName;
    private String lastName;
    private int signingOrder = 0;
    private AuthenticationBuilder authenticationBuilder = new AuthenticationBuilder();
    private String title = "";
    private String company = "";
    private boolean canChangeSigner;
    private String message = "";
    private boolean deliverSignedDocumentsByEmail;
    private String id = null;
    private boolean locked = false;

    private SignerBuilder(String email) {
        this.email = email;
        this.groupId = null;
    }

    private SignerBuilder(GroupId groupId) {
        this.email = null;
        this.groupId = groupId;
    }

    public static SignerBuilder newSignerWithEmail(String email) {
        return new SignerBuilder(email);
    }

    public static SignerBuilder newSignerFromGroup(GroupId groupId) {
        return new SignerBuilder(groupId);
    }

    public SignerBuilder withCustomId(String id) {
        this.id = id;
        return this;
    }

    public SignerBuilder withFirstName(String firstName) {
        Asserts.genericAssert(!this.isGroupSigner(), "first name can not be set for a group signer");
        this.firstName = firstName;
        return this;
    }

    public SignerBuilder withLastName(String lastName) {
        Asserts.genericAssert(!this.isGroupSigner(), "last name can not be set for a group signer");
        this.lastName = lastName;
        return this;
    }

    public SignerBuilder signingOrder(int signingOrder) {
        this.signingOrder = signingOrder;
        return this;
    }

    public Signer build() {
        Signer signer;
        Authentication authentication = this.authenticationBuilder.build();
        if (this.isGroupSigner()) {
            signer = new Signer(this.groupId);
        } else {
            Asserts.notNullOrEmpty(this.firstName, "first name");
            Asserts.notNullOrEmpty(this.lastName, "last name");
            signer = new Signer(this.email, this.firstName, this.lastName, authentication);
            signer.setTitle(this.title);
            signer.setCompany(this.company);
            signer.setDeliverSignedDocumentsByEmail(this.deliverSignedDocumentsByEmail);
        }
        signer.setSigningOrder(this.signingOrder);
        signer.setCanChangeSigner(this.canChangeSigner);
        signer.setMessage(this.message);
        signer.setId(this.id);
        signer.setLocked(this.locked);
        return signer;
    }

    public SignerBuilder challengedWithQuestions(ChallengeBuilder challengeBuilder) {
        this.authenticationBuilder = challengeBuilder;
        return this;
    }

    public SignerBuilder withSmsSentTo(String phoneNumber) {
        this.authenticationBuilder = new SMSAuthenticationBuilder(phoneNumber);
        return this;
    }

    public SignerBuilder withTitle(String title) {
        Asserts.genericAssert(!this.isGroupSigner(), "title can not be set for a group signer");
        this.title = title;
        return this;
    }

    public SignerBuilder withCompany(String company) {
        Asserts.genericAssert(!this.isGroupSigner(), "company can not be set for a group signer");
        this.company = company;
        return this;
    }

    public SignerBuilder canChangeSigner() {
        this.canChangeSigner = true;
        return this;
    }

    public SignerBuilder withEmailMessage(String message) {
        this.message = message;
        return this;
    }

    public SignerBuilder deliverSignedDocumentsByEmail() {
        this.deliverSignedDocumentsByEmail = true;
        return this;
    }

    public SignerBuilder lock() {
        this.locked = true;
        return this;
    }

    @Deprecated
    public SignerBuilder withRoleId(String roleId) {
        return this.withCustomId(roleId);
    }

    private boolean isGroupSigner() {
        return this.groupId != null;
    }

    public static class SMSAuthenticationBuilder
    extends AuthenticationBuilder {
        private final String phoneNumber;

        public SMSAuthenticationBuilder(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public Authentication build() {
            Asserts.notNullOrEmpty(this.phoneNumber, "phone number");
            return new Authentication(this.phoneNumber);
        }
    }

    public static class ChallengeBuilder
    extends AuthenticationBuilder {
        private String question;
        private final List<Challenge> challenges = new ArrayList<Challenge>();

        public ChallengeBuilder(String question) {
            this.question = question;
        }

        public static ChallengeBuilder firstQuestion(String question) {
            return new ChallengeBuilder(question);
        }

        public ChallengeBuilder secondQuestion(String question) {
            this.question = question;
            return this;
        }

        public ChallengeBuilder answer(String answer) {
            this.challenges.add(new Challenge(this.question, answer));
            return this;
        }

        @Override
        public Authentication build() {
            if (this.questionProvided() && this.challenges.isEmpty()) {
                throw new IllegalStateException("Question challenge was provided with no answer");
            }
            return new Authentication(this.challenges);
        }

        private boolean questionProvided() {
            return this.question != null && !this.question.trim().isEmpty();
        }
    }

    public static class AuthenticationBuilder {
        public Authentication build() {
            return new Authentication(AuthenticationMethod.EMAIL);
        }
    }
}

