/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.Props;
import com.silanis.esl.sdk.examples.SDKSample;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.joda.time.DateMidnight;

public class AuthenticationMethodsExample
extends SDKSample {
    private String email1;
    private String email2;
    private String email3;
    private String sms3;
    private InputStream documentInputStream;

    public static void main(String ... args) {
        new AuthenticationMethodsExample(Props.get()).run();
    }

    public AuthenticationMethodsExample(Properties props) {
        this(props.getProperty("api.key"), props.getProperty("api.url"), props.getProperty("1.email"), props.getProperty("2.email"), props.getProperty("3.email"), props.getProperty("3.sms"));
    }

    public AuthenticationMethodsExample(String apiKey, String apiUrl, String email1, String email2, String email3, String sms3) {
        super(apiKey, apiUrl);
        this.email1 = email1;
        this.email2 = email2;
        this.email3 = email3;
        this.sms3 = sms3;
        this.documentInputStream = this.getClass().getClassLoader().getResourceAsStream("document.pdf");
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed("Policy " + new SimpleDateFormat("HH:mm:ss").format(new Date())).describedAs("This is a package created using the e-SignLive SDK to demonstrate the authentication methods.").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("Anna").withLastName("Bel")).withSigner(SignerBuilder.newSignerWithEmail(this.email2).withFirstName("Bobby").withLastName("Sue").challengedWithQuestions(SignerBuilder.ChallengeBuilder.firstQuestion("What's 1+1?").answer("2").secondQuestion("What color's the sky?").answer("blue"))).withSigner(SignerBuilder.newSignerWithEmail(this.email3).withFirstName("Charlie").withLastName("Brown").withSmsSentTo(this.sms3)).withDocument(DocumentBuilder.newDocumentWithName("dave.silanis@gmail.com's Document").fromStream(this.documentInputStream, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0)).withSignature(SignatureBuilder.signatureFor(this.email2).onPage(0).atPosition(100.0, 200.0)).withSignature(SignatureBuilder.signatureFor(this.email3).onPage(0).atPosition(100.0, 300.0))).build();
        PackageId packageId = this.eslClient.createPackage(superDuperPackage);
        System.out.println("PackageId: " + packageId);
        this.eslClient.sendPackage(packageId);
    }
}

