/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.Props;
import com.silanis.esl.sdk.examples.SDKSample;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class ConsentExample
extends SDKSample {
    private String email1;
    private String email2;
    private InputStream documentInputStream1;
    private InputStream documentInputStream2;

    public static void main(String ... args) {
        new ConsentExample(Props.get()).run();
    }

    public ConsentExample(Properties props) {
        this(props.getProperty("api.key"), props.getProperty("api.url"), props.getProperty("1.email"), props.getProperty("2.email"));
    }

    public ConsentExample(String apiKey, String apiUrl, String email1, String email2) {
        super(apiKey, apiUrl);
        this.email1 = email1;
        this.email2 = email2;
        this.documentInputStream1 = this.getClass().getClassLoader().getResourceAsStream("document.pdf");
        this.documentInputStream2 = this.getClass().getClassLoader().getResourceAsStream("document.pdf");
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed("Policy " + new SimpleDateFormat("HH:mm:ss").format(new Date())).describedAs("This is a package created using the e-SignLive SDK").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John1").withLastName("Smith1")).withSigner(SignerBuilder.newSignerWithEmail(this.email2).withFirstName("John2").withLastName("Smith2")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.acceptanceFor(this.email1))).withDocument(DocumentBuilder.newDocumentWithName("Second Document").fromStream(this.documentInputStream2, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).build();
        PackageId packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(packageId);
        DocumentPackage documentPackage = this.eslClient.getPackage(packageId);
    }
}

