/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.Props;
import com.silanis.esl.sdk.examples.SDKSample;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class CreatePackageFromInputStreamExample
extends SDKSample {
    private String email1;

    public static void main(String ... args) {
        new CreatePackageFromInputStreamExample(Props.get()).run();
    }

    public CreatePackageFromInputStreamExample(Properties properties) {
        this(properties.getProperty("api.key"), properties.getProperty("api.url"), properties.getProperty("1.email"));
    }

    public CreatePackageFromInputStreamExample(String apiKey, String apiUrl, String email1) {
        super(apiKey, apiUrl);
        this.email1 = email1;
    }

    @Override
    public void execute() {
        InputStream documentStream = CreatePackageFromInputStreamExample.class.getResourceAsStream("/document.pdf");
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed("Policy " + new SimpleDateFormat("HH:mm:ss").format(new Date())).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John").withLastName("Smith")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(documentStream, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).build();
        PackageId packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(packageId);
    }
}

