/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.CustomField;
import com.silanis.esl.sdk.CustomFieldValue;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.builder.CustomFieldBuilder;
import com.silanis.esl.sdk.builder.CustomFieldValueBuilder;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.builder.TranslationBuilder;
import com.silanis.esl.sdk.examples.Props;
import com.silanis.esl.sdk.examples.SDKSample;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;

public class CustomFieldExample
extends SDKSample {
    private String email1;
    private InputStream documentInputStream1;

    public static void main(String ... args) {
        new CustomFieldExample(Props.get()).run();
    }

    public CustomFieldExample(Properties properties) {
        this(properties.getProperty("api.key"), properties.getProperty("api.url"), properties.getProperty("1.email"));
    }

    public CustomFieldExample(String apiKey, String apiUrl, String email1) {
        super(apiKey, apiUrl);
        this.email1 = email1;
        this.documentInputStream1 = this.getClass().getClassLoader().getResourceAsStream("document-with-fields.pdf");
    }

    @Override
    public void execute() {
        String customFieldId = UUID.randomUUID().toString().replaceAll("-", "");
        CustomField customField = this.eslClient.getCustomFieldService().createCustomField(CustomFieldBuilder.customFieldWithId(customFieldId).withDefaultValue("#12345").withTranslation(TranslationBuilder.newTranslation("en").withName("The Bay").withDescription("The Bay store")).withTranslation(TranslationBuilder.newTranslation("fr").withName("La Baie").withDescription("Le magasin La Baie")).build());
        CustomFieldValue customFieldValue = this.eslClient.getCustomFieldService().submitCustomFieldValue(CustomFieldValueBuilder.customFieldValueWithId(customField.getId()).withValue("le woah").build());
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed("Sample Insurance policy").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John").withLastName("Smith")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0).withField(FieldBuilder.customField().onPage(0).atPosition(400.0, 200.0).withName(customFieldValue.getId())))).build();
        PackageId packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(packageId);
    }
}

