/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.Props;
import com.silanis.esl.sdk.examples.SDKSample;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.joda.time.DateMidnight;

public class DeletePackageExample
extends SDKSample {
    private String email1;
    private InputStream documentInputStream;

    public static void main(String ... args) {
        new DeletePackageExample(Props.get()).run();
    }

    public DeletePackageExample(Properties props) {
        this(props.getProperty("api.key"), props.getProperty("api.url"), props.getProperty("1.email"));
    }

    public DeletePackageExample(String apiKey, String apiUrl, String email1) {
        super(apiKey, apiUrl);
        this.email1 = email1;
        this.documentInputStream = this.getClass().getClassLoader().getResourceAsStream("document.pdf");
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed("Policy " + new SimpleDateFormat("HH:mm:ss").format(new Date())).describedAs("This  is a package created using the e-SignLive SDK").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John").withLastName("Smith").withTitle("Managing Director").withCompany("Acme Inc.")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0).withField(FieldBuilder.textField().onPage(0).atPosition(400.0, 100.0).withSize(200.0, 50.0)))).build();
        PackageId packageId = this.eslClient.createPackage(superDuperPackage);
        DocumentPackage unsentPackage = this.eslClient.getPackage(packageId);
        this.eslClient.getPackageService().deletePackage(packageId);
    }
}

