/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.Props;
import com.silanis.esl.sdk.examples.SDKSample;
import java.io.InputStream;
import java.util.Properties;

public class DocumentExtractionExample
extends SDKSample {
    private String email1;
    private InputStream documentInputStream;

    public static void main(String ... args) {
        new DocumentExtractionExample(Props.get()).run();
    }

    public DocumentExtractionExample(Properties properties) {
        this(properties.getProperty("api.key"), properties.getProperty("api.url"), properties.getProperty("1.email"));
    }

    public DocumentExtractionExample(String apiKey, String apiUrl, String email1) {
        super(apiKey, apiUrl);
        this.email1 = email1;
        this.documentInputStream = this.getClass().getClassLoader().getResourceAsStream("document-with-fields.pdf");
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed("Sample Insurance policy").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withRoleId("Signer1").withFirstName("John").withLastName("Smith")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream, DocumentType.PDF).enableExtraction()).build();
        PackageId packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(packageId);
        DocumentPackage sentPackage = this.eslClient.getPackage(packageId);
    }
}

