/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentPackageAttributes;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.SessionToken;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.DocumentPackageAttributesBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.Props;
import com.silanis.esl.sdk.examples.SDKSample;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.joda.time.DateMidnight;

public class DocumentPackageAttributesExample
extends SDKSample {
    private String email1;
    private InputStream documentInputStream1;
    private PackageId packageId;
    private String attributeKey1 = "Key 1";
    private String attributeKey2 = "Key 2";
    private String attributeKey3 = "Key 3";
    private String attribute1 = "Attribute 1";
    private String attribute2 = "Attribute 2";
    private String attribute3 = "Attribute 3";

    public static void main(String ... args) {
        new DocumentPackageAttributesExample(Props.get()).run();
    }

    public DocumentPackageAttributesExample(Properties props) {
        this(props.getProperty("api.key"), props.getProperty("api.url"), props.getProperty("1.email"));
    }

    public DocumentPackageAttributesExample(String apiKey, String apiUrl, String email1) {
        super(apiKey, apiUrl);
        this.email1 = email1;
        this.documentInputStream1 = this.getClass().getClassLoader().getResourceAsStream("document.pdf");
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed("Policy " + new SimpleDateFormat("HH:mm:ss").format(new Date())).describedAs("This is a package created using the e-SignLive SDK").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withCustomId("Client1").withFirstName("John").withLastName("Smith").withTitle("Managing Director").withCompany("Acme Inc.")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).withField(FieldBuilder.checkBox().onPage(0).atPosition(400.0, 200.0).withValue("x")).atPosition(100.0, 100.0))).withAttributes(DocumentPackageAttributesBuilder.newDocumentPackageAttributes().withAttribute(this.attributeKey1, this.attribute1).withAttribute(this.attributeKey2, this.attribute2).withAttribute(this.attributeKey3, this.attribute3).build()).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(this.packageId);
        SessionToken sessionToken = this.eslClient.getSessionService().createSessionToken(this.packageId.toString(), "Client1");
    }

    @Override
    void postExecute() {
        DocumentPackage documentPackage = this.eslClient.getPackage(this.packageId);
        DocumentPackageAttributes documentPackageAttributes = documentPackage.getAttributes();
        Map<String, Object> attributeMap = documentPackageAttributes.getContents();
        assert (attributeMap.containsKey(this.attributeKey1));
        assert (attributeMap.containsKey(this.attributeKey2));
        assert (attributeMap.containsKey(this.attributeKey3));
        assert (attributeMap.get(this.attributeKey1).toString().equals(this.attribute1));
        assert (attributeMap.get(this.attributeKey2).toString().equals(this.attribute2));
        assert (attributeMap.get(this.attributeKey3).toString().equals(this.attribute3));
    }
}

