/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.builder.CeremonyLayoutSettingsBuilder;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.DocumentPackageSettingsBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.Props;
import com.silanis.esl.sdk.examples.SDKSample;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class DocumentPackageSettingsExample
extends SDKSample {
    private String email1;
    private InputStream documentInputStream;

    public static void main(String ... args) {
        new DocumentPackageSettingsExample(Props.get()).run();
    }

    public DocumentPackageSettingsExample(Properties properties) {
        this(properties.getProperty("api.key"), properties.getProperty("api.url"), properties.getProperty("1.email"));
    }

    public DocumentPackageSettingsExample(String apiKey, String apiUrl, String email1) {
        super(apiKey, apiUrl);
        this.email1 = email1;
        this.documentInputStream = this.getClass().getClassLoader().getResourceAsStream("document.pdf");
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed("DocumentPackageSettingsExample " + new SimpleDateFormat("HH:mm:ss").format(new Date())).withSettings(DocumentPackageSettingsBuilder.newDocumentPackageSettings().withInPerson().withoutDecline().withOptOut().withOptOutReason("Reason One").withOptOutReason("Reason Two").withOptOutReason("Reason Three").withHandOverLinkHref("http://www.google.ca").withHandOverLinkText("click here").withHandOverLinkTooltip("link tooltip").withDialogOnComplete().withCeremonyLayoutSettings(CeremonyLayoutSettingsBuilder.newCeremonyLayoutSettings().withoutGlobalDownloadButton().withoutGlobalConfirmButton().withoutGlobalSaveAsLayoutButton())).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John").withLastName("Smith")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).build();
        PackageId packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(packageId);
    }
}

