/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.SessionToken;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.Props;
import com.silanis.esl.sdk.examples.SDKSample;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.joda.time.DateMidnight;

public class DocumentUploadExample
extends SDKSample {
    private String email1;
    private InputStream documentInputStream1;

    public static void main(String ... args) {
        new DocumentUploadExample(Props.get()).run();
    }

    public DocumentUploadExample(Properties props) {
        this(props.getProperty("api.key"), props.getProperty("api.url"), props.getProperty("1.email"));
    }

    public DocumentUploadExample(String apiKey, String apiUrl, String email1) {
        super(apiKey, apiUrl);
        this.email1 = email1;
        this.documentInputStream1 = this.getClass().getClassLoader().getResourceAsStream("document.pdf");
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed("Policy " + new SimpleDateFormat("HH:mm:ss").format(new Date())).describedAs("This is a package created using the e-SignLive SDK").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withCustomId("Client1").withFirstName("John").withLastName("Smith").withTitle("Managing Director").withCompany("Acme Inc.")).build();
        superDuperPackage.setId(this.eslClient.createPackage(superDuperPackage));
        Document document = DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).withField(FieldBuilder.checkBox().onPage(0).atPosition(400.0, 200.0).withValue("x")).atPosition(100.0, 100.0)).build();
        this.eslClient.uploadDocument(document.getFileName(), document.getContent(), document, superDuperPackage);
        this.eslClient.sendPackage(superDuperPackage.getId());
        SessionToken sessionToken = this.eslClient.getSessionService().createSessionToken(superDuperPackage.getId().toString(), "Client1");
    }
}

