/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.FieldId;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.Props;
import com.silanis.esl.sdk.examples.SDKSample;
import java.io.InputStream;
import java.util.Properties;

public class FieldInjectionExample
extends SDKSample {
    private String email1;
    private InputStream documentInputStream1;

    public static void main(String ... args) {
        new FieldInjectionExample(Props.get()).run();
    }

    public FieldInjectionExample(Properties properties) {
        this(properties.getProperty("api.key"), properties.getProperty("api.url"), properties.getProperty("1.email"));
    }

    public FieldInjectionExample(String apiKey, String apiUrl, String email1) {
        super(apiKey, apiUrl);
        this.email1 = email1;
        this.documentInputStream1 = this.getClass().getClassLoader().getResourceAsStream("document-with-fields.pdf");
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed("Sample Insurance policy").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John").withLastName("Smith")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0)).withInjectedField(FieldBuilder.textField().withId(new FieldId("AGENT_SIG_1")).withName("AGENT_SIG_1").withValue("Test Value"))).build();
        PackageId packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(packageId);
    }
}

