/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.Group;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.GroupMember;
import com.silanis.esl.sdk.GroupMemberType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.builder.AccountMemberBuilder;
import com.silanis.esl.sdk.builder.AddressBuilder;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.GroupBuilder;
import com.silanis.esl.sdk.builder.GroupMemberBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.Props;
import com.silanis.esl.sdk.examples.SDKSample;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.UUID;

public class GroupManagementExample
extends SDKSample {
    private String email1;
    private String email2;
    private String email3;
    private String email4;
    private InputStream documentInputStream1;

    public static void main(String ... args) {
        new GroupManagementExample(Props.get()).run();
    }

    public GroupManagementExample(Properties props) {
        this(props.getProperty("api.key"), props.getProperty("api.url"), props.getProperty("1.email"), props.getProperty("2.email"), props.getProperty("3.email"), props.getProperty("4.email"));
    }

    public GroupManagementExample(String apiKey, String apiUrl, String email1, String email2, String email3, String email4) {
        super(apiKey, apiUrl);
        this.email1 = email1;
        this.email2 = email2;
        this.email3 = email3;
        this.email4 = email4;
        this.documentInputStream1 = this.getClass().getClassLoader().getResourceAsStream("document.pdf");
    }

    private void displayAccountGroupsAndMembers() {
        List<Group> allGroups = this.eslClient.getGroupService().getMyGroups();
        for (Group group : allGroups) {
            System.out.println(group.getName() + " with email " + group.getEmail() + " and id " + group.getId());
            List<GroupMember> allMembers = this.eslClient.getGroupService().getGroupMembers(group.getId());
            for (GroupMember member : allMembers) {
                System.out.println(member.getGroupMemberType().toString() + " " + member.getFirstName() + " " + member.getLastName() + " with email " + member.getEmail());
            }
        }
    }

    private void inviteAccountMember(String email) {
        try {
            this.eslClient.getAccountService().inviteUser(AccountMemberBuilder.newAccountMember(email).withPhoneNumber("1234567890").withLanguage("en").withTitle("title").withCompany("company").withFirstName("firstName").withLastName("lastName").withAddress(AddressBuilder.newAddress().withAddress1("address1").withAddress2("address2").withZipCode("zipcode").withState("state").withCountry("country").withCity("city")).build());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void execute() {
        this.inviteAccountMember(this.email1);
        this.inviteAccountMember(this.email2);
        this.inviteAccountMember(this.email3);
        this.inviteAccountMember(this.email4);
        Group group1 = GroupBuilder.newGroup(UUID.randomUUID().toString()).withId(new GroupId(UUID.randomUUID().toString())).withMember(GroupMemberBuilder.newGroupMember(this.email1).as(GroupMemberType.MANAGER)).withEmail("bob@aol.com").withIndividualMemberEmailing().build();
        Group createdGroup1 = this.eslClient.getGroupService().createGroup(group1);
        System.out.println("GroupId: " + createdGroup1.getId().toString());
        this.eslClient.getGroupService().inviteMember(createdGroup1.getId(), GroupMemberBuilder.newGroupMember(this.email3).as(GroupMemberType.MANAGER).build());
        this.eslClient.getGroupService().inviteMember(createdGroup1.getId(), GroupMemberBuilder.newGroupMember(this.email4).as(GroupMemberType.MANAGER).build());
        Group retrievedGroup1 = this.eslClient.getGroupService().getGroup(createdGroup1.getId());
        Group group2 = GroupBuilder.newGroup(UUID.randomUUID().toString()).withMember(GroupMemberBuilder.newGroupMember(this.email2).as(GroupMemberType.MANAGER)).withEmail("bob@aol.com").withIndividualMemberEmailing().build();
        Group createdGroup2 = this.eslClient.getGroupService().createGroup(group2);
        Group retrievedGroup2 = this.eslClient.getGroupService().getGroup(createdGroup2.getId());
        List<Group> allGroupsBeforeDelete = this.eslClient.getGroupService().getMyGroups();
        List<GroupMember> groupMembersBeforeDelete = this.eslClient.getGroupService().getGroupMembers(createdGroup1.getId());
        List<String> groupMemberEmailsBeforeDelete = this.eslClient.getGroupService().getGroupMemberEmails(createdGroup1.getId());
        this.eslClient.getGroupService().deleteGroup(createdGroup2.getId());
        List<Group> allGroupsAfterDelete = this.eslClient.getGroupService().getMyGroups();
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed("GroupManagementExample " + new SimpleDateFormat("HH:mm:ss").format(new Date())).withSigner(SignerBuilder.newSignerFromGroup(createdGroup1.getId()).canChangeSigner().deliverSignedDocumentsByEmail()).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.captureFor(createdGroup1.getId()).onPage(0).atPosition(100.0, 100.0))).build();
        PackageId packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(packageId);
        this.eslClient.getPackageService().notifySigner(packageId, createdGroup1.getId());
        DocumentPackage result = this.eslClient.getPackage(packageId);
    }
}

