/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal;

import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.internal.CommunicationException;
import com.silanis.esl.sdk.internal.MimeTypeUtils;
import com.silanis.esl.sdk.internal.Support;
import com.silanis.esl.sdk.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;

public class RestClient {
    private final ResponseHandler<byte[]> bytesHandler = new BytesHandler();
    private final ResponseHandler<String> jsonHandler = new JsonHandler();
    private final String apiToken;
    private final Support support = new Support();

    public RestClient(String apiToken) {
        this.apiToken = apiToken;
    }

    public String post(String path, String jsonPayload) throws IOException, HttpException, URISyntaxException {
        this.support.logRequest("POST", path, jsonPayload);
        HttpPost post = new HttpPost(path);
        if (jsonPayload != null) {
            StringEntity body = new StringEntity(jsonPayload);
            body.setContentType("application/json");
            post.setEntity((HttpEntity)body);
        }
        return RestClient.execute((HttpUriRequest)post, this.apiToken, this.jsonHandler);
    }

    public String put(String path, String jsonPayload) throws IOException {
        this.support.logRequest("PUT", path, jsonPayload);
        HttpPut put = new HttpPut(path);
        StringEntity body = new StringEntity(jsonPayload);
        body.setContentType("application/json");
        put.setEntity((HttpEntity)body);
        return RestClient.execute((HttpUriRequest)put, this.apiToken, this.jsonHandler);
    }

    public void postMultipartFile(String path, String fileName, byte[] fileBytes, String jsonPayload) throws IOException, HttpException, URISyntaxException {
        this.support.logRequest("POST", path, jsonPayload);
        MultipartEntity multipart = new MultipartEntity();
        String contentType = MimeTypeUtils.getContentTypeByFileName(fileName);
        multipart.addPart("payload", (ContentBody)new StringBody(jsonPayload));
        multipart.addPart("file", (ContentBody)new ByteArrayBody(fileBytes, contentType, fileName));
        HttpPost post = new HttpPost(path);
        post.setEntity((HttpEntity)multipart);
        RestClient.execute((HttpUriRequest)post, this.apiToken, this.jsonHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T execute(HttpUriRequest request, String apiToken, ResponseHandler<T> handler) throws IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        request.setHeader("Authorization", "Basic " + apiToken);
        try {
            HttpResponse response = client.execute(request);
            if (response.getStatusLine().getStatusCode() >= 400) {
                throw new CommunicationException(request.getRequestLine().getMethod(), request.getRequestLine().getUri(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
            }
            InputStream bodyContent = response.getEntity().getContent();
            T t = handler.extract(bodyContent);
            return t;
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    public String get(String path) throws IOException, HttpException, URISyntaxException {
        this.support.logRequest("GET", path);
        HttpGet get = new HttpGet(path);
        return RestClient.execute((HttpUriRequest)get, this.apiToken, this.jsonHandler);
    }

    public byte[] getBytes(String path) throws IOException, HttpException, URISyntaxException {
        this.support.logRequest("GET", path);
        HttpGet get = new HttpGet(path);
        return RestClient.execute((HttpUriRequest)get, this.apiToken, this.bytesHandler);
    }

    public String delete(String path) throws HttpException, IOException, URISyntaxException {
        this.support.logRequest("DELETE", path);
        HttpDelete delete = new HttpDelete(path);
        return RestClient.execute((HttpUriRequest)delete, this.apiToken, this.jsonHandler);
    }

    private class JsonHandler
    implements ResponseHandler<String> {
        private JsonHandler() {
        }

        @Override
        public String extract(InputStream input) {
            try {
                String responseBody = Streams.toString(input);
                RestClient.this.support.logResponse(responseBody);
                return responseBody;
            }
            catch (UnsupportedEncodingException e) {
                throw new EslException("", e);
            }
        }
    }

    private class BytesHandler
    implements ResponseHandler<byte[]> {
        private BytesHandler() {
        }

        @Override
        public byte[] extract(InputStream input) {
            return Streams.toByteArray(input);
        }
    }

    private static interface ResponseHandler<T> {
        public T extract(InputStream var1);
    }
}

