/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.User;
import com.silanis.esl.sdk.AccountMember;
import com.silanis.esl.sdk.internal.converter.AddressConverter;

public class AccountMemberConverter {
    private User apiUser = null;
    private AccountMember sdkAccountMember = null;

    public AccountMemberConverter(User apiUser) {
        this.apiUser = apiUser;
    }

    public AccountMemberConverter(AccountMember sdkAccountMember) {
        this.sdkAccountMember = sdkAccountMember;
    }

    public User toAPIUser() {
        if (this.sdkAccountMember != null) {
            User result = new User();
            result.setAddress(new AddressConverter(this.sdkAccountMember.getAddress()).toAPIAddress());
            result.setCompany(this.sdkAccountMember.getCompany());
            result.setEmail(this.sdkAccountMember.getEmail());
            result.setFirstName(this.sdkAccountMember.getFirstName());
            result.setLastName(this.sdkAccountMember.getLastName());
            result.setTitle(this.sdkAccountMember.getTitle());
            result.setLanguage(this.sdkAccountMember.getLanguage());
            result.setPhone(this.sdkAccountMember.getPhoneNumber());
            return result;
        }
        return this.apiUser;
    }

    public AccountMember toSDKAccountMember() {
        if (this.apiUser != null) {
            AccountMember result = new AccountMember();
            result.setAddress(new AddressConverter(this.apiUser.getAddress()).toSDKAddress());
            result.setCompany(this.apiUser.getCompany());
            result.setEmail(this.apiUser.getEmail());
            result.setFirstName(this.apiUser.getFirstName());
            result.setLastName(this.apiUser.getLastName());
            result.setTitle(this.apiUser.getTitle());
            result.setLanguage(this.apiUser.getLanguage());
            result.setPhoneNumber(this.apiUser.getPhone());
            return result;
        }
        return this.sdkAccountMember;
    }
}

