/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.Auth;
import com.silanis.esl.api.model.AuthChallenge;
import com.silanis.esl.api.model.AuthScheme;
import com.silanis.esl.sdk.Authentication;
import com.silanis.esl.sdk.Challenge;
import com.silanis.esl.sdk.internal.converter.ChallengeConverter;
import java.util.ArrayList;

public class AuthenticationConverter {
    Auth apiAuth;
    Authentication sdkAuth;

    public AuthenticationConverter(Auth apiAuth) {
        this.apiAuth = apiAuth;
    }

    public AuthenticationConverter(Authentication sdkAuth) {
        this.sdkAuth = sdkAuth;
    }

    public Auth toAPIAuthentication() {
        if (this.sdkAuth == null) {
            return this.apiAuth;
        }
        Auth auth = new Auth().setScheme(this.scheme());
        for (Challenge challenge : this.sdkAuth.getChallenges()) {
            auth.addChallenge(new AuthChallenge().setQuestion(challenge.getQuestion()).setAnswer(challenge.getAnswer()));
        }
        if (this.sdkAuth.getPhoneNumber() != null) {
            auth.addChallenge(new AuthChallenge().setQuestion(this.sdkAuth.getPhoneNumber()));
        }
        return auth;
    }

    public Authentication toSDKAuthentication() {
        if (this.apiAuth == null) {
            return this.sdkAuth;
        }
        Authentication sdkAuthentication = null;
        if (!this.apiAuth.getChallenges().isEmpty()) {
            ArrayList<Challenge> sdkChallenges = new ArrayList<Challenge>();
            for (AuthChallenge apiChallenge : this.apiAuth.getChallenges()) {
                sdkChallenges.add(new ChallengeConverter(apiChallenge).toSDKChallenge());
            }
            sdkAuthentication = new Authentication(sdkChallenges);
        }
        return sdkAuthentication;
    }

    private AuthScheme scheme() {
        switch (this.sdkAuth.getMethod()) {
            case EMAIL: {
                return AuthScheme.NONE;
            }
            case CHALLENGE: {
                return AuthScheme.CHALLENGE;
            }
            case SMS: {
                return AuthScheme.SMS;
            }
        }
        throw new IllegalStateException("Unknown authentication method");
    }
}

