/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.BrandingBarOptions;
import com.silanis.esl.api.model.FooterOptions;
import com.silanis.esl.api.model.GlobalActionsOptions;
import com.silanis.esl.api.model.HeaderOptions;
import com.silanis.esl.api.model.Image;
import com.silanis.esl.api.model.LayoutOptions;
import com.silanis.esl.api.model.TitleBarOptions;
import com.silanis.esl.sdk.CeremonyLayoutSettings;

public class CeremonyLayoutSettingsConverter {
    private CeremonyLayoutSettings sdkCeremonyLayoutSettings = null;
    private LayoutOptions apiLayoutOptions = null;

    public CeremonyLayoutSettingsConverter(CeremonyLayoutSettings sdkCeremonyLayoutSettings) {
        this.sdkCeremonyLayoutSettings = sdkCeremonyLayoutSettings;
    }

    public CeremonyLayoutSettingsConverter(LayoutOptions apiLayoutOptions) {
        this.apiLayoutOptions = apiLayoutOptions;
    }

    public LayoutOptions toAPILayoutOptions() {
        if (this.sdkCeremonyLayoutSettings == null) {
            return this.apiLayoutOptions;
        }
        TitleBarOptions titleBarOptions = new TitleBarOptions();
        titleBarOptions.safeSetTitle(this.sdkCeremonyLayoutSettings.getShowTitle());
        titleBarOptions.safeSetProgressBar(this.sdkCeremonyLayoutSettings.getProgressBar());
        HeaderOptions headerOptions = new HeaderOptions();
        headerOptions.safeSetBreadcrumbs(this.sdkCeremonyLayoutSettings.getBreadCrumbs());
        headerOptions.safeSetSessionBar(this.sdkCeremonyLayoutSettings.getSessionBar());
        headerOptions.safeSetGlobalNavigation(this.sdkCeremonyLayoutSettings.getGlobalNavigation());
        headerOptions.safeSetTitleBar(titleBarOptions);
        GlobalActionsOptions globalActionsOptions = new GlobalActionsOptions();
        globalActionsOptions.safeSetConfirm(this.sdkCeremonyLayoutSettings.getShowGlobalConfirmButton());
        globalActionsOptions.safeSetDownload(this.sdkCeremonyLayoutSettings.getShowGlobalDownloadButton());
        globalActionsOptions.safeSetSaveAsLayout(this.sdkCeremonyLayoutSettings.getShowGlobalSaveAsLayoutButton());
        headerOptions.setGlobalActions(globalActionsOptions);
        BrandingBarOptions brandingBarOptions = null;
        if (this.sdkCeremonyLayoutSettings.getLogoImageLink() != null || this.sdkCeremonyLayoutSettings.getLogoImageSource() != null) {
            brandingBarOptions = new BrandingBarOptions();
            Image logo = new Image();
            logo.safeSetLink(this.sdkCeremonyLayoutSettings.getLogoImageLink());
            logo.safeSetSrc(this.sdkCeremonyLayoutSettings.getLogoImageSource());
            brandingBarOptions.safeSetLogo(logo);
        }
        LayoutOptions result = new LayoutOptions();
        result.safeSetIframe(this.sdkCeremonyLayoutSettings.getiFrame());
        result.safeSetNavigator(this.sdkCeremonyLayoutSettings.getNavigator());
        result.safeSetFooter(new FooterOptions());
        result.safeSetHeader(headerOptions);
        result.safeSetBrandingBar(brandingBarOptions);
        return result;
    }
}

