/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.sdk.CustomField;
import com.silanis.esl.sdk.Translation;
import com.silanis.esl.sdk.builder.CustomFieldBuilder;
import com.silanis.esl.sdk.builder.TranslationBuilder;

public class CustomFieldConverter {
    private CustomField sdkCustomField = null;
    private com.silanis.esl.api.model.CustomField apiCustomField = null;

    public CustomFieldConverter(CustomField sdkCustomField) {
        this.sdkCustomField = sdkCustomField;
    }

    public CustomFieldConverter(com.silanis.esl.api.model.CustomField apiCustomField) {
        this.apiCustomField = apiCustomField;
    }

    public com.silanis.esl.api.model.CustomField toAPICustomField() {
        if (this.sdkCustomField == null) {
            return this.apiCustomField;
        }
        com.silanis.esl.api.model.CustomField result = new com.silanis.esl.api.model.CustomField();
        result.setId(this.sdkCustomField.getId());
        result.setValue(this.sdkCustomField.getValue());
        result.setRequired(this.sdkCustomField.getRequired());
        for (Translation translation : this.sdkCustomField.getTranslations()) {
            result.addTranslation(translation.toAPITranslation());
        }
        return result;
    }

    public CustomField toSDKCustomField() {
        if (this.apiCustomField == null) {
            return this.sdkCustomField;
        }
        CustomFieldBuilder result = new CustomFieldBuilder();
        result.withId(this.apiCustomField.getId()).withDefaultValue(this.apiCustomField.getValue());
        for (com.silanis.esl.api.model.Translation tran : this.apiCustomField.getTranslations()) {
            result.withTranslation(TranslationBuilder.newTranslation(tran));
        }
        return result.build();
    }
}

