/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.Approval;
import com.silanis.esl.api.model.Package;
import com.silanis.esl.api.model.Role;
import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.Field;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.Signature;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.internal.converter.ConversionService;
import com.silanis.esl.sdk.internal.converter.FieldConverter;
import com.silanis.esl.sdk.internal.converter.SignatureConverter;

public class DocumentConverter {
    private com.silanis.esl.api.model.Document apiDocument = null;
    private Package apiPackage = null;
    private Document sdkDocument = null;

    public DocumentConverter(com.silanis.esl.api.model.Document apiDocument, Package apiPackage) {
        this.apiDocument = apiDocument;
        this.apiPackage = apiPackage;
    }

    public DocumentConverter(Document sdkDocument) {
        this.sdkDocument = sdkDocument;
    }

    public Document toSDKDocument() {
        if (this.apiDocument == null) {
            return this.sdkDocument;
        }
        DocumentBuilder documentBuilder = DocumentBuilder.newDocumentWithName(this.apiDocument.getName());
        documentBuilder.withId(this.apiDocument.getId());
        documentBuilder.atIndex(this.apiDocument.getIndex());
        documentBuilder.withDescription(this.apiDocument.getDescription());
        for (Approval apiApproval : this.apiDocument.getApprovals()) {
            documentBuilder.withSignature(new SignatureConverter(apiApproval, this.apiPackage).toSDKSignature());
        }
        for (com.silanis.esl.api.model.Field apiField : this.apiDocument.getFields()) {
            documentBuilder.withInjectedField(new FieldConverter(apiField).toSDKField());
        }
        return documentBuilder.build();
    }

    public com.silanis.esl.api.model.Document toAPIDocument(Package createdPackage) {
        if (this.sdkDocument == null) {
            return this.apiDocument;
        }
        com.silanis.esl.api.model.Document resultAPIDocument = new com.silanis.esl.api.model.Document().setIndex(this.sdkDocument.getIndex()).setExtract(this.sdkDocument.isExtract()).setName(this.sdkDocument.getName());
        if (this.sdkDocument.getId() != null) {
            resultAPIDocument.setId(this.sdkDocument.getId().getId());
        }
        if (this.sdkDocument.getDescription() != null) {
            resultAPIDocument.setDescription(this.sdkDocument.getDescription());
        }
        for (Signature signature : this.sdkDocument.getSignatures()) {
            Approval approval = new SignatureConverter(signature).toAPIApproval();
            if (signature.isGroupSignature()) {
                approval.setRole(this.findRoleIdForGroup(signature.getGroupId(), createdPackage));
            } else {
                approval.setRole(this.findRoleIdForSignature(signature.getSignerEmail(), createdPackage));
            }
            resultAPIDocument.addApproval(approval);
        }
        for (Field field : this.sdkDocument.getInjectedFields()) {
            resultAPIDocument.addField(ConversionService.convert(field));
        }
        return resultAPIDocument;
    }

    private String findRoleIdForGroup(GroupId groupId, Package createdPackage) {
        for (Role role : createdPackage.getRoles()) {
            if (role.getSigners().isEmpty() || role.getSigners().get(0).getGroup() == null || !role.getSigners().get(0).getGroup().getId().equals(groupId.getId())) continue;
            return role.getId();
        }
        throw new IllegalStateException("No role found for signer group " + groupId.getId());
    }

    private String findRoleIdForSignature(String signerEmail, Package createdPackage) {
        for (Role role : createdPackage.getRoles()) {
            if (role.getSigners().isEmpty() || role.getSigners().get(0).getEmail() == null || !signerEmail.equals(role.getSigners().get(0).getEmail())) continue;
            return role.getId();
        }
        throw new IllegalStateException("No role found for signer email " + signerEmail);
    }
}

