/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.BaseMessage;
import com.silanis.esl.api.model.Package;
import com.silanis.esl.api.model.Role;
import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.builder.DocumentPackageAttributesBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.internal.converter.DocumentConverter;
import com.silanis.esl.sdk.internal.converter.DocumentPackageSettingsConverter;
import com.silanis.esl.sdk.internal.converter.SenderConverter;
import com.silanis.esl.sdk.internal.converter.SignerConverter;
import java.util.Locale;
import java.util.Map;

public class DocumentPackageConverter {
    private Package apiPackage;
    private DocumentPackage sdkPackage;

    public DocumentPackageConverter(Package apiPackage) {
        this.apiPackage = apiPackage;
    }

    public DocumentPackageConverter(DocumentPackage sdkPackage) {
        this.sdkPackage = sdkPackage;
    }

    public Package toAPIPackage() {
        if (this.sdkPackage == null) {
            return this.apiPackage;
        }
        Package apiPackageToCreate = new Package().setName(this.sdkPackage.getName()).setDue(this.sdkPackage.getExpiryDate()).setEmailMessage(this.sdkPackage.getPackageMessage()).setDescription(this.sdkPackage.getDescription()).setAutocomplete(this.sdkPackage.getAutocomplete());
        if (this.sdkPackage.getAttributes() != null) {
            apiPackageToCreate.setData((Map)this.sdkPackage.getAttributes().toMap());
        }
        if (this.sdkPackage.getLanguage() != null) {
            apiPackageToCreate.setLanguage(this.sdkPackage.getLanguage().getLanguage());
        }
        if (this.sdkPackage.getSettings() != null) {
            apiPackageToCreate.setSettings(new DocumentPackageSettingsConverter(this.sdkPackage.getSettings()).toAPIPackageSettings());
        }
        if (this.sdkPackage.getSenderInfo() != null) {
            apiPackageToCreate.setSender(new SenderConverter(this.sdkPackage.getSenderInfo()).toAPISender());
        }
        int signerCount = 1;
        for (Signer signer : this.sdkPackage.getSigners().values()) {
            Role role = new Role().setName(signer.getId() == null ? "signer" + signerCount : signer.getId()).addSigner(new SignerConverter(signer).toAPISigner()).setIndex(signer.getSigningOrder()).setReassign(signer.canChangeSigner()).setId(signer.getId() == null ? "role" + signerCount : signer.getId());
            ++signerCount;
            if (signer.getMessage() != null) {
                role.setEmailMessage(new BaseMessage().setContent(signer.getMessage()));
            }
            apiPackageToCreate.addRole(role);
        }
        return apiPackageToCreate;
    }

    public DocumentPackage toSDKPackage() {
        if (this.apiPackage == null) {
            return this.sdkPackage;
        }
        PackageBuilder packageBuilder = PackageBuilder.newPackageNamed(this.apiPackage.getName());
        packageBuilder.withID(new PackageId(this.apiPackage.getId()));
        packageBuilder.autocomplete(this.apiPackage.evalAutocomplete());
        packageBuilder.describedAs(this.apiPackage.getDescription());
        packageBuilder.expiresAt(this.apiPackage.getDue());
        packageBuilder.withStatus(this.apiPackage.getStatus());
        packageBuilder.withEmailMessage(this.apiPackage.getEmailMessage());
        if (this.apiPackage.getLanguage() != null) {
            packageBuilder.withLanguage(new Locale(this.apiPackage.getLanguage()));
        }
        if (this.apiPackage.getSettings() != null) {
            packageBuilder.withSettings(new DocumentPackageSettingsConverter(this.apiPackage.getSettings()).toSDKPackageSettings());
        }
        if (this.apiPackage.getSender() != null) {
            packageBuilder.withSenderInfo(new SenderConverter(this.apiPackage.getSender()).toSDKSender());
        }
        packageBuilder.withAttributes(new DocumentPackageAttributesBuilder(this.apiPackage.getData()).build());
        for (Role role : this.apiPackage.getRoles()) {
            if (role.getSigners().isEmpty()) continue;
            if (role.getSigners().get(0).getGroup() != null) {
                packageBuilder.withSigner(SignerBuilder.newSignerFromGroup(new GroupId(role.getSigners().get(0).getGroup().getId())));
                continue;
            }
            packageBuilder.withSigner(new SignerConverter(role).toSDKSigner());
        }
        for (com.silanis.esl.api.model.Document apiDocument : this.apiPackage.getDocuments()) {
            Document document = new DocumentConverter(apiDocument, this.apiPackage).toSDKDocument();
            packageBuilder.withDocument(document);
        }
        return packageBuilder.build();
    }
}

