/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.CeremonyEventComplete;
import com.silanis.esl.api.model.CeremonyEvents;
import com.silanis.esl.api.model.CeremonySettings;
import com.silanis.esl.api.model.DocumentToolbarOptions;
import com.silanis.esl.api.model.Link;
import com.silanis.esl.api.model.PackageSettings;
import com.silanis.esl.sdk.DocumentPackageSettings;
import com.silanis.esl.sdk.builder.CeremonyLayoutSettingsBuilder;
import com.silanis.esl.sdk.internal.converter.CeremonyLayoutSettingsConverter;

public class DocumentPackageSettingsConverter {
    private DocumentPackageSettings sdkPackageSettings = null;
    private PackageSettings apiPackageSettings = null;

    public DocumentPackageSettingsConverter(PackageSettings apiPackageSettings) {
        this.apiPackageSettings = apiPackageSettings;
    }

    public DocumentPackageSettingsConverter(DocumentPackageSettings sdkPackageSettings) {
        this.sdkPackageSettings = sdkPackageSettings;
    }

    public PackageSettings toAPIPackageSettings() {
        if (this.sdkPackageSettings == null) {
            return this.apiPackageSettings;
        }
        CeremonySettings ceremonySettings = new CeremonySettings();
        ceremonySettings.safeSetInPerson(this.sdkPackageSettings.getEnableInPerson());
        ceremonySettings.safeSetOptOutButton(this.sdkPackageSettings.getEnableOptOut());
        ceremonySettings.safeSetDeclineButton(this.sdkPackageSettings.getEnableDecline());
        ceremonySettings.safeSetHideWatermark(this.sdkPackageSettings.getHideWatermark());
        ceremonySettings.safeSetHideCaptureText(this.sdkPackageSettings.getHideCaptureText());
        ceremonySettings.safeSetOptOutReasons(this.sdkPackageSettings.getOptOutReasons());
        ceremonySettings.safeSetMaxAuthFailsAllowed(this.sdkPackageSettings.getMaxAuthAttempts());
        if (this.sdkPackageSettings.getLinkHref() != null) {
            Link link = new Link();
            link.setHref(this.sdkPackageSettings.getLinkHref());
            link.setText(this.sdkPackageSettings.getLinkText() == null ? this.sdkPackageSettings.getLinkHref() : this.sdkPackageSettings.getLinkText());
            link.setTitle(this.sdkPackageSettings.getLinkTooltip() == null ? this.sdkPackageSettings.getLinkHref() : this.sdkPackageSettings.getLinkTooltip());
            ceremonySettings.setHandOver(link);
        }
        if (this.sdkPackageSettings.getShowDialogOnComplete() != null) {
            CeremonyEvents ceremonyEvents = new CeremonyEvents();
            CeremonyEventComplete ceremonyEventComplete = new CeremonyEventComplete();
            ceremonyEventComplete.setDialog(this.sdkPackageSettings.getShowDialogOnComplete());
            ceremonyEvents.setComplete(ceremonyEventComplete);
            ceremonySettings.setEvents(ceremonyEvents);
        }
        if (this.sdkPackageSettings.getShowDocumentToolbarDownloadButton() != null) {
            DocumentToolbarOptions documentToolbarOptions = new DocumentToolbarOptions();
            documentToolbarOptions.setDownloadButton(this.sdkPackageSettings.getShowDocumentToolbarDownloadButton());
            ceremonySettings.setDocumentToolbarOptions(documentToolbarOptions);
        }
        if (this.sdkPackageSettings.getCeremonyLayoutSettings() != null) {
            ceremonySettings.setLayout(new CeremonyLayoutSettingsConverter(this.sdkPackageSettings.getCeremonyLayoutSettings()).toAPILayoutOptions());
        }
        PackageSettings result = new PackageSettings();
        result.setCeremony(ceremonySettings);
        return result;
    }

    public DocumentPackageSettings toSDKPackageSettings() {
        if (this.apiPackageSettings == null) {
            return this.sdkPackageSettings;
        }
        DocumentPackageSettings result = new DocumentPackageSettings();
        result.setEnableInPerson(this.apiPackageSettings.getCeremony().getInPerson());
        result.setEnableOptOut(this.apiPackageSettings.getCeremony().getOptOutButton());
        result.setEnableDecline(this.apiPackageSettings.getCeremony().getDeclineButton());
        result.setHideWatermark(this.apiPackageSettings.getCeremony().getHideWatermark());
        result.setHideCaptureText(this.apiPackageSettings.getCeremony().getHideCaptureText());
        result.getOptOutReasons().addAll(this.apiPackageSettings.getCeremony().getOptOutReasons());
        result.setMaxAuthAttempts(this.apiPackageSettings.getCeremony().getMaxAuthFailsAllowed());
        if (this.apiPackageSettings.getCeremony().getDocumentToolbarOptions() != null) {
            result.setShowDocumentToolbarDownloadButton(this.apiPackageSettings.getCeremony().getDocumentToolbarOptions().getDownloadButton());
        }
        if (this.apiPackageSettings.getCeremony().getEvents() != null && this.apiPackageSettings.getCeremony().getEvents().getComplete() != null) {
            result.setShowDialogOnComplete(this.apiPackageSettings.getCeremony().getEvents().getComplete().getDialog());
        }
        if (this.apiPackageSettings.getCeremony().getHandOver() != null) {
            result.setLinkText(this.apiPackageSettings.getCeremony().getHandOver().getText());
            result.setLinkTooltip(this.apiPackageSettings.getCeremony().getHandOver().getTitle());
            result.setLinkHref(this.apiPackageSettings.getCeremony().getHandOver().getHref());
        }
        result.setCeremonyLayoutSettings(new CeremonyLayoutSettingsBuilder(this.apiPackageSettings.getCeremony()).build());
        return result;
    }
}

