/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.FieldType;
import com.silanis.esl.sdk.Field;
import com.silanis.esl.sdk.FieldId;
import com.silanis.esl.sdk.internal.converter.FieldStyleAndSubTypeConverter;
import com.silanis.esl.sdk.internal.converter.FieldValidatorConverter;
import com.silanis.esl.sdk.internal.converter.TextAnchorConverter;

public class FieldConverter {
    private Field sdkField = null;
    private com.silanis.esl.api.model.Field apiField = null;

    public FieldConverter(com.silanis.esl.api.model.Field apiField) {
        this.apiField = apiField;
    }

    public FieldConverter(Field sdkField) {
        this.sdkField = sdkField;
    }

    public com.silanis.esl.api.model.Field toAPIField() {
        if (this.sdkField == null) {
            return this.apiField;
        }
        com.silanis.esl.api.model.Field result = new com.silanis.esl.api.model.Field();
        result.setPage(this.sdkField.getPage());
        result.setExtract(this.sdkField.isExtraction());
        if (this.sdkField.getName() != null) {
            result.setName(this.sdkField.getName());
        }
        if (!this.sdkField.isExtraction()) {
            result.setLeft(this.sdkField.getX());
            result.setTop(this.sdkField.getY());
            result.setWidth(this.sdkField.getWidth());
            result.setHeight(this.sdkField.getHeight());
        }
        result.setValue(this.sdkField.getValue());
        result.setType(FieldType.INPUT);
        result.setSubtype(new FieldStyleAndSubTypeConverter(this.sdkField.getStyle()).toAPIFieldSubtype());
        result.setBinding(this.sdkField.getBinding());
        if (this.sdkField.getId() != null) {
            result.setId(this.sdkField.getId().toString());
        }
        if (this.sdkField.getFieldValidator() != null) {
            result.setValidation(new FieldValidatorConverter(this.sdkField.getFieldValidator()).toAPIFieldValidation());
        }
        if (this.sdkField.getTextAnchor() != null) {
            result.setExtractAnchor(new TextAnchorConverter(this.sdkField.getTextAnchor()).toAPIExtractAnchor());
        }
        return result;
    }

    public Field toSDKField() {
        if (this.apiField == null) {
            return this.sdkField;
        }
        Field result = new Field();
        result.setExtraction(this.apiField.getExtract());
        result.setFieldValidator(new FieldValidatorConverter(this.apiField.getValidation()).toSDKFieldValidator());
        result.setHeight(this.apiField.getHeight());
        result.setId(new FieldId(this.apiField.getId()));
        result.setName(this.apiField.getName());
        result.setPage(this.apiField.getPage());
        result.setStyle(new FieldStyleAndSubTypeConverter(this.apiField.getSubtype(), this.apiField.getBinding()).toSDKFieldStyle());
        result.setTextAnchor(new TextAnchorConverter(this.apiField.getExtractAnchor()).toSDKTextAnchor());
        result.setValue(this.apiField.getValue());
        result.setX(this.apiField.getLeft());
        result.setY(this.apiField.getTop());
        result.setWidth(this.apiField.getWidth());
        return result;
    }
}

