/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.FieldSubtype;
import com.silanis.esl.sdk.FieldStyle;
import com.silanis.esl.sdk.internal.ConversionException;

public class FieldStyleAndSubTypeConverter {
    private static final String BINDING_DATE = "{approval.signed}";
    private static final String BINDING_TITLE = "{signer.title}";
    private static final String BINDING_NAME = "{signer.name}";
    private static final String BINDING_COMPANY = "{signer.company}";
    FieldStyle sdkFieldStyle = null;
    FieldSubtype apiFieldSubType = null;
    String apiFieldBinding = null;

    public FieldStyleAndSubTypeConverter(FieldStyle sdkFieldStyle) {
        this.sdkFieldStyle = sdkFieldStyle;
    }

    public FieldStyleAndSubTypeConverter(FieldSubtype apiFieldSubType, String apiFieldBinding) {
        this.apiFieldSubType = apiFieldSubType;
        this.apiFieldBinding = apiFieldBinding;
    }

    public FieldSubtype toAPIFieldSubtype() {
        if (this.sdkFieldStyle == null) {
            return this.apiFieldSubType;
        }
        switch (this.sdkFieldStyle) {
            case UNBOUND_TEXT_FIELD: {
                return FieldSubtype.TEXTFIELD;
            }
            case UNBOUND_CUSTOM_FIELD: {
                return FieldSubtype.CUSTOMFIELD;
            }
            case BOUND_DATE: 
            case BOUND_NAME: 
            case BOUND_TITLE: 
            case BOUND_COMPANY: 
            case LABEL: {
                return FieldSubtype.LABEL;
            }
            case UNBOUND_CHECK_BOX: {
                return FieldSubtype.CHECKBOX;
            }
        }
        throw new ConversionException(FieldStyle.class, FieldSubtype.class, "Unable to decode the field subtype.");
    }

    public FieldStyle toSDKFieldStyle() {
        if (this.apiFieldSubType == null && this.apiFieldBinding == null) {
            return this.sdkFieldStyle;
        }
        if (this.apiFieldBinding == null) {
            switch (this.apiFieldSubType) {
                case TEXTFIELD: {
                    return FieldStyle.UNBOUND_TEXT_FIELD;
                }
                case CUSTOMFIELD: {
                    return FieldStyle.UNBOUND_CUSTOM_FIELD;
                }
                case CHECKBOX: {
                    return FieldStyle.UNBOUND_CHECK_BOX;
                }
            }
            throw new ConversionException(FieldSubtype.class, FieldStyle.class, "Unable to decode the field subtype.");
        }
        String binding = this.apiFieldBinding;
        if (binding.equals(BINDING_DATE)) {
            return FieldStyle.BOUND_DATE;
        }
        if (binding.equals(BINDING_TITLE)) {
            return FieldStyle.BOUND_TITLE;
        }
        if (binding.equals(BINDING_NAME)) {
            return FieldStyle.BOUND_NAME;
        }
        if (binding.equals(BINDING_COMPANY)) {
            return FieldStyle.BOUND_COMPANY;
        }
        throw new ConversionException(FieldSubtype.class, FieldStyle.class, "Unable to decode the field subtype.");
    }
}

