/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.sdk.Group;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.GroupMember;
import com.silanis.esl.sdk.builder.GroupBuilder;
import com.silanis.esl.sdk.internal.converter.GroupMemberConverter;
import java.util.ArrayList;

public class GroupConverter {
    private Group sdkGroup = null;
    private com.silanis.esl.api.model.Group apiGroup = null;

    public GroupConverter(com.silanis.esl.api.model.Group apiGroup) {
        this.apiGroup = apiGroup;
    }

    public GroupConverter(Group sdkGroup) {
        this.sdkGroup = sdkGroup;
    }

    public com.silanis.esl.api.model.Group toAPIGroup() {
        if (this.sdkGroup == null) {
            return this.apiGroup;
        }
        com.silanis.esl.api.model.Group result = this.toAPIGroupWithoutMembers();
        ArrayList<com.silanis.esl.api.model.GroupMember> apiMembers = new ArrayList<com.silanis.esl.api.model.GroupMember>();
        for (GroupMember sdkGroupMember : this.sdkGroup.getMembers()) {
            apiMembers.add(new GroupMemberConverter(sdkGroupMember).toAPIGroupMember());
        }
        result.setMembers(apiMembers);
        return result;
    }

    public com.silanis.esl.api.model.Group toAPIGroupWithoutMembers() {
        if (this.sdkGroup == null) {
            return this.apiGroup;
        }
        com.silanis.esl.api.model.Group result = new com.silanis.esl.api.model.Group();
        result.setName(this.sdkGroup.getName());
        result.safeSetCreated(this.sdkGroup.getCreated());
        result.safeSetUpdated(this.sdkGroup.getUpdated());
        result.setEmail(this.sdkGroup.getEmail());
        result.setEmailMembers(this.sdkGroup.getEmailMembers());
        if (this.sdkGroup.getId() != null) {
            result.safeSetId(this.sdkGroup.getId().getId());
        }
        return result;
    }

    public Group toSDKGroup() {
        if (this.apiGroup == null) {
            return this.sdkGroup;
        }
        GroupBuilder builder = GroupBuilder.newGroup(this.apiGroup.getName()).withEmail(this.apiGroup.getEmail());
        builder = this.apiGroup.getEmailMembers() != false ? builder.withIndividualMemberEmailing() : builder.withoutIndividualMemberEmailing();
        if (this.apiGroup.getId() != null) {
            builder.withId(new GroupId(this.apiGroup.getId()));
        }
        Group result = builder.build();
        for (com.silanis.esl.api.model.GroupMember apiGroupMember : this.apiGroup.getMembers()) {
            GroupMember sdkGroupMember = new GroupMemberConverter(apiGroupMember).toSDKGroupMember();
            result.getMembers().add(sdkGroupMember);
        }
        return result;
    }
}

