/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.MemberType;
import com.silanis.esl.sdk.GroupMemberType;
import com.silanis.esl.sdk.builder.BuilderException;

public class GroupMemberTypeConverter {
    private GroupMemberType sdkMemberType = null;
    private MemberType apiMemberType = null;

    public GroupMemberTypeConverter(MemberType apiMemberType) {
        this.apiMemberType = apiMemberType;
    }

    public GroupMemberTypeConverter(GroupMemberType sdkMemberType) {
        this.sdkMemberType = sdkMemberType;
    }

    public MemberType toAPIGroupMemberType() {
        if (this.sdkMemberType == null) {
            return this.apiMemberType;
        }
        switch (this.sdkMemberType) {
            case MANAGER: {
                return MemberType.MANAGER;
            }
            case REGULAR: {
                return MemberType.REGULAR;
            }
        }
        throw new BuilderException("Unrecognized group member type.");
    }

    public GroupMemberType toSDKGroupMemberType() {
        if (this.apiMemberType == null) {
            return this.sdkMemberType;
        }
        switch (this.apiMemberType) {
            case MANAGER: {
                return GroupMemberType.MANAGER;
            }
            case REGULAR: {
                return GroupMemberType.REGULAR;
            }
        }
        throw new BuilderException("Unrecognized group member type.");
    }
}

